--
-- PostgreSQL database dump
--

\restrict Uvd1vmXweAkedmUWav3sn2a9dd5azgEjvyWawIiVLJqVTgMagOCo4SsbIdPV8CI

-- Dumped from database version 16.10 (Ubuntu 16.10-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 18.0 (Ubuntu 18.0-1.pgdg24.04+3)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: queue_job_notify(); Type: FUNCTION; Schema: public; Owner: runbot
--

CREATE FUNCTION public.queue_job_notify() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
            BEGIN
                IF TG_OP = 'DELETE' THEN
                    IF OLD.state != 'done' THEN
                        PERFORM pg_notify('queue_job', OLD.uuid);
                    END IF;
                ELSE
                    PERFORM pg_notify('queue_job', NEW.uuid);
                END IF;
                RETURN NULL;
            END;
            $$;


ALTER FUNCTION public.queue_job_notify() OWNER TO runbot;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: account_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account (
    id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    account_type character varying NOT NULL,
    name jsonb NOT NULL,
    code_store jsonb,
    note text,
    deprecated boolean,
    reconcile boolean,
    non_trade boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_account OWNER TO runbot;

--
-- Name: TABLE account_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account IS 'Account';


--
-- Name: COLUMN account_account.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.currency_id IS 'Account Currency';


--
-- Name: COLUMN account_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account.account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.account_type IS 'Type';


--
-- Name: COLUMN account_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.name IS 'Account Name';


--
-- Name: COLUMN account_account.code_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.code_store IS 'Code Store';


--
-- Name: COLUMN account_account.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.note IS 'Internal Notes';


--
-- Name: COLUMN account_account.deprecated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.deprecated IS 'Deprecated';


--
-- Name: COLUMN account_account.reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.reconcile IS 'Allow Reconciliation';


--
-- Name: COLUMN account_account.non_trade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.non_trade IS 'Non Trade';


--
-- Name: COLUMN account_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_date IS 'Created on';


--
-- Name: COLUMN account_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.write_date IS 'Last Updated on';


--
-- Name: account_account_account_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_journal_rel (
    account_account_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_account_account_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_journal_rel IS 'RELATION BETWEEN account_account AND account_journal';


--
-- Name: account_account_account_merge_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_merge_wizard_rel (
    account_merge_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_merge_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_merge_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_merge_wizard_rel IS 'RELATION BETWEEN account_merge_wizard AND account_account';


--
-- Name: account_account_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_tag (
    account_account_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_tag IS 'RELATION BETWEEN account_account AND account_account_tag';


--
-- Name: account_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_id_seq OWNER TO runbot;

--
-- Name: account_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_id_seq OWNED BY public.account_account.id;


--
-- Name: account_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_res_company_rel (
    account_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.account_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_res_company_rel IS 'RELATION BETWEEN account_account AND res_company';


--
-- Name: account_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag (
    id integer NOT NULL,
    color integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    applicability character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    tax_negate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag IS 'Account Tag';


--
-- Name: COLUMN account_account_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.color IS 'Color Index';


--
-- Name: COLUMN account_account_tag.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.country_id IS 'Country';


--
-- Name: COLUMN account_account_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_tag.applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.applicability IS 'Applicability';


--
-- Name: COLUMN account_account_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.name IS 'Tag Name';


--
-- Name: COLUMN account_account_tag.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.active IS 'Active';


--
-- Name: COLUMN account_account_tag.tax_negate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.tax_negate IS 'Negate Tax Balance';


--
-- Name: COLUMN account_account_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.create_date IS 'Created on';


--
-- Name: COLUMN account_account_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.write_date IS 'Last Updated on';


--
-- Name: account_account_tag_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_account_move_line_rel (
    account_move_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_account_move_line_rel IS 'RELATION BETWEEN account_move_line AND account_account_tag';


--
-- Name: account_account_tag_account_tax_repartition_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_account_tax_repartition_line_rel (
    account_tax_repartition_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_tax_repartition_line_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_account_tax_repartition_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_account_tax_repartition_line_rel IS 'RELATION BETWEEN account_tax_repartition_line AND account_account_tag';


--
-- Name: account_account_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_tag_id_seq OWNER TO runbot;

--
-- Name: account_account_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_tag_id_seq OWNED BY public.account_account_tag.id;


--
-- Name: account_account_tag_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_product_template_rel (
    product_template_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_product_template_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_product_template_rel IS 'RELATION BETWEEN product_template AND account_account_tag';


--
-- Name: account_account_tax_default_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tax_default_rel (
    account_id integer NOT NULL,
    tax_id integer NOT NULL
);


ALTER TABLE public.account_account_tax_default_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tax_default_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tax_default_rel IS 'RELATION BETWEEN account_account AND account_tax';


--
-- Name: account_accrued_orders_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_accrued_orders_wizard (
    id integer NOT NULL,
    company_id integer,
    journal_id integer NOT NULL,
    currency_id integer,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    reversal_date date NOT NULL,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_accrued_orders_wizard OWNER TO runbot;

--
-- Name: TABLE account_accrued_orders_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_accrued_orders_wizard IS 'Accrued Orders Wizard';


--
-- Name: COLUMN account_accrued_orders_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_accrued_orders_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_accrued_orders_wizard.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.currency_id IS 'Company Currency';


--
-- Name: COLUMN account_accrued_orders_wizard.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.account_id IS 'Accrual Account';


--
-- Name: COLUMN account_accrued_orders_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_accrued_orders_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_accrued_orders_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.date IS 'Date';


--
-- Name: COLUMN account_accrued_orders_wizard.reversal_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.reversal_date IS 'Reversal Date';


--
-- Name: COLUMN account_accrued_orders_wizard.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.amount IS 'Amount';


--
-- Name: COLUMN account_accrued_orders_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_accrued_orders_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_date IS 'Last Updated on';


--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_accrued_orders_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNER TO runbot;

--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNED BY public.account_accrued_orders_wizard.id;


--
-- Name: account_analytic_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account (
    id integer NOT NULL,
    plan_id integer NOT NULL,
    root_plan_id integer,
    company_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_account OWNER TO runbot;

--
-- Name: TABLE account_analytic_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.plan_id IS 'Plan';


--
-- Name: COLUMN account_analytic_account.root_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.root_plan_id IS 'Root Plan';


--
-- Name: COLUMN account_analytic_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_account.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.partner_id IS 'Customer';


--
-- Name: COLUMN account_analytic_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_account.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.code IS 'Reference';


--
-- Name: COLUMN account_analytic_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.name IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.active IS 'Active';


--
-- Name: COLUMN account_analytic_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_date IS 'Last Updated on';


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_account_id_seq OWNER TO runbot;

--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_account_id_seq OWNED BY public.account_analytic_account.id;


--
-- Name: account_analytic_applicability; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_applicability (
    id integer NOT NULL,
    analytic_plan_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    business_domain character varying NOT NULL,
    applicability character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_categ_id integer,
    account_prefix character varying
);


ALTER TABLE public.account_analytic_applicability OWNER TO runbot;

--
-- Name: TABLE account_analytic_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_applicability IS 'Analytic Plan''s Applicabilities';


--
-- Name: COLUMN account_analytic_applicability.analytic_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.analytic_plan_id IS 'Analytic Plan';


--
-- Name: COLUMN account_analytic_applicability.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_applicability.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_applicability.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_applicability.business_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.business_domain IS 'Domain';


--
-- Name: COLUMN account_analytic_applicability.applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.applicability IS 'Applicability';


--
-- Name: COLUMN account_analytic_applicability.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_applicability.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_applicability.product_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_applicability.account_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.account_prefix IS 'Financial Accounts Prefixes';


--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_applicability_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNER TO runbot;

--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNED BY public.account_analytic_applicability.id;


--
-- Name: account_analytic_distribution_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_distribution_model (
    id integer NOT NULL,
    sequence integer,
    partner_id integer,
    partner_category_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    analytic_distribution jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_id integer,
    product_categ_id integer,
    account_prefix character varying
);


ALTER TABLE public.account_analytic_distribution_model OWNER TO runbot;

--
-- Name: TABLE account_analytic_distribution_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_distribution_model IS 'Analytic Distribution Model';


--
-- Name: COLUMN account_analytic_distribution_model.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_distribution_model.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_distribution_model.partner_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_category_id IS 'Partner Category';


--
-- Name: COLUMN account_analytic_distribution_model.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_distribution_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_distribution_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_distribution_model.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_analytic_distribution_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_distribution_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_distribution_model.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_distribution_model.product_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_distribution_model.account_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.account_prefix IS 'Accounts Prefix';


--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_distribution_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNER TO runbot;

--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNED BY public.account_analytic_distribution_model.id;


--
-- Name: account_analytic_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line (
    id integer NOT NULL,
    account_id integer,
    product_uom_id integer,
    partner_id integer,
    user_id integer,
    company_id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    category character varying,
    date date NOT NULL,
    amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    unit_amount double precision,
    x_plan2_id integer,
    x_plan3_id integer,
    product_id integer,
    general_account_id integer,
    journal_id integer,
    move_line_id integer,
    code character varying(8),
    ref character varying,
    so_line integer
);


ALTER TABLE public.account_analytic_line OWNER TO runbot;

--
-- Name: TABLE account_analytic_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line IS 'Analytic Line';


--
-- Name: COLUMN account_analytic_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.account_id IS 'Project Account';


--
-- Name: COLUMN account_analytic_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_analytic_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_line.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_analytic_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.name IS 'Description';


--
-- Name: COLUMN account_analytic_line.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.category IS 'Category';


--
-- Name: COLUMN account_analytic_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.date IS 'Date';


--
-- Name: COLUMN account_analytic_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.amount IS 'Amount';


--
-- Name: COLUMN account_analytic_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_line.unit_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.unit_amount IS 'Quantity';


--
-- Name: COLUMN account_analytic_line.x_plan2_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.x_plan2_id IS 'Departments';


--
-- Name: COLUMN account_analytic_line.x_plan3_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.x_plan3_id IS 'Internal';


--
-- Name: COLUMN account_analytic_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_line.general_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.general_account_id IS 'Financial Account';


--
-- Name: COLUMN account_analytic_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.journal_id IS 'Financial Journal';


--
-- Name: COLUMN account_analytic_line.move_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.move_line_id IS 'Journal Item';


--
-- Name: COLUMN account_analytic_line.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.code IS 'Code';


--
-- Name: COLUMN account_analytic_line.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.ref IS 'Ref.';


--
-- Name: COLUMN account_analytic_line.so_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.so_line IS 'Sales Order Item';


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_line_id_seq OWNER TO runbot;

--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_line_id_seq OWNED BY public.account_analytic_line.id;


--
-- Name: account_analytic_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_plan (
    id integer NOT NULL,
    parent_id integer,
    color integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    complete_name character varying,
    name jsonb NOT NULL,
    default_applicability jsonb,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_plan OWNER TO runbot;

--
-- Name: TABLE account_analytic_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_plan IS 'Analytic Plans';


--
-- Name: COLUMN account_analytic_plan.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_id IS 'Parent';


--
-- Name: COLUMN account_analytic_plan.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.color IS 'Color';


--
-- Name: COLUMN account_analytic_plan.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_plan.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_path IS 'Parent Path';


--
-- Name: COLUMN account_analytic_plan.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.complete_name IS 'Complete Name';


--
-- Name: COLUMN account_analytic_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.name IS 'Name';


--
-- Name: COLUMN account_analytic_plan.default_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.default_applicability IS 'Default Applicability';


--
-- Name: COLUMN account_analytic_plan.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.description IS 'Description';


--
-- Name: COLUMN account_analytic_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_date IS 'Last Updated on';


--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_plan_id_seq OWNER TO runbot;

--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_plan_id_seq OWNED BY public.account_analytic_plan.id;


--
-- Name: account_automatic_entry_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_automatic_entry_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    destination_account_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    account_type character varying,
    date date NOT NULL,
    total_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percentage double precision
);


ALTER TABLE public.account_automatic_entry_wizard OWNER TO runbot;

--
-- Name: TABLE account_automatic_entry_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_automatic_entry_wizard IS 'Create Automatic Entries';


--
-- Name: COLUMN account_automatic_entry_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_automatic_entry_wizard.destination_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.destination_account_id IS 'To';


--
-- Name: COLUMN account_automatic_entry_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_automatic_entry_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_automatic_entry_wizard.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.action IS 'Action';


--
-- Name: COLUMN account_automatic_entry_wizard.account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.account_type IS 'Account Type';


--
-- Name: COLUMN account_automatic_entry_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.date IS 'Date';


--
-- Name: COLUMN account_automatic_entry_wizard.total_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.total_amount IS 'Total Amount';


--
-- Name: COLUMN account_automatic_entry_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_automatic_entry_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_automatic_entry_wizard.percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.percentage IS 'Percentage';


--
-- Name: account_automatic_entry_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_automatic_entry_wizard_account_move_line_rel (
    account_automatic_entry_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_automatic_entry_wizard_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_automatic_entry_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_automatic_entry_wizard_account_move_line_rel IS 'RELATION BETWEEN account_automatic_entry_wizard AND account_move_line';


--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_automatic_entry_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNER TO runbot;

--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNED BY public.account_automatic_entry_wizard.id;


--
-- Name: account_autopost_bills_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_autopost_bills_wizard (
    id integer NOT NULL,
    partner_id integer,
    nb_unmodified_bills integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_autopost_bills_wizard OWNER TO runbot;

--
-- Name: TABLE account_autopost_bills_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_autopost_bills_wizard IS 'Autopost Bills Wizard';


--
-- Name: COLUMN account_autopost_bills_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN account_autopost_bills_wizard.nb_unmodified_bills; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.nb_unmodified_bills IS 'Number of bills previously unmodified from this partner';


--
-- Name: COLUMN account_autopost_bills_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_autopost_bills_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_autopost_bills_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_autopost_bills_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.write_date IS 'Last Updated on';


--
-- Name: account_autopost_bills_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_autopost_bills_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_autopost_bills_wizard_id_seq OWNER TO runbot;

--
-- Name: account_autopost_bills_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_autopost_bills_wizard_id_seq OWNED BY public.account_autopost_bills_wizard.id;


--
-- Name: account_bank_statement; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement (
    id integer NOT NULL,
    company_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    reference character varying,
    first_line_index character varying,
    date date,
    balance_start numeric,
    balance_end numeric,
    balance_end_real numeric,
    is_complete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_bank_statement OWNER TO runbot;

--
-- Name: TABLE account_bank_statement; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement IS 'Bank Statement';


--
-- Name: COLUMN account_bank_statement.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.name IS 'Reference';


--
-- Name: COLUMN account_bank_statement.reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.reference IS 'External Reference';


--
-- Name: COLUMN account_bank_statement.first_line_index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.first_line_index IS 'First Line Index';


--
-- Name: COLUMN account_bank_statement.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.date IS 'Date';


--
-- Name: COLUMN account_bank_statement.balance_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_start IS 'Starting Balance';


--
-- Name: COLUMN account_bank_statement.balance_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_end IS 'Computed Balance';


--
-- Name: COLUMN account_bank_statement.balance_end_real; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_end_real IS 'Ending Balance';


--
-- Name: COLUMN account_bank_statement.is_complete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.is_complete IS 'Is Complete';


--
-- Name: COLUMN account_bank_statement.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.write_date IS 'Last Updated on';


--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_id_seq OWNED BY public.account_bank_statement.id;


--
-- Name: account_bank_statement_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_ir_attachment_rel (
    account_bank_statement_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_bank_statement_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_ir_attachment_rel IS 'RELATION BETWEEN account_bank_statement AND ir_attachment';


--
-- Name: account_bank_statement_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    statement_id integer,
    sequence integer,
    partner_id integer,
    currency_id integer,
    foreign_currency_id integer,
    create_uid integer,
    write_uid integer,
    account_number character varying,
    partner_name character varying,
    transaction_type character varying,
    payment_ref character varying,
    internal_index character varying,
    transaction_details jsonb,
    amount numeric,
    amount_currency numeric,
    is_reconciled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount_residual double precision
);


ALTER TABLE public.account_bank_statement_line OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_line IS 'Bank Statement Line';


--
-- Name: COLUMN account_bank_statement_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_bank_statement_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement_line.statement_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_bank_statement_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_bank_statement_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.currency_id IS 'Journal Currency';


--
-- Name: COLUMN account_bank_statement_line.foreign_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.foreign_currency_id IS 'Foreign Currency';


--
-- Name: COLUMN account_bank_statement_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.account_number IS 'Bank Account Number';


--
-- Name: COLUMN account_bank_statement_line.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line.transaction_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_bank_statement_line.payment_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.payment_ref IS 'Label';


--
-- Name: COLUMN account_bank_statement_line.internal_index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.internal_index IS 'Internal Reference';


--
-- Name: COLUMN account_bank_statement_line.transaction_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_details IS 'Transaction Details';


--
-- Name: COLUMN account_bank_statement_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_bank_statement_line.is_reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_bank_statement_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement_line.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_residual IS 'Residual Amount';


--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNED BY public.account_bank_statement_line.id;


--
-- Name: account_cash_rounding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cash_rounding (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    strategy character varying NOT NULL,
    rounding_method character varying NOT NULL,
    name jsonb NOT NULL,
    profit_account_id jsonb,
    loss_account_id jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rounding double precision NOT NULL
);


ALTER TABLE public.account_cash_rounding OWNER TO runbot;

--
-- Name: TABLE account_cash_rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cash_rounding IS 'Account Cash Rounding';


--
-- Name: COLUMN account_cash_rounding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.create_uid IS 'Created by';


--
-- Name: COLUMN account_cash_rounding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cash_rounding.strategy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.strategy IS 'Rounding Strategy';


--
-- Name: COLUMN account_cash_rounding.rounding_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.rounding_method IS 'Rounding Method';


--
-- Name: COLUMN account_cash_rounding.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.name IS 'Name';


--
-- Name: COLUMN account_cash_rounding.profit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_cash_rounding.loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_cash_rounding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.create_date IS 'Created on';


--
-- Name: COLUMN account_cash_rounding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_cash_rounding.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.rounding IS 'Rounding Precision';


--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cash_rounding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cash_rounding_id_seq OWNER TO runbot;

--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cash_rounding_id_seq OWNED BY public.account_cash_rounding.id;


--
-- Name: account_financial_year_op; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_financial_year_op (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_financial_year_op OWNER TO runbot;

--
-- Name: TABLE account_financial_year_op; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_financial_year_op IS 'Opening Balance of Financial Year';


--
-- Name: COLUMN account_financial_year_op.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.company_id IS 'Company';


--
-- Name: COLUMN account_financial_year_op.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.create_uid IS 'Created by';


--
-- Name: COLUMN account_financial_year_op.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_financial_year_op.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.create_date IS 'Created on';


--
-- Name: COLUMN account_financial_year_op.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.write_date IS 'Last Updated on';


--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_financial_year_op_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_financial_year_op_id_seq OWNER TO runbot;

--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_financial_year_op_id_seq OWNED BY public.account_financial_year_op.id;


--
-- Name: account_fiscal_position; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    country_id integer,
    country_group_id integer,
    create_uid integer,
    write_uid integer,
    zip_from character varying,
    zip_to character varying,
    foreign_vat character varying,
    name jsonb NOT NULL,
    note jsonb,
    active boolean,
    auto_apply boolean,
    vat_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.sequence IS 'Sequence';


--
-- Name: COLUMN account_fiscal_position.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.country_id IS 'Country';


--
-- Name: COLUMN account_fiscal_position.country_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.country_group_id IS 'Country Group';


--
-- Name: COLUMN account_fiscal_position.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position.zip_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.zip_from IS 'Zip Range From';


--
-- Name: COLUMN account_fiscal_position.zip_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.zip_to IS 'Zip Range To';


--
-- Name: COLUMN account_fiscal_position.foreign_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.foreign_vat IS 'Foreign Tax ID';


--
-- Name: COLUMN account_fiscal_position.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.name IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.note IS 'Notes';


--
-- Name: COLUMN account_fiscal_position.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.active IS 'Active';


--
-- Name: COLUMN account_fiscal_position.auto_apply; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.auto_apply IS 'Detect Automatically';


--
-- Name: COLUMN account_fiscal_position.vat_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.vat_required IS 'VAT required';


--
-- Name: COLUMN account_fiscal_position.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_account (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    account_src_id integer NOT NULL,
    account_dest_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_account OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_account IS 'Accounts Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_account.account_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_src_id IS 'Account on Product';


--
-- Name: COLUMN account_fiscal_position_account.account_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_dest_id IS 'Account to Use Instead';


--
-- Name: COLUMN account_fiscal_position_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNED BY public.account_fiscal_position_account.id;


--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_id_seq OWNED BY public.account_fiscal_position.id;


--
-- Name: account_fiscal_position_res_country_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_res_country_state_rel (
    account_fiscal_position_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_res_country_state_rel OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_res_country_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_res_country_state_rel IS 'RELATION BETWEEN account_fiscal_position AND res_country_state';


--
-- Name: account_fiscal_position_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_tax (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    tax_src_id integer NOT NULL,
    tax_dest_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_tax OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_tax IS 'Tax Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_tax.tax_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_src_id IS 'Tax on Product';


--
-- Name: COLUMN account_fiscal_position_tax.tax_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_dest_id IS 'Tax to Apply';


--
-- Name: COLUMN account_fiscal_position_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_tax_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_tax_id_seq OWNED BY public.account_fiscal_position_tax.id;


--
-- Name: account_full_reconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_full_reconcile (
    id integer NOT NULL,
    exchange_move_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_full_reconcile OWNER TO runbot;

--
-- Name: TABLE account_full_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_full_reconcile IS 'Full Reconcile';


--
-- Name: COLUMN account_full_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_full_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_full_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_full_reconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_full_reconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_full_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_full_reconcile_id_seq OWNER TO runbot;

--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_full_reconcile_id_seq OWNED BY public.account_full_reconcile.id;


--
-- Name: account_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_group (
    id integer NOT NULL,
    parent_id integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code_prefix_start character varying,
    code_prefix_end character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_group_check_length_prefix CHECK ((char_length((COALESCE(code_prefix_start, ''::character varying))::text) = char_length((COALESCE(code_prefix_end, ''::character varying))::text)))
);


ALTER TABLE public.account_group OWNER TO runbot;

--
-- Name: TABLE account_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_group IS 'Account Group';


--
-- Name: COLUMN account_group.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.parent_id IS 'Parent';


--
-- Name: COLUMN account_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.company_id IS 'Company';


--
-- Name: COLUMN account_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_group.code_prefix_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.code_prefix_start IS 'Code Prefix Start';


--
-- Name: COLUMN account_group.code_prefix_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.code_prefix_end IS 'Code Prefix End';


--
-- Name: COLUMN account_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.name IS 'Name';


--
-- Name: COLUMN account_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.create_date IS 'Created on';


--
-- Name: COLUMN account_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_group_check_length_prefix ON account_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_group_check_length_prefix ON public.account_group IS 'CHECK(char_length(COALESCE(code_prefix_start, '''')) = char_length(COALESCE(code_prefix_end, '''')))';


--
-- Name: account_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_group_id_seq OWNER TO runbot;

--
-- Name: account_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_group_id_seq OWNED BY public.account_group.id;


--
-- Name: account_incoterms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_incoterms (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying(3) NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_incoterms OWNER TO runbot;

--
-- Name: TABLE account_incoterms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_incoterms IS 'Incoterms';


--
-- Name: COLUMN account_incoterms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.create_uid IS 'Created by';


--
-- Name: COLUMN account_incoterms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_incoterms.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.code IS 'Code';


--
-- Name: COLUMN account_incoterms.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.name IS 'Name';


--
-- Name: COLUMN account_incoterms.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.active IS 'Active';


--
-- Name: COLUMN account_incoterms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.create_date IS 'Created on';


--
-- Name: COLUMN account_incoterms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.write_date IS 'Last Updated on';


--
-- Name: account_incoterms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_incoterms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_incoterms_id_seq OWNER TO runbot;

--
-- Name: account_incoterms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_incoterms_id_seq OWNED BY public.account_incoterms.id;


--
-- Name: account_invoice_transaction_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_transaction_rel (
    invoice_id integer NOT NULL,
    transaction_id integer NOT NULL
);


ALTER TABLE public.account_invoice_transaction_rel OWNER TO runbot;

--
-- Name: TABLE account_invoice_transaction_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_transaction_rel IS 'RELATION BETWEEN account_move AND payment_transaction';


--
-- Name: account_journal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal (
    id integer NOT NULL,
    alias_id integer,
    default_account_id integer,
    suspense_account_id integer,
    sequence integer,
    currency_id integer,
    company_id integer NOT NULL,
    profit_account_id integer,
    loss_account_id integer,
    bank_account_id integer,
    create_uid integer,
    write_uid integer,
    color integer,
    access_token character varying,
    code character varying(5) NOT NULL,
    type character varying NOT NULL,
    invoice_reference_type character varying NOT NULL,
    invoice_reference_model character varying NOT NULL,
    bank_statements_source character varying,
    name jsonb NOT NULL,
    sequence_override_regex text,
    active boolean,
    autocheck_on_post boolean,
    restrict_mode_hash_table boolean,
    refund_sequence boolean,
    payment_sequence boolean,
    show_on_dashboard boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_journal OWNER TO runbot;

--
-- Name: TABLE account_journal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal IS 'Journal';


--
-- Name: COLUMN account_journal.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.alias_id IS 'Alias';


--
-- Name: COLUMN account_journal.default_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.default_account_id IS 'Default Account';


--
-- Name: COLUMN account_journal.suspense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.suspense_account_id IS 'Suspense Account';


--
-- Name: COLUMN account_journal.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.currency_id IS 'Currency';


--
-- Name: COLUMN account_journal.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.company_id IS 'Company';


--
-- Name: COLUMN account_journal.profit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_journal.loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_journal.bank_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN account_journal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.color IS 'Color Index';


--
-- Name: COLUMN account_journal.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.access_token IS 'Security Token';


--
-- Name: COLUMN account_journal.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.code IS 'Short Code';


--
-- Name: COLUMN account_journal.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.type IS 'Type';


--
-- Name: COLUMN account_journal.invoice_reference_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_reference_type IS 'Communication Type';


--
-- Name: COLUMN account_journal.invoice_reference_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_reference_model IS 'Communication Standard';


--
-- Name: COLUMN account_journal.bank_statements_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_statements_source IS 'Bank Feeds';


--
-- Name: COLUMN account_journal.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.name IS 'Journal Name';


--
-- Name: COLUMN account_journal.sequence_override_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sequence_override_regex IS 'Sequence Override Regex';


--
-- Name: COLUMN account_journal.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.active IS 'Active';


--
-- Name: COLUMN account_journal.autocheck_on_post; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.autocheck_on_post IS 'Auto-Check on Post';


--
-- Name: COLUMN account_journal.restrict_mode_hash_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.restrict_mode_hash_table IS 'Secure Posted Entries with Hash';


--
-- Name: COLUMN account_journal.refund_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.refund_sequence IS 'Dedicated Credit Note Sequence';


--
-- Name: COLUMN account_journal.payment_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.payment_sequence IS 'Dedicated Payment Sequence';


--
-- Name: COLUMN account_journal.show_on_dashboard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.show_on_dashboard IS 'Show journal on dashboard';


--
-- Name: COLUMN account_journal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_journal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.write_date IS 'Last Updated on';


--
-- Name: account_journal_account_journal_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_journal_group_rel (
    account_journal_group_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_journal_group_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_journal_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_journal_group_rel IS 'RELATION BETWEEN account_journal_group AND account_journal';


--
-- Name: account_journal_account_reconcile_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_reconcile_model_rel (
    account_reconcile_model_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_reconcile_model_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_reconcile_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_reconcile_model_rel IS 'RELATION BETWEEN account_reconcile_model AND account_journal';


--
-- Name: account_journal_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_group (
    id integer NOT NULL,
    company_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_journal_group OWNER TO runbot;

--
-- Name: TABLE account_journal_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_group IS 'Account Journal Group';


--
-- Name: COLUMN account_journal_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.company_id IS 'Company';


--
-- Name: COLUMN account_journal_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.name IS 'Ledger group';


--
-- Name: COLUMN account_journal_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.write_date IS 'Last Updated on';


--
-- Name: account_journal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_group_id_seq OWNER TO runbot;

--
-- Name: account_journal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_group_id_seq OWNED BY public.account_journal_group.id;


--
-- Name: account_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_id_seq OWNER TO runbot;

--
-- Name: account_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_id_seq OWNED BY public.account_journal.id;


--
-- Name: account_lock_exception; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_lock_exception (
    id integer NOT NULL,
    company_id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    reason character varying,
    lock_date_field character varying NOT NULL,
    lock_date date,
    company_lock_date date,
    active boolean,
    end_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_lock_exception OWNER TO runbot;

--
-- Name: TABLE account_lock_exception; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_lock_exception IS 'Account Lock Exception';


--
-- Name: COLUMN account_lock_exception.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.company_id IS 'Company';


--
-- Name: COLUMN account_lock_exception.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.user_id IS 'User';


--
-- Name: COLUMN account_lock_exception.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.create_uid IS 'Created by';


--
-- Name: COLUMN account_lock_exception.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_lock_exception.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.reason IS 'Reason';


--
-- Name: COLUMN account_lock_exception.lock_date_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.lock_date_field IS 'Lock Date Field';


--
-- Name: COLUMN account_lock_exception.lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.lock_date IS 'Changed Lock Date';


--
-- Name: COLUMN account_lock_exception.company_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.company_lock_date IS 'Original Lock Date';


--
-- Name: COLUMN account_lock_exception.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.active IS 'Active';


--
-- Name: COLUMN account_lock_exception.end_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.end_datetime IS 'End Date';


--
-- Name: COLUMN account_lock_exception.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.create_date IS 'Created on';


--
-- Name: COLUMN account_lock_exception.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.write_date IS 'Last Updated on';


--
-- Name: account_lock_exception_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_lock_exception_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_lock_exception_id_seq OWNER TO runbot;

--
-- Name: account_lock_exception_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_lock_exception_id_seq OWNED BY public.account_lock_exception.id;


--
-- Name: account_merge_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_merge_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    is_group_by_name boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_merge_wizard OWNER TO runbot;

--
-- Name: TABLE account_merge_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_merge_wizard IS 'Account merge wizard';


--
-- Name: COLUMN account_merge_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_merge_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_merge_wizard.is_group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.is_group_by_name IS 'Group by name?';


--
-- Name: COLUMN account_merge_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_merge_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.write_date IS 'Last Updated on';


--
-- Name: account_merge_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_merge_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_merge_wizard_id_seq OWNER TO runbot;

--
-- Name: account_merge_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_merge_wizard_id_seq OWNED BY public.account_merge_wizard.id;


--
-- Name: account_merge_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_merge_wizard_line (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    sequence integer,
    account_id integer,
    create_uid integer,
    write_uid integer,
    grouping_key character varying,
    display_type character varying NOT NULL,
    is_selected boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_merge_wizard_line OWNER TO runbot;

--
-- Name: TABLE account_merge_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_merge_wizard_line IS 'Account merge wizard line';


--
-- Name: COLUMN account_merge_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN account_merge_wizard_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_merge_wizard_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.account_id IS 'Account';


--
-- Name: COLUMN account_merge_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_merge_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_merge_wizard_line.grouping_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.grouping_key IS 'Grouping Key';


--
-- Name: COLUMN account_merge_wizard_line.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_merge_wizard_line.is_selected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.is_selected IS 'Is Selected';


--
-- Name: COLUMN account_merge_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN account_merge_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.write_date IS 'Last Updated on';


--
-- Name: account_merge_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_merge_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_merge_wizard_line_id_seq OWNER TO runbot;

--
-- Name: account_merge_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_merge_wizard_line_id_seq OWNED BY public.account_merge_wizard_line.id;


--
-- Name: account_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move (
    id integer NOT NULL,
    sequence_number integer,
    message_main_attachment_id integer,
    journal_id integer NOT NULL,
    company_id integer,
    origin_payment_id integer,
    statement_line_id integer,
    tax_cash_basis_rec_id integer,
    tax_cash_basis_origin_move_id integer,
    auto_post_origin_id integer,
    secure_sequence_number integer,
    invoice_payment_term_id integer,
    partner_id integer,
    commercial_partner_id integer,
    partner_shipping_id integer,
    partner_bank_id integer,
    fiscal_position_id integer,
    preferred_payment_method_line_id integer,
    currency_id integer NOT NULL,
    reversed_entry_id integer,
    invoice_user_id integer,
    invoice_incoterm_id integer,
    invoice_cash_rounding_id integer,
    create_uid integer,
    write_uid integer,
    sequence_prefix character varying,
    access_token character varying,
    name character varying,
    ref character varying,
    state character varying NOT NULL,
    move_type character varying NOT NULL,
    auto_post character varying NOT NULL,
    inalterable_hash character varying,
    payment_reference character varying,
    qr_code_method character varying,
    payment_state character varying,
    invoice_source_email character varying,
    invoice_partner_display_name character varying,
    invoice_origin character varying,
    incoterm_location character varying,
    date date NOT NULL,
    auto_post_until date,
    invoice_date date,
    invoice_date_due date,
    delivery_date date,
    sending_data jsonb,
    narration text,
    invoice_currency_rate numeric,
    amount_untaxed numeric,
    amount_tax numeric,
    amount_total numeric,
    amount_residual numeric,
    amount_untaxed_signed numeric,
    amount_untaxed_in_currency_signed numeric,
    amount_tax_signed numeric,
    amount_total_signed numeric,
    amount_total_in_currency_signed numeric,
    amount_residual_signed numeric,
    quick_edit_total_amount numeric,
    is_storno boolean,
    always_tax_exigible boolean,
    checked boolean,
    posted_before boolean,
    made_sequence_gap boolean,
    is_manually_modified boolean,
    is_move_sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    team_id integer,
    website_id integer
);


ALTER TABLE public.account_move OWNER TO runbot;

--
-- Name: TABLE account_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move IS 'Journal Entry';


--
-- Name: COLUMN account_move.sequence_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sequence_number IS 'Sequence Number';


--
-- Name: COLUMN account_move.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_move.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.journal_id IS 'Journal';


--
-- Name: COLUMN account_move.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.company_id IS 'Company';


--
-- Name: COLUMN account_move.origin_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.origin_payment_id IS 'Payment';


--
-- Name: COLUMN account_move.statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.statement_line_id IS 'Statement Line';


--
-- Name: COLUMN account_move.tax_cash_basis_rec_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_rec_id IS 'Tax Cash Basis Entry of';


--
-- Name: COLUMN account_move.tax_cash_basis_origin_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_origin_move_id IS 'Cash Basis Origin';


--
-- Name: COLUMN account_move.auto_post_origin_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post_origin_id IS 'First recurring entry';


--
-- Name: COLUMN account_move.secure_sequence_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.secure_sequence_number IS 'Inalterability No Gap Sequence #';


--
-- Name: COLUMN account_move.invoice_payment_term_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN account_move.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_id IS 'Partner';


--
-- Name: COLUMN account_move.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN account_move.partner_shipping_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_shipping_id IS 'Delivery Address';


--
-- Name: COLUMN account_move.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_bank_id IS 'Recipient Bank';


--
-- Name: COLUMN account_move.fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_move.preferred_payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.preferred_payment_method_line_id IS 'Preferred Payment Method Line';


--
-- Name: COLUMN account_move.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.currency_id IS 'Currency';


--
-- Name: COLUMN account_move.reversed_entry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.reversed_entry_id IS 'Reversal of';


--
-- Name: COLUMN account_move.invoice_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_user_id IS 'Salesperson';


--
-- Name: COLUMN account_move.invoice_incoterm_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_incoterm_id IS 'Incoterm';


--
-- Name: COLUMN account_move.invoice_cash_rounding_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_cash_rounding_id IS 'Cash Rounding Method';


--
-- Name: COLUMN account_move.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.create_uid IS 'Created by';


--
-- Name: COLUMN account_move.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move.sequence_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sequence_prefix IS 'Sequence Prefix';


--
-- Name: COLUMN account_move.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.access_token IS 'Security Token';


--
-- Name: COLUMN account_move.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.name IS 'Number';


--
-- Name: COLUMN account_move.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.ref IS 'Reference';


--
-- Name: COLUMN account_move.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.state IS 'Status';


--
-- Name: COLUMN account_move.move_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.move_type IS 'Type';


--
-- Name: COLUMN account_move.auto_post; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post IS 'Auto-post';


--
-- Name: COLUMN account_move.inalterable_hash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.inalterable_hash IS 'Inalterability Hash';


--
-- Name: COLUMN account_move.payment_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_move.qr_code_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.qr_code_method IS 'Payment QR-code';


--
-- Name: COLUMN account_move.payment_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_state IS 'Payment Status';


--
-- Name: COLUMN account_move.invoice_source_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_source_email IS 'Source Email';


--
-- Name: COLUMN account_move.invoice_partner_display_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_partner_display_name IS 'Invoice Partner Display Name';


--
-- Name: COLUMN account_move.invoice_origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_origin IS 'Origin';


--
-- Name: COLUMN account_move.incoterm_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.incoterm_location IS 'Incoterm Location';


--
-- Name: COLUMN account_move.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.date IS 'Date';


--
-- Name: COLUMN account_move.auto_post_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post_until IS 'Auto-post until';


--
-- Name: COLUMN account_move.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move.invoice_date_due; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_date_due IS 'Due Date';


--
-- Name: COLUMN account_move.delivery_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.delivery_date IS 'Delivery Date';


--
-- Name: COLUMN account_move.sending_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sending_data IS 'Sending Data';


--
-- Name: COLUMN account_move.narration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.narration IS 'Terms and Conditions';


--
-- Name: COLUMN account_move.invoice_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN account_move.amount_untaxed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed IS 'Untaxed Amount';


--
-- Name: COLUMN account_move.amount_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_tax IS 'Tax';


--
-- Name: COLUMN account_move.amount_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total IS 'Total';


--
-- Name: COLUMN account_move.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_residual IS 'Amount Due';


--
-- Name: COLUMN account_move.amount_untaxed_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed_signed IS 'Untaxed Amount Signed';


--
-- Name: COLUMN account_move.amount_untaxed_in_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed_in_currency_signed IS 'Untaxed Amount Signed Currency';


--
-- Name: COLUMN account_move.amount_tax_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_tax_signed IS 'Tax Signed';


--
-- Name: COLUMN account_move.amount_total_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total_signed IS 'Total Signed';


--
-- Name: COLUMN account_move.amount_total_in_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total_in_currency_signed IS 'Total in Currency Signed';


--
-- Name: COLUMN account_move.amount_residual_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_residual_signed IS 'Amount Due Signed';


--
-- Name: COLUMN account_move.quick_edit_total_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.quick_edit_total_amount IS 'Total (Tax inc.)';


--
-- Name: COLUMN account_move.is_storno; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_storno IS 'Is Storno';


--
-- Name: COLUMN account_move.always_tax_exigible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.always_tax_exigible IS 'Always Tax Exigible';


--
-- Name: COLUMN account_move.checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.checked IS 'Checked';


--
-- Name: COLUMN account_move.posted_before; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.posted_before IS 'Posted Before';


--
-- Name: COLUMN account_move.made_sequence_gap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.made_sequence_gap IS 'Made Sequence Gap';


--
-- Name: COLUMN account_move.is_manually_modified; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_manually_modified IS 'Is Manually Modified';


--
-- Name: COLUMN account_move.is_move_sent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_move_sent IS 'Is Move Sent';


--
-- Name: COLUMN account_move.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.create_date IS 'Created on';


--
-- Name: COLUMN account_move.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.campaign_id IS 'Campaign';


--
-- Name: COLUMN account_move.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.source_id IS 'Source';


--
-- Name: COLUMN account_move.medium_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.medium_id IS 'Medium';


--
-- Name: COLUMN account_move.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.team_id IS 'Sales Team';


--
-- Name: account_move__account_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move__account_payment (
    invoice_id integer NOT NULL,
    payment_id integer NOT NULL
);


ALTER TABLE public.account_move__account_payment OWNER TO runbot;

--
-- Name: TABLE account_move__account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move__account_payment IS 'RELATION BETWEEN account_move AND account_payment';


--
-- Name: account_move_account_move_send_batch_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_account_move_send_batch_wizard_rel (
    account_move_send_batch_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_move_send_batch_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_account_move_send_batch_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_account_move_send_batch_wizard_rel IS 'RELATION BETWEEN account_move_send_batch_wizard AND account_move';


--
-- Name: account_move_account_resequence_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_account_resequence_wizard_rel (
    account_resequence_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_resequence_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_account_resequence_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_account_resequence_wizard_rel IS 'RELATION BETWEEN account_resequence_wizard AND account_move';


--
-- Name: account_move_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_id_seq OWNER TO runbot;

--
-- Name: account_move_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_id_seq OWNED BY public.account_move.id;


--
-- Name: account_move_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    journal_id integer,
    company_id integer,
    company_currency_id integer,
    sequence integer,
    account_id integer,
    currency_id integer NOT NULL,
    partner_id integer,
    reconcile_model_id integer,
    payment_id integer,
    statement_line_id integer,
    statement_id integer,
    group_tax_id integer,
    tax_line_id integer,
    tax_group_id integer,
    tax_repartition_line_id integer,
    full_reconcile_id integer,
    product_id integer,
    product_uom_id integer,
    create_uid integer,
    write_uid integer,
    move_name character varying,
    parent_state character varying,
    ref character varying,
    name character varying,
    matching_number character varying,
    display_type character varying NOT NULL,
    date date,
    invoice_date date,
    date_maturity date,
    discount_date date,
    analytic_distribution jsonb,
    debit numeric,
    credit numeric,
    balance numeric,
    amount_currency numeric,
    tax_base_amount numeric,
    amount_residual numeric,
    amount_residual_currency numeric,
    quantity numeric,
    price_unit numeric,
    price_subtotal numeric,
    price_total numeric,
    discount numeric,
    discount_amount_currency numeric,
    discount_balance numeric,
    is_imported boolean,
    tax_tag_invert boolean,
    reconciled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    is_downpayment boolean,
    CONSTRAINT account_move_line_check_accountable_required_fields CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR (account_id IS NOT NULL))),
    CONSTRAINT account_move_line_check_amount_currency_balance_sign CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR (((balance <= (0)::numeric) AND (amount_currency <= (0)::numeric)) OR ((balance >= (0)::numeric) AND (amount_currency >= (0)::numeric))))),
    CONSTRAINT account_move_line_check_credit_debit CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR ((credit * debit) = (0)::numeric))),
    CONSTRAINT account_move_line_check_non_accountable_fields_null CHECK ((((display_type)::text <> ALL ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR ((amount_currency = (0)::numeric) AND (debit = (0)::numeric) AND (credit = (0)::numeric) AND (account_id IS NULL))))
);


ALTER TABLE public.account_move_line OWNER TO runbot;

--
-- Name: TABLE account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line IS 'Journal Item';


--
-- Name: COLUMN account_move_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_move_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.company_id IS 'Company';


--
-- Name: COLUMN account_move_line.company_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_move_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_move_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.account_id IS 'Account';


--
-- Name: COLUMN account_move_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_move_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_move_line.reconcile_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.reconcile_model_id IS 'Reconciliation Model';


--
-- Name: COLUMN account_move_line.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.payment_id IS 'Originator Payment';


--
-- Name: COLUMN account_move_line.statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.statement_line_id IS 'Originator Statement Line';


--
-- Name: COLUMN account_move_line.statement_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_move_line.group_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.group_tax_id IS 'Originator Group of Taxes';


--
-- Name: COLUMN account_move_line.tax_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_line_id IS 'Originator Tax';


--
-- Name: COLUMN account_move_line.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_group_id IS 'Originator tax group';


--
-- Name: COLUMN account_move_line.tax_repartition_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_repartition_line_id IS 'Originator Tax Distribution Line';


--
-- Name: COLUMN account_move_line.full_reconcile_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.full_reconcile_id IS 'Matching';


--
-- Name: COLUMN account_move_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.product_id IS 'Product';


--
-- Name: COLUMN account_move_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_move_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_line.move_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.move_name IS 'Number';


--
-- Name: COLUMN account_move_line.parent_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.parent_state IS 'Status';


--
-- Name: COLUMN account_move_line.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.ref IS 'Reference';


--
-- Name: COLUMN account_move_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.name IS 'Label';


--
-- Name: COLUMN account_move_line.matching_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.matching_number IS 'Matching #';


--
-- Name: COLUMN account_move_line.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_move_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.date IS 'Date';


--
-- Name: COLUMN account_move_line.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move_line.date_maturity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.date_maturity IS 'Due Date';


--
-- Name: COLUMN account_move_line.discount_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_date IS 'Discount Date';


--
-- Name: COLUMN account_move_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_move_line.debit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.debit IS 'Debit';


--
-- Name: COLUMN account_move_line.credit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.credit IS 'Credit';


--
-- Name: COLUMN account_move_line.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.balance IS 'Balance';


--
-- Name: COLUMN account_move_line.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_move_line.tax_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_base_amount IS 'Base Amount';


--
-- Name: COLUMN account_move_line.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_move_line.amount_residual_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_residual_currency IS 'Residual Amount in Currency';


--
-- Name: COLUMN account_move_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.quantity IS 'Quantity';


--
-- Name: COLUMN account_move_line.price_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN account_move_line.price_subtotal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_subtotal IS 'Subtotal';


--
-- Name: COLUMN account_move_line.price_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_total IS 'Total';


--
-- Name: COLUMN account_move_line.discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount IS 'Discount (%)';


--
-- Name: COLUMN account_move_line.discount_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_amount_currency IS 'Discount amount in Currency';


--
-- Name: COLUMN account_move_line.discount_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_balance IS 'Discount Balance';


--
-- Name: COLUMN account_move_line.is_imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_imported IS 'Is Imported';


--
-- Name: COLUMN account_move_line.tax_tag_invert; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_tag_invert IS 'Invert Tags';


--
-- Name: COLUMN account_move_line.reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.reconciled IS 'Reconciled';


--
-- Name: COLUMN account_move_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.create_date IS 'Created on';


--
-- Name: COLUMN account_move_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_line.is_downpayment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_downpayment IS 'Is Downpayment';


--
-- Name: CONSTRAINT account_move_line_check_accountable_required_fields ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_accountable_required_fields ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_note'') OR account_id IS NOT NULL)';


--
-- Name: CONSTRAINT account_move_line_check_amount_currency_balance_sign ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_amount_currency_balance_sign ON public.account_move_line IS 'CHECK(
                display_type IN (''line_section'', ''line_note'')
                OR (
                    (balance <= 0 AND amount_currency <= 0)
                    OR
                    (balance >= 0 AND amount_currency >= 0)
                )
            )';


--
-- Name: CONSTRAINT account_move_line_check_credit_debit ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_credit_debit ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_note'') OR credit * debit=0)';


--
-- Name: CONSTRAINT account_move_line_check_non_accountable_fields_null ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_non_accountable_fields_null ON public.account_move_line IS 'CHECK(display_type NOT IN (''line_section'', ''line_note'') OR (amount_currency = 0 AND debit = 0 AND credit = 0 AND account_id IS NULL))';


--
-- Name: account_move_line_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_tax_rel (
    account_move_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_tax_rel IS 'RELATION BETWEEN account_move_line AND account_tax';


--
-- Name: account_move_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_line_id_seq OWNER TO runbot;

--
-- Name: account_move_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_line_id_seq OWNED BY public.account_move_line.id;


--
-- Name: account_move_reversal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reason character varying,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_reversal OWNER TO runbot;

--
-- Name: TABLE account_move_reversal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal IS 'Account Move Reversal';


--
-- Name: COLUMN account_move_reversal.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_reversal.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.company_id IS 'Company';


--
-- Name: COLUMN account_move_reversal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_reversal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_reversal.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.reason IS 'Reason displayed on Credit Note';


--
-- Name: COLUMN account_move_reversal.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.date IS 'Reversal date';


--
-- Name: COLUMN account_move_reversal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.create_date IS 'Created on';


--
-- Name: COLUMN account_move_reversal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.write_date IS 'Last Updated on';


--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_reversal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_reversal_id_seq OWNER TO runbot;

--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_reversal_id_seq OWNED BY public.account_move_reversal.id;


--
-- Name: account_move_reversal_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal_move (
    reversal_id integer NOT NULL,
    move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_move OWNER TO runbot;

--
-- Name: TABLE account_move_reversal_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_reversal_new_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal_new_move (
    reversal_id integer NOT NULL,
    new_move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_new_move OWNER TO runbot;

--
-- Name: TABLE account_move_reversal_new_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal_new_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_send_batch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_send_batch_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_send_batch_wizard OWNER TO runbot;

--
-- Name: TABLE account_move_send_batch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_send_batch_wizard IS 'Account Move Send Batch Wizard';


--
-- Name: COLUMN account_move_send_batch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_send_batch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_send_batch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_move_send_batch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.write_date IS 'Last Updated on';


--
-- Name: account_move_send_batch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_send_batch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_send_batch_wizard_id_seq OWNER TO runbot;

--
-- Name: account_move_send_batch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_send_batch_wizard_id_seq OWNED BY public.account_move_send_batch_wizard.id;


--
-- Name: account_move_send_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_send_wizard (
    id integer NOT NULL,
    move_id integer NOT NULL,
    pdf_report_id integer,
    mail_template_id integer,
    create_uid integer,
    write_uid integer,
    mail_subject character varying,
    sending_method_checkboxes jsonb,
    extra_edi_checkboxes jsonb,
    mail_attachments_widget jsonb,
    mail_body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_send_wizard OWNER TO runbot;

--
-- Name: TABLE account_move_send_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_send_wizard IS 'Account Move Send Wizard';


--
-- Name: COLUMN account_move_send_wizard.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.move_id IS 'Move';


--
-- Name: COLUMN account_move_send_wizard.pdf_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.pdf_report_id IS 'Invoice template';


--
-- Name: COLUMN account_move_send_wizard.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_template_id IS 'Email template';


--
-- Name: COLUMN account_move_send_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_send_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_send_wizard.mail_subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_subject IS 'Subject';


--
-- Name: COLUMN account_move_send_wizard.sending_method_checkboxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.sending_method_checkboxes IS 'Sending Method Checkboxes';


--
-- Name: COLUMN account_move_send_wizard.extra_edi_checkboxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.extra_edi_checkboxes IS 'Extra Edi Checkboxes';


--
-- Name: COLUMN account_move_send_wizard.mail_attachments_widget; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_attachments_widget IS 'Mail Attachments Widget';


--
-- Name: COLUMN account_move_send_wizard.mail_body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_body IS 'Contents';


--
-- Name: COLUMN account_move_send_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_move_send_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.write_date IS 'Last Updated on';


--
-- Name: account_move_send_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_send_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_send_wizard_id_seq OWNER TO runbot;

--
-- Name: account_move_send_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_send_wizard_id_seq OWNED BY public.account_move_send_wizard.id;


--
-- Name: account_move_send_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_send_wizard_res_partner_rel (
    account_move_send_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_move_send_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_move_send_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_send_wizard_res_partner_rel IS 'RELATION BETWEEN account_move_send_wizard AND res_partner';


--
-- Name: account_move_validate_account_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_validate_account_move_rel (
    validate_account_move_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_validate_account_move_rel OWNER TO runbot;

--
-- Name: TABLE account_move_validate_account_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_validate_account_move_rel IS 'RELATION BETWEEN validate_account_move AND account_move';


--
-- Name: account_partial_reconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_partial_reconcile (
    id integer NOT NULL,
    debit_move_id integer NOT NULL,
    credit_move_id integer NOT NULL,
    full_reconcile_id integer,
    exchange_move_id integer,
    debit_currency_id integer,
    credit_currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    max_date date,
    amount numeric,
    debit_amount_currency numeric,
    credit_amount_currency numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_partial_reconcile OWNER TO runbot;

--
-- Name: TABLE account_partial_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_partial_reconcile IS 'Partial Reconcile';


--
-- Name: COLUMN account_partial_reconcile.debit_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_move_id IS 'Debit Move';


--
-- Name: COLUMN account_partial_reconcile.credit_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_move_id IS 'Credit Move';


--
-- Name: COLUMN account_partial_reconcile.full_reconcile_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.full_reconcile_id IS 'Full Reconcile';


--
-- Name: COLUMN account_partial_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_partial_reconcile.debit_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_currency_id IS 'Currency of the debit journal item.';


--
-- Name: COLUMN account_partial_reconcile.credit_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_currency_id IS 'Currency of the credit journal item.';


--
-- Name: COLUMN account_partial_reconcile.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.company_id IS 'Company';


--
-- Name: COLUMN account_partial_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_partial_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_partial_reconcile.max_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.max_date IS 'Max Date of Matched Lines';


--
-- Name: COLUMN account_partial_reconcile.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.amount IS 'Amount';


--
-- Name: COLUMN account_partial_reconcile.debit_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_amount_currency IS 'Debit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.credit_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_amount_currency IS 'Credit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_partial_reconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_partial_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNER TO runbot;

--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNED BY public.account_partial_reconcile.id;


--
-- Name: account_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment (
    id integer NOT NULL,
    message_main_attachment_id integer,
    move_id integer,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    partner_bank_id integer,
    paired_internal_transfer_payment_id integer,
    payment_method_line_id integer,
    payment_method_id integer,
    currency_id integer,
    partner_id integer,
    outstanding_account_id integer,
    destination_account_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    state character varying NOT NULL,
    payment_type character varying NOT NULL,
    partner_type character varying NOT NULL,
    memo character varying,
    payment_reference character varying,
    date date NOT NULL,
    amount numeric,
    amount_company_currency_signed numeric,
    is_reconciled boolean,
    is_matched boolean,
    is_sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_transaction_id integer,
    payment_token_id integer,
    source_payment_id integer,
    CONSTRAINT account_payment_check_amount_not_negative CHECK ((amount >= 0.0))
);


ALTER TABLE public.account_payment OWNER TO runbot;

--
-- Name: TABLE account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment IS 'Payments';


--
-- Name: COLUMN account_payment.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_payment.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_payment.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.company_id IS 'Company';


--
-- Name: COLUMN account_payment.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment.paired_internal_transfer_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.paired_internal_transfer_payment_id IS 'Paired Internal Transfer Payment';


--
-- Name: COLUMN account_payment.payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_method_id IS 'Method';


--
-- Name: COLUMN account_payment.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment.outstanding_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.outstanding_account_id IS 'Outstanding Account';


--
-- Name: COLUMN account_payment.destination_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.destination_account_id IS 'Destination Account';


--
-- Name: COLUMN account_payment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.name IS 'Number';


--
-- Name: COLUMN account_payment.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.state IS 'State';


--
-- Name: COLUMN account_payment.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment.memo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.memo IS 'Memo';


--
-- Name: COLUMN account_payment.payment_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_payment.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.date IS 'Date';


--
-- Name: COLUMN account_payment.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.amount IS 'Amount';


--
-- Name: COLUMN account_payment.amount_company_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.amount_company_currency_signed IS 'Amount Company Currency Signed';


--
-- Name: COLUMN account_payment.is_reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_payment.is_matched; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_matched IS 'Is Matched With a Bank Statement';


--
-- Name: COLUMN account_payment.is_sent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_sent IS 'Is Sent';


--
-- Name: COLUMN account_payment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_payment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment.payment_transaction_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_transaction_id IS 'Payment Transaction';


--
-- Name: COLUMN account_payment.payment_token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_token_id IS 'Saved Payment Token';


--
-- Name: COLUMN account_payment.source_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.source_payment_id IS 'Source Payment';


--
-- Name: CONSTRAINT account_payment_check_amount_not_negative ON account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_payment_check_amount_not_negative ON public.account_payment IS 'CHECK(amount >= 0.0)';


--
-- Name: account_payment_account_bank_statement_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_account_bank_statement_line_rel (
    account_bank_statement_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_payment_account_bank_statement_line_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_account_bank_statement_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_account_bank_statement_line_rel IS 'RELATION BETWEEN account_bank_statement_line AND account_payment';


--
-- Name: account_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_id_seq OWNER TO runbot;

--
-- Name: account_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_id_seq OWNED BY public.account_payment.id;


--
-- Name: account_payment_method; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_method (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    payment_type character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_method OWNER TO runbot;

--
-- Name: TABLE account_payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_method IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.code IS 'Code';


--
-- Name: COLUMN account_payment_method.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_method.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.name IS 'Name';


--
-- Name: COLUMN account_payment_method.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.write_date IS 'Last Updated on';


--
-- Name: account_payment_method_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_method_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_id_seq OWNER TO runbot;

--
-- Name: account_payment_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_method_id_seq OWNED BY public.account_payment_method.id;


--
-- Name: account_payment_method_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_method_line (
    id integer NOT NULL,
    sequence integer,
    payment_method_id integer NOT NULL,
    payment_account_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_provider_id integer
);


ALTER TABLE public.account_payment_method_line OWNER TO runbot;

--
-- Name: TABLE account_payment_method_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_method_line IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_method_line.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_method_line.payment_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_account_id IS 'Payment Account';


--
-- Name: COLUMN account_payment_method_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_method_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.name IS 'Name';


--
-- Name: COLUMN account_payment_method_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_method_line.payment_provider_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_provider_id IS 'Payment Provider';


--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_method_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_line_id_seq OWNER TO runbot;

--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_method_line_id_seq OWNED BY public.account_payment_method_line.id;


--
-- Name: account_payment_register; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register (
    id integer NOT NULL,
    currency_id integer,
    journal_id integer,
    partner_bank_id integer,
    custom_user_currency_id integer,
    source_currency_id integer,
    company_id integer,
    partner_id integer,
    payment_method_line_id integer,
    writeoff_account_id integer,
    create_uid integer,
    write_uid integer,
    communication character varying,
    installments_mode character varying,
    payment_type character varying,
    partner_type character varying,
    payment_difference_handling character varying,
    writeoff_label character varying,
    payment_date date NOT NULL,
    amount numeric,
    custom_user_amount numeric,
    source_amount numeric,
    source_amount_currency numeric,
    group_payment boolean,
    can_edit_wizard boolean,
    can_group_payments boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_token_id integer
);


ALTER TABLE public.account_payment_register OWNER TO runbot;

--
-- Name: TABLE account_payment_register; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register IS 'Pay';


--
-- Name: COLUMN account_payment_register.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment_register.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_register.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment_register.custom_user_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.custom_user_currency_id IS 'Custom User Currency';


--
-- Name: COLUMN account_payment_register.source_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_currency_id IS 'Source Currency';


--
-- Name: COLUMN account_payment_register.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.company_id IS 'Company';


--
-- Name: COLUMN account_payment_register.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment_register.payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_register.writeoff_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.writeoff_account_id IS 'Difference Account';


--
-- Name: COLUMN account_payment_register.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_register.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_register.communication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.communication IS 'Memo';


--
-- Name: COLUMN account_payment_register.installments_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.installments_mode IS 'Installments Mode';


--
-- Name: COLUMN account_payment_register.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_register.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment_register.payment_difference_handling; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_difference_handling IS 'Payment Difference Handling';


--
-- Name: COLUMN account_payment_register.writeoff_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.writeoff_label IS 'Journal Item Label';


--
-- Name: COLUMN account_payment_register.payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_date IS 'Payment Date';


--
-- Name: COLUMN account_payment_register.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.amount IS 'Amount';


--
-- Name: COLUMN account_payment_register.custom_user_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.custom_user_amount IS 'Custom User Amount';


--
-- Name: COLUMN account_payment_register.source_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_amount IS 'Amount to Pay (company currency)';


--
-- Name: COLUMN account_payment_register.source_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_amount_currency IS 'Amount to Pay (foreign currency)';


--
-- Name: COLUMN account_payment_register.group_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.group_payment IS 'Group Payments';


--
-- Name: COLUMN account_payment_register.can_edit_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.can_edit_wizard IS 'Can Edit Wizard';


--
-- Name: COLUMN account_payment_register.can_group_payments; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.can_group_payments IS 'Can Group Payments';


--
-- Name: COLUMN account_payment_register.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_register.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_register.payment_token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_token_id IS 'Saved payment token';


--
-- Name: account_payment_register_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_register_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_register_id_seq OWNER TO runbot;

--
-- Name: account_payment_register_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_register_id_seq OWNED BY public.account_payment_register.id;


--
-- Name: account_payment_register_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register_move_line_rel (
    wizard_id integer NOT NULL,
    line_id integer NOT NULL
);


ALTER TABLE public.account_payment_register_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_register_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register_move_line_rel IS 'RELATION BETWEEN account_payment_register AND account_move_line';


--
-- Name: account_payment_term; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term (
    id integer NOT NULL,
    company_id integer,
    sequence integer NOT NULL,
    discount_days integer,
    create_uid integer,
    write_uid integer,
    early_pay_discount_computation character varying,
    name jsonb NOT NULL,
    note jsonb,
    active boolean,
    display_on_invoice boolean,
    early_discount boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    discount_percentage double precision
);


ALTER TABLE public.account_payment_term OWNER TO runbot;

--
-- Name: TABLE account_payment_term; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.company_id IS 'Company';


--
-- Name: COLUMN account_payment_term.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_term.discount_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.discount_days IS 'Discount Days';


--
-- Name: COLUMN account_payment_term.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term.early_pay_discount_computation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.early_pay_discount_computation IS 'Cash Discount Tax Reduction';


--
-- Name: COLUMN account_payment_term.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.name IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.note IS 'Description on the Invoice';


--
-- Name: COLUMN account_payment_term.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.active IS 'Active';


--
-- Name: COLUMN account_payment_term.display_on_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.display_on_invoice IS 'Show installment dates';


--
-- Name: COLUMN account_payment_term.early_discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.early_discount IS 'Early Discount';


--
-- Name: COLUMN account_payment_term.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_term.discount_percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.discount_percentage IS 'Discount %';


--
-- Name: account_payment_term_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_id_seq OWNED BY public.account_payment_term.id;


--
-- Name: account_payment_term_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term_line (
    id integer NOT NULL,
    nb_days integer,
    payment_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    delay_type character varying NOT NULL,
    days_next_month character varying(2),
    value_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_term_line OWNER TO runbot;

--
-- Name: TABLE account_payment_term_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term_line IS 'Payment Terms Line';


--
-- Name: COLUMN account_payment_term_line.nb_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.nb_days IS 'Days';


--
-- Name: COLUMN account_payment_term_line.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.payment_id IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term_line.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.value IS 'Value';


--
-- Name: COLUMN account_payment_term_line.delay_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.delay_type IS 'Delay Type';


--
-- Name: COLUMN account_payment_term_line.days_next_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.days_next_month IS 'Days on the next month';


--
-- Name: COLUMN account_payment_term_line.value_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.value_amount IS 'Due';


--
-- Name: COLUMN account_payment_term_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.write_date IS 'Last Updated on';


--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_line_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_line_id_seq OWNED BY public.account_payment_term_line.id;


--
-- Name: account_reconcile_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model (
    id integer NOT NULL,
    sequence integer NOT NULL,
    company_id integer NOT NULL,
    past_months_limit integer,
    create_uid integer,
    write_uid integer,
    rule_type character varying NOT NULL,
    matching_order character varying NOT NULL,
    counterpart_type character varying,
    match_nature character varying NOT NULL,
    match_amount character varying,
    match_label character varying,
    match_label_param character varying,
    match_note character varying,
    match_note_param character varying,
    match_transaction_type character varying,
    match_transaction_type_param character varying,
    payment_tolerance_type character varying NOT NULL,
    decimal_separator character varying,
    name jsonb NOT NULL,
    active boolean,
    auto_reconcile boolean,
    to_check boolean,
    match_text_location_label boolean,
    match_text_location_note boolean,
    match_text_location_reference boolean,
    match_same_currency boolean,
    allow_payment_tolerance boolean,
    match_partner boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    match_amount_min double precision,
    match_amount_max double precision,
    payment_tolerance_param double precision
);


ALTER TABLE public.account_reconcile_model OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model IS 'Preset to create journal entries during a invoices and payments matching';


--
-- Name: COLUMN account_reconcile_model.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model.past_months_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.past_months_limit IS 'Search Months Limit';


--
-- Name: COLUMN account_reconcile_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model.rule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.rule_type IS 'Type';


--
-- Name: COLUMN account_reconcile_model.matching_order; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.matching_order IS 'Matching Order';


--
-- Name: COLUMN account_reconcile_model.counterpart_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.counterpart_type IS 'Counterpart Type';


--
-- Name: COLUMN account_reconcile_model.match_nature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_nature IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model.match_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount IS 'Amount Condition';


--
-- Name: COLUMN account_reconcile_model.match_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_label IS 'Label';


--
-- Name: COLUMN account_reconcile_model.match_label_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_label_param IS 'Label Parameter';


--
-- Name: COLUMN account_reconcile_model.match_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_note IS 'Note';


--
-- Name: COLUMN account_reconcile_model.match_note_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_note_param IS 'Note Parameter';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type_param IS 'Transaction Type Parameter';


--
-- Name: COLUMN account_reconcile_model.payment_tolerance_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.payment_tolerance_type IS 'Payment Tolerance Type';


--
-- Name: COLUMN account_reconcile_model.decimal_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.decimal_separator IS 'Decimal Separator';


--
-- Name: COLUMN account_reconcile_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.name IS 'Name';


--
-- Name: COLUMN account_reconcile_model.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.active IS 'Active';


--
-- Name: COLUMN account_reconcile_model.auto_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.auto_reconcile IS 'Auto-validate';


--
-- Name: COLUMN account_reconcile_model.to_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_model.match_text_location_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_label IS 'Match Text Location Label';


--
-- Name: COLUMN account_reconcile_model.match_text_location_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_note IS 'Match Text Location Note';


--
-- Name: COLUMN account_reconcile_model.match_text_location_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_reference IS 'Match Text Location Reference';


--
-- Name: COLUMN account_reconcile_model.match_same_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_same_currency IS 'Same Currency';


--
-- Name: COLUMN account_reconcile_model.allow_payment_tolerance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.allow_payment_tolerance IS 'Payment Tolerance';


--
-- Name: COLUMN account_reconcile_model.match_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_partner IS 'Partner is Set';


--
-- Name: COLUMN account_reconcile_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model.match_amount_min; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_min IS 'Amount Min Parameter';


--
-- Name: COLUMN account_reconcile_model.match_amount_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_max IS 'Amount Max Parameter';


--
-- Name: COLUMN account_reconcile_model.payment_tolerance_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.payment_tolerance_param IS 'Gap';


--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_id_seq OWNED BY public.account_reconcile_model.id;


--
-- Name: account_reconcile_model_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line (
    id integer NOT NULL,
    model_id integer,
    company_id integer,
    sequence integer NOT NULL,
    account_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    amount_type character varying NOT NULL,
    amount_string character varying NOT NULL,
    analytic_distribution jsonb,
    label jsonb,
    force_tax_included boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision
);


ALTER TABLE public.account_reconcile_model_line OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line IS 'Rules for the reconciliation model';


--
-- Name: COLUMN account_reconcile_model_line.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_model_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_reconcile_model_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_line.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_type IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model_line.amount_string; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_string IS 'Amount';


--
-- Name: COLUMN account_reconcile_model_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_reconcile_model_line.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.label IS 'Journal Item Label';


--
-- Name: COLUMN account_reconcile_model_line.force_tax_included; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.force_tax_included IS 'Tax Included in Price';


--
-- Name: COLUMN account_reconcile_model_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount IS 'Float Amount';


--
-- Name: account_reconcile_model_line_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line_account_tax_rel (
    account_reconcile_model_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_line_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line_account_tax_rel IS 'RELATION BETWEEN account_reconcile_model_line AND account_tax';


--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNED BY public.account_reconcile_model_line.id;


--
-- Name: account_reconcile_model_partner_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_partner_mapping (
    id integer NOT NULL,
    model_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payment_ref_regex character varying,
    narration_regex character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_model_partner_mapping OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_partner_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_partner_mapping IS 'Partner mapping for reconciliation models';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.partner_id IS 'Partner';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.payment_ref_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.payment_ref_regex IS 'Find Text in Label';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.narration_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.narration_regex IS 'Find Text in Notes';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_model_partner_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_partner_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_partner_mapping_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_partner_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_partner_mapping_id_seq OWNED BY public.account_reconcile_model_partner_mapping.id;


--
-- Name: account_reconcile_model_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_res_partner_category_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_category_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_category_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner_category';


--
-- Name: account_reconcile_model_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_res_partner_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner';


--
-- Name: account_report; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report (
    id integer NOT NULL,
    sequence integer,
    root_report_id integer,
    country_id integer,
    load_more_limit integer,
    prefix_groups_threshold integer,
    create_uid integer,
    write_uid integer,
    chart_template character varying,
    availability_condition character varying,
    integer_rounding character varying,
    default_opening_date_filter character varying,
    currency_translation character varying,
    filter_multi_company character varying,
    filter_hide_0_lines character varying,
    filter_hierarchy character varying,
    filter_account_type character varying,
    name jsonb NOT NULL,
    active boolean,
    use_sections boolean,
    only_tax_exigible boolean,
    search_bar boolean,
    filter_date_range boolean,
    filter_show_draft boolean,
    filter_unreconciled boolean,
    filter_unfold_all boolean,
    filter_period_comparison boolean,
    filter_growth_comparison boolean,
    filter_journals boolean,
    filter_analytic boolean,
    filter_partner boolean,
    filter_fiscal_position boolean,
    filter_aml_ir_filters boolean,
    filter_budgets boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report OWNER TO runbot;

--
-- Name: TABLE account_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report IS 'Accounting Report';


--
-- Name: COLUMN account_report.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.sequence IS 'Sequence';


--
-- Name: COLUMN account_report.root_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.root_report_id IS 'Root Report';


--
-- Name: COLUMN account_report.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.country_id IS 'Country';


--
-- Name: COLUMN account_report.load_more_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.load_more_limit IS 'Load More Limit';


--
-- Name: COLUMN account_report.prefix_groups_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.prefix_groups_threshold IS 'Prefix Groups Threshold';


--
-- Name: COLUMN account_report.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_report.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report.chart_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.chart_template IS 'Chart of Accounts';


--
-- Name: COLUMN account_report.availability_condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.availability_condition IS 'Availability';


--
-- Name: COLUMN account_report.integer_rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.integer_rounding IS 'Integer Rounding';


--
-- Name: COLUMN account_report.default_opening_date_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.default_opening_date_filter IS 'Default Opening';


--
-- Name: COLUMN account_report.currency_translation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.currency_translation IS 'Currency Translation';


--
-- Name: COLUMN account_report.filter_multi_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_multi_company IS 'Multi-Company';


--
-- Name: COLUMN account_report.filter_hide_0_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_hide_0_lines IS 'Hide lines at 0';


--
-- Name: COLUMN account_report.filter_hierarchy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_hierarchy IS 'Account Groups';


--
-- Name: COLUMN account_report.filter_account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_account_type IS 'Account Types';


--
-- Name: COLUMN account_report.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.name IS 'Name';


--
-- Name: COLUMN account_report.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.active IS 'Active';


--
-- Name: COLUMN account_report.use_sections; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.use_sections IS 'Composite Report';


--
-- Name: COLUMN account_report.only_tax_exigible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.only_tax_exigible IS 'Only Tax Exigible Lines';


--
-- Name: COLUMN account_report.search_bar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.search_bar IS 'Search Bar';


--
-- Name: COLUMN account_report.filter_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_date_range IS 'Date Range';


--
-- Name: COLUMN account_report.filter_show_draft; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_show_draft IS 'Draft Entries';


--
-- Name: COLUMN account_report.filter_unreconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_unreconciled IS 'Unreconciled Entries';


--
-- Name: COLUMN account_report.filter_unfold_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_unfold_all IS 'Unfold All';


--
-- Name: COLUMN account_report.filter_period_comparison; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_period_comparison IS 'Period Comparison';


--
-- Name: COLUMN account_report.filter_growth_comparison; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_growth_comparison IS 'Growth Comparison';


--
-- Name: COLUMN account_report.filter_journals; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_journals IS 'Journals';


--
-- Name: COLUMN account_report.filter_analytic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_analytic IS 'Analytic Filter';


--
-- Name: COLUMN account_report.filter_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_partner IS 'Partners';


--
-- Name: COLUMN account_report.filter_fiscal_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_fiscal_position IS 'Filter Multivat';


--
-- Name: COLUMN account_report.filter_aml_ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_aml_ir_filters IS 'Favorite Filters';


--
-- Name: COLUMN account_report.filter_budgets; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_budgets IS 'Budgets';


--
-- Name: COLUMN account_report.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.create_date IS 'Created on';


--
-- Name: COLUMN account_report.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.write_date IS 'Last Updated on';


--
-- Name: account_report_column; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_column (
    id integer NOT NULL,
    sequence integer,
    report_id integer,
    custom_audit_action_id integer,
    create_uid integer,
    write_uid integer,
    expression_label character varying NOT NULL,
    figure_type character varying NOT NULL,
    name jsonb NOT NULL,
    sortable boolean,
    blank_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_column OWNER TO runbot;

--
-- Name: TABLE account_report_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_column IS 'Accounting Report Column';


--
-- Name: COLUMN account_report_column.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_column.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.report_id IS 'Report';


--
-- Name: COLUMN account_report_column.custom_audit_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.custom_audit_action_id IS 'Custom Audit Action';


--
-- Name: COLUMN account_report_column.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_column.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_column.expression_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.expression_label IS 'Expression Label';


--
-- Name: COLUMN account_report_column.figure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_column.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.name IS 'Name';


--
-- Name: COLUMN account_report_column.sortable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.sortable IS 'Sortable';


--
-- Name: COLUMN account_report_column.blank_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_column.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.create_date IS 'Created on';


--
-- Name: COLUMN account_report_column.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.write_date IS 'Last Updated on';


--
-- Name: account_report_column_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_column_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_column_id_seq OWNER TO runbot;

--
-- Name: account_report_column_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_column_id_seq OWNED BY public.account_report_column.id;


--
-- Name: account_report_expression; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_expression (
    id integer NOT NULL,
    report_line_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    label character varying NOT NULL,
    engine character varying NOT NULL,
    formula character varying NOT NULL,
    subformula character varying,
    date_scope character varying NOT NULL,
    figure_type character varying,
    carryover_target character varying,
    green_on_positive boolean,
    blank_if_zero boolean,
    auditable boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_report_expression_domain_engine_subformula_required CHECK ((((engine)::text <> 'domain'::text) OR (subformula IS NOT NULL)))
);


ALTER TABLE public.account_report_expression OWNER TO runbot;

--
-- Name: TABLE account_report_expression; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_expression IS 'Accounting Report Expression';


--
-- Name: COLUMN account_report_expression.report_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.report_line_id IS 'Report Line';


--
-- Name: COLUMN account_report_expression.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_expression.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_expression.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.label IS 'Label';


--
-- Name: COLUMN account_report_expression.engine; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.engine IS 'Computation Engine';


--
-- Name: COLUMN account_report_expression.formula; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.formula IS 'Formula';


--
-- Name: COLUMN account_report_expression.subformula; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.subformula IS 'Subformula';


--
-- Name: COLUMN account_report_expression.date_scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.date_scope IS 'Date Scope';


--
-- Name: COLUMN account_report_expression.figure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_expression.carryover_target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.carryover_target IS 'Carry Over To';


--
-- Name: COLUMN account_report_expression.green_on_positive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.green_on_positive IS 'Is Growth Good when Positive';


--
-- Name: COLUMN account_report_expression.blank_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_expression.auditable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.auditable IS 'Auditable';


--
-- Name: COLUMN account_report_expression.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.create_date IS 'Created on';


--
-- Name: COLUMN account_report_expression.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_report_expression_domain_engine_subformula_required ON account_report_expression; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_report_expression_domain_engine_subformula_required ON public.account_report_expression IS 'CHECK(engine != ''domain'' OR subformula IS NOT NULL)';


--
-- Name: account_report_expression_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_expression_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_expression_id_seq OWNER TO runbot;

--
-- Name: account_report_expression_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_expression_id_seq OWNED BY public.account_report_expression.id;


--
-- Name: account_report_external_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_external_value (
    id integer NOT NULL,
    target_report_expression_id integer NOT NULL,
    company_id integer NOT NULL,
    foreign_vat_fiscal_position_id integer,
    carryover_origin_report_line_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    text_value character varying,
    carryover_origin_expression_label character varying,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value double precision
);


ALTER TABLE public.account_report_external_value OWNER TO runbot;

--
-- Name: TABLE account_report_external_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_external_value IS 'Accounting Report External Value';


--
-- Name: COLUMN account_report_external_value.target_report_expression_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.target_report_expression_id IS 'Target Expression';


--
-- Name: COLUMN account_report_external_value.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.company_id IS 'Company';


--
-- Name: COLUMN account_report_external_value.foreign_vat_fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.foreign_vat_fiscal_position_id IS 'Fiscal position';


--
-- Name: COLUMN account_report_external_value.carryover_origin_report_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_report_line_id IS 'Origin Line';


--
-- Name: COLUMN account_report_external_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_external_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_external_value.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.name IS 'Name';


--
-- Name: COLUMN account_report_external_value.text_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.text_value IS 'Text Value';


--
-- Name: COLUMN account_report_external_value.carryover_origin_expression_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_expression_label IS 'Origin Expression Label';


--
-- Name: COLUMN account_report_external_value.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.date IS 'Date';


--
-- Name: COLUMN account_report_external_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.create_date IS 'Created on';


--
-- Name: COLUMN account_report_external_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report_external_value.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.value IS 'Numeric Value';


--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_external_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_external_value_id_seq OWNER TO runbot;

--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_external_value_id_seq OWNED BY public.account_report_external_value.id;


--
-- Name: account_report_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_id_seq OWNER TO runbot;

--
-- Name: account_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_id_seq OWNED BY public.account_report.id;


--
-- Name: account_report_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_line (
    id integer NOT NULL,
    report_id integer NOT NULL,
    hierarchy_level integer NOT NULL,
    parent_id integer,
    sequence integer,
    action_id integer,
    create_uid integer,
    write_uid integer,
    groupby character varying,
    user_groupby character varying,
    code character varying,
    horizontal_split_side character varying,
    name jsonb NOT NULL,
    foldable boolean,
    print_on_new_page boolean,
    hide_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_line OWNER TO runbot;

--
-- Name: TABLE account_report_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_line IS 'Accounting Report Line';


--
-- Name: COLUMN account_report_line.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.report_id IS 'Parent Report';


--
-- Name: COLUMN account_report_line.hierarchy_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.hierarchy_level IS 'Level';


--
-- Name: COLUMN account_report_line.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.parent_id IS 'Parent Line';


--
-- Name: COLUMN account_report_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_line.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.action_id IS 'Action';


--
-- Name: COLUMN account_report_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_line.groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.groupby IS 'Group By';


--
-- Name: COLUMN account_report_line.user_groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.user_groupby IS 'User Group By';


--
-- Name: COLUMN account_report_line.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.code IS 'Code';


--
-- Name: COLUMN account_report_line.horizontal_split_side; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.horizontal_split_side IS 'Horizontal Split Side';


--
-- Name: COLUMN account_report_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.name IS 'Name';


--
-- Name: COLUMN account_report_line.foldable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.foldable IS 'Foldable';


--
-- Name: COLUMN account_report_line.print_on_new_page; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.print_on_new_page IS 'Print On New Page';


--
-- Name: COLUMN account_report_line.hide_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.hide_if_zero IS 'Hide if Zero';


--
-- Name: COLUMN account_report_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.create_date IS 'Created on';


--
-- Name: COLUMN account_report_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.write_date IS 'Last Updated on';


--
-- Name: account_report_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_line_id_seq OWNER TO runbot;

--
-- Name: account_report_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_line_id_seq OWNED BY public.account_report_line.id;


--
-- Name: account_report_section_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_section_rel (
    main_report_id integer NOT NULL,
    sub_report_id integer NOT NULL
);


ALTER TABLE public.account_report_section_rel OWNER TO runbot;

--
-- Name: TABLE account_report_section_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_section_rel IS 'RELATION BETWEEN account_report AND account_report';


--
-- Name: account_resequence_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_resequence_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    first_name character varying NOT NULL,
    ordering character varying NOT NULL,
    first_date date,
    end_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_resequence_wizard OWNER TO runbot;

--
-- Name: TABLE account_resequence_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_resequence_wizard IS 'Remake the sequence of Journal Entries.';


--
-- Name: COLUMN account_resequence_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_resequence_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_resequence_wizard.first_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.first_name IS 'First New Sequence';


--
-- Name: COLUMN account_resequence_wizard.ordering; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.ordering IS 'Ordering';


--
-- Name: COLUMN account_resequence_wizard.first_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.first_date IS 'First Date';


--
-- Name: COLUMN account_resequence_wizard.end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.end_date IS 'End Date';


--
-- Name: COLUMN account_resequence_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_resequence_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.write_date IS 'Last Updated on';


--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_resequence_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNER TO runbot;

--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNED BY public.account_resequence_wizard.id;


--
-- Name: account_secure_entries_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_secure_entries_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    hash_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_secure_entries_wizard OWNER TO runbot;

--
-- Name: TABLE account_secure_entries_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_secure_entries_wizard IS 'Secure Journal Entries';


--
-- Name: COLUMN account_secure_entries_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_secure_entries_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_secure_entries_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_secure_entries_wizard.hash_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.hash_date IS 'Hash All Entries';


--
-- Name: COLUMN account_secure_entries_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_secure_entries_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.write_date IS 'Last Updated on';


--
-- Name: account_secure_entries_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_secure_entries_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_secure_entries_wizard_id_seq OWNER TO runbot;

--
-- Name: account_secure_entries_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_secure_entries_wizard_id_seq OWNED BY public.account_secure_entries_wizard.id;


--
-- Name: account_setup_bank_manual_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_setup_bank_manual_config (
    id integer NOT NULL,
    res_partner_bank_id integer NOT NULL,
    num_journals_without_account integer,
    create_uid integer,
    write_uid integer,
    new_journal_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_setup_bank_manual_config OWNER TO runbot;

--
-- Name: TABLE account_setup_bank_manual_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_setup_bank_manual_config IS 'Bank setup manual config';


--
-- Name: COLUMN account_setup_bank_manual_config.res_partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.res_partner_bank_id IS 'Res Partner Bank';


--
-- Name: COLUMN account_setup_bank_manual_config.num_journals_without_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.num_journals_without_account IS 'Num Journals Without Account';


--
-- Name: COLUMN account_setup_bank_manual_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_uid IS 'Created by';


--
-- Name: COLUMN account_setup_bank_manual_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_setup_bank_manual_config.new_journal_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.new_journal_name IS 'New Journal Name';


--
-- Name: COLUMN account_setup_bank_manual_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_date IS 'Created on';


--
-- Name: COLUMN account_setup_bank_manual_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_date IS 'Last Updated on';


--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_setup_bank_manual_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNER TO runbot;

--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNED BY public.account_setup_bank_manual_config.id;


--
-- Name: account_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax (
    id integer NOT NULL,
    company_id integer NOT NULL,
    sequence integer NOT NULL,
    tax_group_id integer NOT NULL,
    cash_basis_transition_account_id integer,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    type_tax_use character varying NOT NULL,
    tax_scope character varying,
    amount_type character varying NOT NULL,
    price_include_override character varying,
    tax_exigibility character varying,
    name jsonb NOT NULL,
    description jsonb,
    invoice_label jsonb,
    invoice_legal_notes text,
    amount numeric NOT NULL,
    active boolean,
    include_base_amount boolean,
    is_base_affected boolean,
    analytic boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax OWNER TO runbot;

--
-- Name: TABLE account_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax IS 'Tax';


--
-- Name: COLUMN account_tax.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.company_id IS 'Company';


--
-- Name: COLUMN account_tax.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_group_id IS 'Tax Group';


--
-- Name: COLUMN account_tax.cash_basis_transition_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.cash_basis_transition_account_id IS 'Cash Basis Transition Account';


--
-- Name: COLUMN account_tax.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.country_id IS 'Country';


--
-- Name: COLUMN account_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax.type_tax_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.type_tax_use IS 'Tax Type';


--
-- Name: COLUMN account_tax.tax_scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_scope IS 'Tax Scope';


--
-- Name: COLUMN account_tax.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.amount_type IS 'Tax Computation';


--
-- Name: COLUMN account_tax.price_include_override; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.price_include_override IS 'Included in Price';


--
-- Name: COLUMN account_tax.tax_exigibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_exigibility IS 'Tax Exigibility';


--
-- Name: COLUMN account_tax.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.name IS 'Tax Name';


--
-- Name: COLUMN account_tax.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.description IS 'Description';


--
-- Name: COLUMN account_tax.invoice_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.invoice_label IS 'Label on Invoices';


--
-- Name: COLUMN account_tax.invoice_legal_notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.invoice_legal_notes IS 'Legal Notes';


--
-- Name: COLUMN account_tax.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.amount IS 'Amount';


--
-- Name: COLUMN account_tax.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.active IS 'Active';


--
-- Name: COLUMN account_tax.include_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.include_base_amount IS 'Affect Base of Subsequent Taxes';


--
-- Name: COLUMN account_tax.is_base_affected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.is_base_affected IS 'Base Affected by Previous Taxes';


--
-- Name: COLUMN account_tax.analytic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.analytic IS 'Include in Analytic Cost';


--
-- Name: COLUMN account_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.write_date IS 'Last Updated on';


--
-- Name: account_tax_filiation_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_filiation_rel (
    parent_tax integer NOT NULL,
    child_tax integer NOT NULL
);


ALTER TABLE public.account_tax_filiation_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_filiation_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_filiation_rel IS 'RELATION BETWEEN account_tax AND account_tax';


--
-- Name: account_tax_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_group (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    tax_payable_account_id integer,
    tax_receivable_account_id integer,
    advance_tax_payment_account_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    pos_receipt_label character varying,
    name jsonb NOT NULL,
    preceding_subtotal jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_group OWNER TO runbot;

--
-- Name: TABLE account_tax_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_group IS 'Tax Group';


--
-- Name: COLUMN account_tax_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.company_id IS 'Company';


--
-- Name: COLUMN account_tax_group.tax_payable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.tax_payable_account_id IS 'Tax Payable Account';


--
-- Name: COLUMN account_tax_group.tax_receivable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.tax_receivable_account_id IS 'Tax Receivable Account';


--
-- Name: COLUMN account_tax_group.advance_tax_payment_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.advance_tax_payment_account_id IS 'Tax Advance Account';


--
-- Name: COLUMN account_tax_group.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.country_id IS 'Country';


--
-- Name: COLUMN account_tax_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_group.pos_receipt_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.pos_receipt_label IS 'PoS receipt label';


--
-- Name: COLUMN account_tax_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.name IS 'Name';


--
-- Name: COLUMN account_tax_group.preceding_subtotal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.preceding_subtotal IS 'Preceding Subtotal';


--
-- Name: COLUMN account_tax_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.write_date IS 'Last Updated on';


--
-- Name: account_tax_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_group_id_seq OWNER TO runbot;

--
-- Name: account_tax_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_group_id_seq OWNED BY public.account_tax_group.id;


--
-- Name: account_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_id_seq OWNER TO runbot;

--
-- Name: account_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_id_seq OWNED BY public.account_tax.id;


--
-- Name: account_tax_repartition_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_repartition_line (
    id integer NOT NULL,
    account_id integer,
    tax_id integer,
    company_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    repartition_type character varying NOT NULL,
    document_type character varying NOT NULL,
    factor_percent numeric NOT NULL,
    use_in_tax_closing boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_repartition_line OWNER TO runbot;

--
-- Name: TABLE account_tax_repartition_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_repartition_line IS 'Tax Repartition Line';


--
-- Name: COLUMN account_tax_repartition_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.account_id IS 'Account';


--
-- Name: COLUMN account_tax_repartition_line.tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.tax_id IS 'Tax';


--
-- Name: COLUMN account_tax_repartition_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.company_id IS 'Company';


--
-- Name: COLUMN account_tax_repartition_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_repartition_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_repartition_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_repartition_line.repartition_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.repartition_type IS 'Based On';


--
-- Name: COLUMN account_tax_repartition_line.document_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.document_type IS 'Related to';


--
-- Name: COLUMN account_tax_repartition_line.factor_percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.factor_percent IS '%';


--
-- Name: COLUMN account_tax_repartition_line.use_in_tax_closing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.use_in_tax_closing IS 'Tax Closing Entry';


--
-- Name: COLUMN account_tax_repartition_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_repartition_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_date IS 'Last Updated on';


--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_repartition_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNER TO runbot;

--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNED BY public.account_tax_repartition_line.id;


--
-- Name: account_tax_sale_order_discount_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_sale_order_discount_rel (
    sale_order_discount_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_order_discount_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_sale_order_discount_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_sale_order_discount_rel IS 'RELATION BETWEEN sale_order_discount AND account_tax';


--
-- Name: account_tax_sale_order_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_sale_order_line_rel (
    sale_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_order_line_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_sale_order_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_sale_order_line_rel IS 'RELATION BETWEEN sale_order_line AND account_tax';


--
-- Name: activity_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.activity_attachment_rel (
    activity_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.activity_attachment_rel OWNER TO runbot;

--
-- Name: TABLE activity_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.activity_attachment_rel IS 'RELATION BETWEEN mail_activity AND ir_attachment';


--
-- Name: allowed_ip; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.allowed_ip (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    ip character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.allowed_ip OWNER TO runbot;

--
-- Name: TABLE allowed_ip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.allowed_ip IS 'Allowed IP';


--
-- Name: COLUMN allowed_ip.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.allowed_ip.create_uid IS 'Created by';


--
-- Name: COLUMN allowed_ip.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.allowed_ip.write_uid IS 'Last Updated by';


--
-- Name: COLUMN allowed_ip.ip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.allowed_ip.ip IS 'IP address';


--
-- Name: COLUMN allowed_ip.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.allowed_ip.name IS 'Server Name';


--
-- Name: COLUMN allowed_ip.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.allowed_ip.create_date IS 'Created on';


--
-- Name: COLUMN allowed_ip.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.allowed_ip.write_date IS 'Last Updated on';


--
-- Name: allowed_ip_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.allowed_ip_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.allowed_ip_id_seq OWNER TO runbot;

--
-- Name: allowed_ip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.allowed_ip_id_seq OWNED BY public.allowed_ip.id;


--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    code character varying(7),
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: base_automation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_automation (
    id integer NOT NULL,
    model_id integer NOT NULL,
    trg_selection_field_id integer,
    trg_field_ref integer,
    trg_date_id integer,
    trg_date_range integer,
    trg_date_calendar_id integer,
    create_uid integer,
    write_uid integer,
    webhook_uuid character varying,
    record_getter character varying,
    trigger character varying NOT NULL,
    trg_date_range_type character varying,
    filter_pre_domain character varying,
    filter_domain character varying,
    name jsonb NOT NULL,
    description text,
    log_webhook_calls boolean,
    active boolean,
    last_run timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_automation OWNER TO runbot;

--
-- Name: TABLE base_automation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_automation IS 'Automation Rule';


--
-- Name: COLUMN base_automation.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.model_id IS 'Model';


--
-- Name: COLUMN base_automation.trg_selection_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_selection_field_id IS 'Trigger Field';


--
-- Name: COLUMN base_automation.trg_field_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_field_ref IS 'Trigger Reference';


--
-- Name: COLUMN base_automation.trg_date_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_id IS 'Trigger Date';


--
-- Name: COLUMN base_automation.trg_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_range IS 'Delay after trigger date';


--
-- Name: COLUMN base_automation.trg_date_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_calendar_id IS 'Use Calendar';


--
-- Name: COLUMN base_automation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.create_uid IS 'Created by';


--
-- Name: COLUMN base_automation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_automation.webhook_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.webhook_uuid IS 'Webhook UUID';


--
-- Name: COLUMN base_automation.record_getter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.record_getter IS 'Record Getter';


--
-- Name: COLUMN base_automation.trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trigger IS 'Trigger';


--
-- Name: COLUMN base_automation.trg_date_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_range_type IS 'Delay type';


--
-- Name: COLUMN base_automation.filter_pre_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.filter_pre_domain IS 'Before Update Domain';


--
-- Name: COLUMN base_automation.filter_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.filter_domain IS 'Apply on';


--
-- Name: COLUMN base_automation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.name IS 'Automation Rule Name';


--
-- Name: COLUMN base_automation.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.description IS 'Description';


--
-- Name: COLUMN base_automation.log_webhook_calls; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.log_webhook_calls IS 'Log Calls';


--
-- Name: COLUMN base_automation.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.active IS 'Active';


--
-- Name: COLUMN base_automation.last_run; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.last_run IS 'Last Run';


--
-- Name: COLUMN base_automation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.create_date IS 'Created on';


--
-- Name: COLUMN base_automation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.write_date IS 'Last Updated on';


--
-- Name: base_automation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_automation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_automation_id_seq OWNER TO runbot;

--
-- Name: base_automation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_automation_id_seq OWNED BY public.base_automation.id;


--
-- Name: base_automation_ir_model_fields_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_automation_ir_model_fields_rel (
    base_automation_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.base_automation_ir_model_fields_rel OWNER TO runbot;

--
-- Name: TABLE base_automation_ir_model_fields_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_automation_ir_model_fields_rel IS 'RELATION BETWEEN base_automation AND ir_model_fields';


--
-- Name: base_automation_onchange_fields_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_automation_onchange_fields_rel (
    base_automation_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.base_automation_onchange_fields_rel OWNER TO runbot;

--
-- Name: TABLE base_automation_onchange_fields_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_automation_onchange_fields_rel IS 'RELATION BETWEEN base_automation AND ir_model_fields';


--
-- Name: base_cache_signaling_assets; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_assets
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_assets OWNER TO runbot;

--
-- Name: base_cache_signaling_default; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_default
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_default OWNER TO runbot;

--
-- Name: base_cache_signaling_groups; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_groups
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_groups OWNER TO runbot;

--
-- Name: base_cache_signaling_routing; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_routing
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_routing OWNER TO runbot;

--
-- Name: base_cache_signaling_templates; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_templates
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_templates OWNER TO runbot;

--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    from_invoice boolean
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_document_layout.from_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.from_invoice IS 'From Invoice';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_geo_provider; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_geo_provider (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tech_name character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_geo_provider OWNER TO runbot;

--
-- Name: TABLE base_geo_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_geo_provider IS 'Geo Provider';


--
-- Name: COLUMN base_geo_provider.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.create_uid IS 'Created by';


--
-- Name: COLUMN base_geo_provider.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_geo_provider.tech_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.tech_name IS 'Technical Name';


--
-- Name: COLUMN base_geo_provider.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.name IS 'Name';


--
-- Name: COLUMN base_geo_provider.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.create_date IS 'Created on';


--
-- Name: COLUMN base_geo_provider.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.write_date IS 'Last Updated on';


--
-- Name: base_geo_provider_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_geo_provider_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_geo_provider_id_seq OWNER TO runbot;

--
-- Name: base_geo_provider_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_geo_provider_id_seq OWNED BY public.base_geo_provider.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


ALTER TABLE public.base_import_module OWNER TO runbot;

--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_module_id_seq OWNER TO runbot;

--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_language_install_website_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install_website_rel (
    base_language_install_id integer NOT NULL,
    website_id integer NOT NULL
);


ALTER TABLE public.base_language_install_website_rel OWNER TO runbot;

--
-- Name: TABLE base_language_install_website_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install_website_rel IS 'RELATION BETWEEN base_language_install AND website';


--
-- Name: base_module_install_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_request (
    id integer NOT NULL,
    module_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    body_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_request OWNER TO runbot;

--
-- Name: TABLE base_module_install_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_request IS 'Module Activation Request';


--
-- Name: COLUMN base_module_install_request.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.user_id IS 'User';


--
-- Name: COLUMN base_module_install_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_request.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.body_html IS 'Body';


--
-- Name: COLUMN base_module_install_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_date IS 'Last Updated on';


--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_request_id_seq OWNER TO runbot;

--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_request_id_seq OWNED BY public.base_module_install_request.id;


--
-- Name: base_module_install_review; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_review (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_review OWNER TO runbot;

--
-- Name: TABLE base_module_install_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_review IS 'Module Activation Review';


--
-- Name: COLUMN base_module_install_review.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_review.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_review.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_review.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_review.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_date IS 'Last Updated on';


--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_review_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_review_id_seq OWNER TO runbot;

--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_review_id_seq OWNED BY public.base_module_install_review.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_registry_signaling OWNER TO runbot;

--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: bus_presence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_presence (
    id integer NOT NULL,
    user_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone,
    guest_id integer,
    CONSTRAINT bus_presence_partner_or_guest_exists CHECK ((((user_id IS NOT NULL) AND (guest_id IS NULL)) OR ((user_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.bus_presence OWNER TO runbot;

--
-- Name: TABLE bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_presence IS 'User Presence';


--
-- Name: COLUMN bus_presence.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.user_id IS 'Users';


--
-- Name: COLUMN bus_presence.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.status IS 'IM Status';


--
-- Name: COLUMN bus_presence.last_poll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN bus_presence.last_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_presence IS 'Last Presence';


--
-- Name: COLUMN bus_presence.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.guest_id IS 'Guest';


--
-- Name: CONSTRAINT bus_presence_partner_or_guest_exists ON bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT bus_presence_partner_or_guest_exists ON public.bus_presence IS 'CHECK((user_id IS NOT NULL AND guest_id IS NULL) OR (user_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: bus_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_presence_id_seq OWNER TO runbot;

--
-- Name: bus_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_presence_id_seq OWNED BY public.bus_presence.id;


--
-- Name: calendar_alarm; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm (
    id integer NOT NULL,
    duration integer NOT NULL,
    duration_minutes integer,
    mail_template_id integer,
    create_uid integer,
    write_uid integer,
    alarm_type character varying NOT NULL,
    "interval" character varying NOT NULL,
    name jsonb NOT NULL,
    body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sms_template_id integer,
    sms_notify_responsible boolean
);


ALTER TABLE public.calendar_alarm OWNER TO runbot;

--
-- Name: TABLE calendar_alarm; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm IS 'Event Alarm';


--
-- Name: COLUMN calendar_alarm.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration IS 'Remind Before';


--
-- Name: COLUMN calendar_alarm.duration_minutes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration_minutes IS 'Duration in minutes';


--
-- Name: COLUMN calendar_alarm.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.mail_template_id IS 'Email Template';


--
-- Name: COLUMN calendar_alarm.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_alarm.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_alarm.alarm_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.alarm_type IS 'Type';


--
-- Name: COLUMN calendar_alarm."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm."interval" IS 'Unit';


--
-- Name: COLUMN calendar_alarm.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.name IS 'Name';


--
-- Name: COLUMN calendar_alarm.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.body IS 'Additional Message';


--
-- Name: COLUMN calendar_alarm.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_date IS 'Created on';


--
-- Name: COLUMN calendar_alarm.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_alarm.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN calendar_alarm.sms_notify_responsible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.sms_notify_responsible IS 'Notify Responsible';


--
-- Name: calendar_alarm_calendar_event_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm_calendar_event_rel (
    calendar_event_id integer NOT NULL,
    calendar_alarm_id integer NOT NULL
);


ALTER TABLE public.calendar_alarm_calendar_event_rel OWNER TO runbot;

--
-- Name: TABLE calendar_alarm_calendar_event_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm_calendar_event_rel IS 'RELATION BETWEEN calendar_event AND calendar_alarm';


--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_alarm_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_alarm_id_seq OWNER TO runbot;

--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_alarm_id_seq OWNED BY public.calendar_alarm.id;


--
-- Name: calendar_attendee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_attendee (
    id integer NOT NULL,
    event_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    common_name character varying,
    access_token character varying,
    state character varying,
    availability character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_attendee OWNER TO runbot;

--
-- Name: TABLE calendar_attendee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_attendee IS 'Calendar Attendee Information';


--
-- Name: COLUMN calendar_attendee.event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.event_id IS 'Meeting linked';


--
-- Name: COLUMN calendar_attendee.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.partner_id IS 'Attendee';


--
-- Name: COLUMN calendar_attendee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_attendee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_attendee.common_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.common_name IS 'Common name';


--
-- Name: COLUMN calendar_attendee.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_attendee.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.state IS 'Status';


--
-- Name: COLUMN calendar_attendee.availability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.availability IS 'Available/Busy';


--
-- Name: COLUMN calendar_attendee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_date IS 'Created on';


--
-- Name: COLUMN calendar_attendee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_date IS 'Last Updated on';


--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_attendee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_attendee_id_seq OWNER TO runbot;

--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_attendee_id_seq OWNED BY public.calendar_attendee.id;


--
-- Name: calendar_event; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event (
    id integer NOT NULL,
    user_id integer,
    videocall_channel_id integer,
    res_id integer,
    res_model_id integer,
    recurrence_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    location character varying,
    videocall_location character varying,
    access_token character varying,
    privacy character varying,
    show_as character varying NOT NULL,
    res_model character varying,
    start_date date,
    stop_date date,
    description text,
    active boolean,
    allday boolean,
    recurrency boolean,
    follow_recurrence boolean,
    start timestamp without time zone NOT NULL,
    stop timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision,
    opportunity_id integer
);


ALTER TABLE public.calendar_event OWNER TO runbot;

--
-- Name: TABLE calendar_event; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event IS 'Calendar Event';


--
-- Name: COLUMN calendar_event.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.user_id IS 'Organizer';


--
-- Name: COLUMN calendar_event.videocall_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.videocall_channel_id IS 'Discuss Channel';


--
-- Name: COLUMN calendar_event.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_id IS 'Document ID';


--
-- Name: COLUMN calendar_event.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model_id IS 'Document Model';


--
-- Name: COLUMN calendar_event.recurrence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrence_id IS 'Recurrence Rule';


--
-- Name: COLUMN calendar_event.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.name IS 'Meeting Subject';


--
-- Name: COLUMN calendar_event.location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.location IS 'Location';


--
-- Name: COLUMN calendar_event.videocall_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.videocall_location IS 'Meeting URL';


--
-- Name: COLUMN calendar_event.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_event.privacy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.privacy IS 'Privacy';


--
-- Name: COLUMN calendar_event.show_as; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.show_as IS 'Show as';


--
-- Name: COLUMN calendar_event.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model IS 'Document Model Name';


--
-- Name: COLUMN calendar_event.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start_date IS 'Start Date';


--
-- Name: COLUMN calendar_event.stop_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop_date IS 'End Date';


--
-- Name: COLUMN calendar_event.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.description IS 'Description';


--
-- Name: COLUMN calendar_event.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.active IS 'Active';


--
-- Name: COLUMN calendar_event.allday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.allday IS 'All Day';


--
-- Name: COLUMN calendar_event.recurrency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrency IS 'Recurrent';


--
-- Name: COLUMN calendar_event.follow_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.follow_recurrence IS 'Follow Recurrence';


--
-- Name: COLUMN calendar_event.start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start IS 'Start';


--
-- Name: COLUMN calendar_event.stop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop IS 'Stop';


--
-- Name: COLUMN calendar_event.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_event.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.duration IS 'Duration';


--
-- Name: COLUMN calendar_event.opportunity_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.opportunity_id IS 'Opportunity';


--
-- Name: calendar_event_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_id_seq OWNER TO runbot;

--
-- Name: calendar_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_id_seq OWNED BY public.calendar_event.id;


--
-- Name: calendar_event_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_res_partner_rel (
    res_partner_id integer NOT NULL,
    calendar_event_id integer NOT NULL
);


ALTER TABLE public.calendar_event_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE calendar_event_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_res_partner_rel IS 'RELATION BETWEEN res_partner AND calendar_event';


--
-- Name: calendar_event_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_type (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_event_type OWNER TO runbot;

--
-- Name: TABLE calendar_event_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_type IS 'Event Meeting Type';


--
-- Name: COLUMN calendar_event_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.color IS 'Color';


--
-- Name: COLUMN calendar_event_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.name IS 'Name';


--
-- Name: COLUMN calendar_event_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_date IS 'Last Updated on';


--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_type_id_seq OWNER TO runbot;

--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_type_id_seq OWNED BY public.calendar_event_type.id;


--
-- Name: calendar_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_filters (
    id integer NOT NULL,
    user_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    partner_checked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_filters OWNER TO runbot;

--
-- Name: TABLE calendar_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_filters IS 'Calendar Filters';


--
-- Name: COLUMN calendar_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.user_id IS 'Me';


--
-- Name: COLUMN calendar_filters.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_id IS 'Employee';


--
-- Name: COLUMN calendar_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.active IS 'Active';


--
-- Name: COLUMN calendar_filters.partner_checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_checked IS 'Checked';


--
-- Name: COLUMN calendar_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_date IS 'Created on';


--
-- Name: COLUMN calendar_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_date IS 'Last Updated on';


--
-- Name: calendar_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_filters_id_seq OWNER TO runbot;

--
-- Name: calendar_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_filters_id_seq OWNED BY public.calendar_filters.id;


--
-- Name: calendar_popover_delete_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_popover_delete_wizard (
    id integer NOT NULL,
    record integer,
    create_uid integer,
    write_uid integer,
    delete character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_popover_delete_wizard OWNER TO runbot;

--
-- Name: TABLE calendar_popover_delete_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_popover_delete_wizard IS 'Calendar Popover Delete Wizard';


--
-- Name: COLUMN calendar_popover_delete_wizard.record; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.record IS 'Calendar Event';


--
-- Name: COLUMN calendar_popover_delete_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_popover_delete_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_popover_delete_wizard.delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.delete IS 'Delete';


--
-- Name: COLUMN calendar_popover_delete_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.create_date IS 'Created on';


--
-- Name: COLUMN calendar_popover_delete_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.write_date IS 'Last Updated on';


--
-- Name: calendar_popover_delete_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_popover_delete_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_popover_delete_wizard_id_seq OWNER TO runbot;

--
-- Name: calendar_popover_delete_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_popover_delete_wizard_id_seq OWNED BY public.calendar_popover_delete_wizard.id;


--
-- Name: calendar_provider_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_provider_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    external_calendar_provider character varying,
    cal_client_id character varying,
    cal_client_secret character varying,
    microsoft_outlook_client_identifier character varying,
    microsoft_outlook_client_secret character varying,
    cal_sync_paused boolean,
    microsoft_outlook_sync_paused boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_provider_config OWNER TO runbot;

--
-- Name: TABLE calendar_provider_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_provider_config IS 'Calendar Provider Configuration Wizard';


--
-- Name: COLUMN calendar_provider_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_provider_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_provider_config.external_calendar_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.external_calendar_provider IS 'Choose an external calendar to configure';


--
-- Name: COLUMN calendar_provider_config.cal_client_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_id IS 'Google Client_id';


--
-- Name: COLUMN calendar_provider_config.cal_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_secret IS 'Google Client_key';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_identifier IS 'Outlook Client Id';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_secret IS 'Outlook Client Secret';


--
-- Name: COLUMN calendar_provider_config.cal_sync_paused; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_sync_paused IS 'Google Synchronization Paused';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_sync_paused; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_sync_paused IS 'Outlook Synchronization Paused';


--
-- Name: COLUMN calendar_provider_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.create_date IS 'Created on';


--
-- Name: COLUMN calendar_provider_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.write_date IS 'Last Updated on';


--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_provider_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_provider_config_id_seq OWNER TO runbot;

--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_provider_config_id_seq OWNED BY public.calendar_provider_config.id;


--
-- Name: calendar_recurrence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_recurrence (
    id integer NOT NULL,
    base_event_id integer,
    "interval" integer,
    count integer,
    day integer,
    trigger_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    event_tz character varying,
    rrule character varying,
    rrule_type character varying,
    end_type character varying,
    month_by character varying,
    weekday character varying,
    byday character varying,
    until date,
    mon boolean,
    tue boolean,
    wed boolean,
    thu boolean,
    fri boolean,
    sat boolean,
    sun boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT calendar_recurrence_month_day CHECK ((((rrule_type)::text <> 'monthly'::text) OR ((month_by)::text <> 'day'::text) OR ((day >= 1) AND (day <= 31)) OR (((weekday)::text = ANY ((ARRAY['MON'::character varying, 'TUE'::character varying, 'WED'::character varying, 'THU'::character varying, 'FRI'::character varying, 'SAT'::character varying, 'SUN'::character varying])::text[])) AND ((byday)::text = ANY ((ARRAY['1'::character varying, '2'::character varying, '3'::character varying, '4'::character varying, '-1'::character varying])::text[])))))
);


ALTER TABLE public.calendar_recurrence OWNER TO runbot;

--
-- Name: TABLE calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_recurrence IS 'Event Recurrence Rule';


--
-- Name: COLUMN calendar_recurrence.base_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.base_event_id IS 'Base Event';


--
-- Name: COLUMN calendar_recurrence."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence."interval" IS 'Interval';


--
-- Name: COLUMN calendar_recurrence.count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.count IS 'Count';


--
-- Name: COLUMN calendar_recurrence.day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.day IS 'Day';


--
-- Name: COLUMN calendar_recurrence.trigger_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.trigger_id IS 'Trigger';


--
-- Name: COLUMN calendar_recurrence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_recurrence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_recurrence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.name IS 'Name';


--
-- Name: COLUMN calendar_recurrence.event_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.event_tz IS 'Timezone';


--
-- Name: COLUMN calendar_recurrence.rrule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule IS 'Rrule';


--
-- Name: COLUMN calendar_recurrence.rrule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule_type IS 'Rrule Type';


--
-- Name: COLUMN calendar_recurrence.end_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.end_type IS 'End Type';


--
-- Name: COLUMN calendar_recurrence.month_by; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.month_by IS 'Month By';


--
-- Name: COLUMN calendar_recurrence.weekday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.weekday IS 'Weekday';


--
-- Name: COLUMN calendar_recurrence.byday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.byday IS 'By day';


--
-- Name: COLUMN calendar_recurrence.until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.until IS 'Repeat Until';


--
-- Name: COLUMN calendar_recurrence.mon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.mon IS 'Mon';


--
-- Name: COLUMN calendar_recurrence.tue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.tue IS 'Tue';


--
-- Name: COLUMN calendar_recurrence.wed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.wed IS 'Wed';


--
-- Name: COLUMN calendar_recurrence.thu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.thu IS 'Thu';


--
-- Name: COLUMN calendar_recurrence.fri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.fri IS 'Fri';


--
-- Name: COLUMN calendar_recurrence.sat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sat IS 'Sat';


--
-- Name: COLUMN calendar_recurrence.sun; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sun IS 'Sun';


--
-- Name: COLUMN calendar_recurrence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_date IS 'Created on';


--
-- Name: COLUMN calendar_recurrence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT calendar_recurrence_month_day ON calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT calendar_recurrence_month_day ON public.calendar_recurrence IS 'CHECK (rrule_type != ''monthly'' OR month_by != ''day'' OR day >= 1 AND day <= 31 OR weekday in (''MON'', ''TUE'', ''WED'', ''THU'', ''FRI'', ''SAT'', ''SUN'') AND byday in (''1'', ''2'', ''3'', ''4'', ''-1''))';


--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_recurrence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_recurrence_id_seq OWNER TO runbot;

--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_recurrence_id_seq OWNED BY public.calendar_recurrence.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: chatbot_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.chatbot_message (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    discuss_channel_id integer NOT NULL,
    script_step_id integer NOT NULL,
    user_script_answer_id integer,
    create_uid integer,
    write_uid integer,
    user_raw_answer text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.chatbot_message OWNER TO runbot;

--
-- Name: TABLE chatbot_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.chatbot_message IS 'Chatbot Message';


--
-- Name: COLUMN chatbot_message.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.mail_message_id IS 'Related Mail Message';


--
-- Name: COLUMN chatbot_message.discuss_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.discuss_channel_id IS 'Discussion Channel';


--
-- Name: COLUMN chatbot_message.script_step_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.script_step_id IS 'Chatbot Step';


--
-- Name: COLUMN chatbot_message.user_script_answer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.user_script_answer_id IS 'User''s answer';


--
-- Name: COLUMN chatbot_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.create_uid IS 'Created by';


--
-- Name: COLUMN chatbot_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN chatbot_message.user_raw_answer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.user_raw_answer IS 'User''s raw answer';


--
-- Name: COLUMN chatbot_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.create_date IS 'Created on';


--
-- Name: COLUMN chatbot_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.write_date IS 'Last Updated on';


--
-- Name: chatbot_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.chatbot_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.chatbot_message_id_seq OWNER TO runbot;

--
-- Name: chatbot_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.chatbot_message_id_seq OWNED BY public.chatbot_message.id;


--
-- Name: chatbot_script; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.chatbot_script (
    id integer NOT NULL,
    source_id integer NOT NULL,
    operator_partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    title jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.chatbot_script OWNER TO runbot;

--
-- Name: TABLE chatbot_script; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.chatbot_script IS 'Chatbot Script';


--
-- Name: COLUMN chatbot_script.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.source_id IS 'Source';


--
-- Name: COLUMN chatbot_script.operator_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.operator_partner_id IS 'Bot Operator';


--
-- Name: COLUMN chatbot_script.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.create_uid IS 'Created by';


--
-- Name: COLUMN chatbot_script.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.write_uid IS 'Last Updated by';


--
-- Name: COLUMN chatbot_script.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.title IS 'Title';


--
-- Name: COLUMN chatbot_script.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.active IS 'Active';


--
-- Name: COLUMN chatbot_script.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.create_date IS 'Created on';


--
-- Name: COLUMN chatbot_script.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.write_date IS 'Last Updated on';


--
-- Name: chatbot_script_answer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.chatbot_script_answer (
    id integer NOT NULL,
    sequence integer,
    script_step_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    redirect_link character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.chatbot_script_answer OWNER TO runbot;

--
-- Name: TABLE chatbot_script_answer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.chatbot_script_answer IS 'Chatbot Script Answer';


--
-- Name: COLUMN chatbot_script_answer.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.sequence IS 'Sequence';


--
-- Name: COLUMN chatbot_script_answer.script_step_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.script_step_id IS 'Script Step';


--
-- Name: COLUMN chatbot_script_answer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.create_uid IS 'Created by';


--
-- Name: COLUMN chatbot_script_answer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN chatbot_script_answer.redirect_link; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.redirect_link IS 'Redirect Link';


--
-- Name: COLUMN chatbot_script_answer.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.name IS 'Answer';


--
-- Name: COLUMN chatbot_script_answer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.create_date IS 'Created on';


--
-- Name: COLUMN chatbot_script_answer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.write_date IS 'Last Updated on';


--
-- Name: chatbot_script_answer_chatbot_script_step_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.chatbot_script_answer_chatbot_script_step_rel (
    chatbot_script_step_id integer NOT NULL,
    chatbot_script_answer_id integer NOT NULL
);


ALTER TABLE public.chatbot_script_answer_chatbot_script_step_rel OWNER TO runbot;

--
-- Name: TABLE chatbot_script_answer_chatbot_script_step_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.chatbot_script_answer_chatbot_script_step_rel IS 'RELATION BETWEEN chatbot_script_step AND chatbot_script_answer';


--
-- Name: chatbot_script_answer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.chatbot_script_answer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.chatbot_script_answer_id_seq OWNER TO runbot;

--
-- Name: chatbot_script_answer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.chatbot_script_answer_id_seq OWNED BY public.chatbot_script_answer.id;


--
-- Name: chatbot_script_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.chatbot_script_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.chatbot_script_id_seq OWNER TO runbot;

--
-- Name: chatbot_script_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.chatbot_script_id_seq OWNED BY public.chatbot_script.id;


--
-- Name: chatbot_script_step; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.chatbot_script_step (
    id integer NOT NULL,
    sequence integer,
    chatbot_script_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    step_type character varying NOT NULL,
    message jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    crm_team_id integer,
    forward_operator_with_assistant boolean
);


ALTER TABLE public.chatbot_script_step OWNER TO runbot;

--
-- Name: TABLE chatbot_script_step; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.chatbot_script_step IS 'Chatbot Script Step';


--
-- Name: COLUMN chatbot_script_step.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.sequence IS 'Sequence';


--
-- Name: COLUMN chatbot_script_step.chatbot_script_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.chatbot_script_id IS 'Chatbot';


--
-- Name: COLUMN chatbot_script_step.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.create_uid IS 'Created by';


--
-- Name: COLUMN chatbot_script_step.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN chatbot_script_step.step_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.step_type IS 'Step Type';


--
-- Name: COLUMN chatbot_script_step.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.message IS 'Message';


--
-- Name: COLUMN chatbot_script_step.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.create_date IS 'Created on';


--
-- Name: COLUMN chatbot_script_step.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.write_date IS 'Last Updated on';


--
-- Name: COLUMN chatbot_script_step.crm_team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.crm_team_id IS 'Sales Team';


--
-- Name: COLUMN chatbot_script_step.forward_operator_with_assistant; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.forward_operator_with_assistant IS 'Add Assistant ChatGPT';


--
-- Name: chatbot_script_step_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.chatbot_script_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.chatbot_script_step_id_seq OWNER TO runbot;

--
-- Name: chatbot_script_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.chatbot_script_step_id_seq OWNED BY public.chatbot_script_step.id;


--
-- Name: choose_delivery_carrier; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.choose_delivery_carrier (
    id integer NOT NULL,
    order_id integer NOT NULL,
    carrier_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    weight_uom_name character varying,
    delivery_message text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    delivery_price double precision,
    display_price double precision
);


ALTER TABLE public.choose_delivery_carrier OWNER TO runbot;

--
-- Name: TABLE choose_delivery_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.choose_delivery_carrier IS 'Delivery Carrier Selection Wizard';


--
-- Name: COLUMN choose_delivery_carrier.order_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.order_id IS 'Order';


--
-- Name: COLUMN choose_delivery_carrier.carrier_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.carrier_id IS 'Shipping Method';


--
-- Name: COLUMN choose_delivery_carrier.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.create_uid IS 'Created by';


--
-- Name: COLUMN choose_delivery_carrier.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.write_uid IS 'Last Updated by';


--
-- Name: COLUMN choose_delivery_carrier.weight_uom_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.weight_uom_name IS 'Weight Uom Name';


--
-- Name: COLUMN choose_delivery_carrier.delivery_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.delivery_message IS 'Delivery Message';


--
-- Name: COLUMN choose_delivery_carrier.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.create_date IS 'Created on';


--
-- Name: COLUMN choose_delivery_carrier.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.write_date IS 'Last Updated on';


--
-- Name: COLUMN choose_delivery_carrier.delivery_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.delivery_price IS 'Delivery Price';


--
-- Name: COLUMN choose_delivery_carrier.display_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.display_price IS 'Cost';


--
-- Name: choose_delivery_carrier_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.choose_delivery_carrier_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.choose_delivery_carrier_id_seq OWNER TO runbot;

--
-- Name: choose_delivery_carrier_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.choose_delivery_carrier_id_seq OWNED BY public.choose_delivery_carrier.id;


--
-- Name: crm_lead; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead (
    id integer NOT NULL,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    message_bounce integer,
    user_id integer,
    team_id integer,
    company_id integer,
    stage_id integer,
    color integer,
    recurring_plan integer,
    partner_id integer,
    title integer,
    lang_id integer,
    state_id integer,
    country_id integer,
    lost_reason_id integer,
    create_uid integer,
    write_uid integer,
    phone_sanitized character varying,
    email_normalized character varying,
    email_cc character varying,
    name character varying NOT NULL,
    referred character varying,
    type character varying NOT NULL,
    priority character varying,
    contact_name character varying,
    partner_name character varying,
    function character varying,
    email_from character varying,
    email_domain_criterion character varying,
    phone character varying,
    mobile character varying,
    phone_state character varying,
    email_state character varying,
    website character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    date_deadline date,
    lead_properties jsonb,
    description text,
    expected_revenue numeric,
    prorated_revenue numeric,
    recurring_revenue numeric,
    recurring_revenue_monthly numeric,
    recurring_revenue_monthly_prorated numeric,
    recurring_revenue_prorated numeric,
    active boolean,
    date_closed timestamp without time zone,
    date_automation_last timestamp without time zone,
    date_open timestamp without time zone,
    date_last_stage_update timestamp without time zone,
    date_conversion timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    day_open double precision,
    day_close double precision,
    probability double precision,
    automated_probability double precision,
    reveal_id character varying,
    iap_enrich_done boolean,
    lead_mining_request_id integer,
    datahub_company_id integer,
    CONSTRAINT crm_lead_check_probability CHECK (((probability >= (0)::double precision) AND (probability <= (100)::double precision)))
);


ALTER TABLE public.crm_lead OWNER TO runbot;

--
-- Name: TABLE crm_lead; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead IS 'Lead/Opportunity';


--
-- Name: COLUMN crm_lead.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.campaign_id IS 'Campaign';


--
-- Name: COLUMN crm_lead.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.source_id IS 'Source';


--
-- Name: COLUMN crm_lead.medium_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.medium_id IS 'Medium';


--
-- Name: COLUMN crm_lead.message_bounce; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.message_bounce IS 'Bounce';


--
-- Name: COLUMN crm_lead.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.company_id IS 'Company';


--
-- Name: COLUMN crm_lead.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.stage_id IS 'Stage';


--
-- Name: COLUMN crm_lead.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.color IS 'Color Index';


--
-- Name: COLUMN crm_lead.recurring_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.recurring_plan IS 'Recurring Plan';


--
-- Name: COLUMN crm_lead.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.title IS 'Title';


--
-- Name: COLUMN crm_lead.lang_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.lang_id IS 'Language';


--
-- Name: COLUMN crm_lead.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.state_id IS 'State';


--
-- Name: COLUMN crm_lead.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.country_id IS 'Country';


--
-- Name: COLUMN crm_lead.lost_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.lost_reason_id IS 'Lost Reason';


--
-- Name: COLUMN crm_lead.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead.phone_sanitized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.phone_sanitized IS 'Sanitized Number';


--
-- Name: COLUMN crm_lead.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN crm_lead.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.email_cc IS 'Email cc';


--
-- Name: COLUMN crm_lead.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.name IS 'Opportunity';


--
-- Name: COLUMN crm_lead.referred; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.referred IS 'Referred By';


--
-- Name: COLUMN crm_lead.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.type IS 'Type';


--
-- Name: COLUMN crm_lead.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.priority IS 'Priority';


--
-- Name: COLUMN crm_lead.contact_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.contact_name IS 'Contact Name';


--
-- Name: COLUMN crm_lead.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.partner_name IS 'Company Name';


--
-- Name: COLUMN crm_lead.function; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.function IS 'Job Position';


--
-- Name: COLUMN crm_lead.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.email_from IS 'Email';


--
-- Name: COLUMN crm_lead.email_domain_criterion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.email_domain_criterion IS 'Email Domain Criterion';


--
-- Name: COLUMN crm_lead.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.phone IS 'Phone';


--
-- Name: COLUMN crm_lead.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.mobile IS 'Mobile';


--
-- Name: COLUMN crm_lead.phone_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.phone_state IS 'Phone Quality';


--
-- Name: COLUMN crm_lead.email_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.email_state IS 'Email Quality';


--
-- Name: COLUMN crm_lead.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.website IS 'Website';


--
-- Name: COLUMN crm_lead.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.street IS 'Street';


--
-- Name: COLUMN crm_lead.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.street2 IS 'Street2';


--
-- Name: COLUMN crm_lead.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.zip IS 'Zip';


--
-- Name: COLUMN crm_lead.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.city IS 'City';


--
-- Name: COLUMN crm_lead.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_deadline IS 'Expected Closing';


--
-- Name: COLUMN crm_lead.lead_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.lead_properties IS 'Properties';


--
-- Name: COLUMN crm_lead.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.description IS 'Notes';


--
-- Name: COLUMN crm_lead.expected_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.expected_revenue IS 'Expected Revenue';


--
-- Name: COLUMN crm_lead.prorated_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.prorated_revenue IS 'Prorated Revenue';


--
-- Name: COLUMN crm_lead.recurring_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue IS 'Recurring Revenues';


--
-- Name: COLUMN crm_lead.recurring_revenue_monthly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue_monthly IS 'Expected MRR';


--
-- Name: COLUMN crm_lead.recurring_revenue_monthly_prorated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue_monthly_prorated IS 'Prorated MRR';


--
-- Name: COLUMN crm_lead.recurring_revenue_prorated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue_prorated IS 'Prorated Recurring Revenues';


--
-- Name: COLUMN crm_lead.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.active IS 'Active';


--
-- Name: COLUMN crm_lead.date_closed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_closed IS 'Closed Date';


--
-- Name: COLUMN crm_lead.date_automation_last; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_automation_last IS 'Last Action';


--
-- Name: COLUMN crm_lead.date_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_open IS 'Assignment Date';


--
-- Name: COLUMN crm_lead.date_last_stage_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_last_stage_update IS 'Last Stage Update';


--
-- Name: COLUMN crm_lead.date_conversion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_conversion IS 'Conversion Date';


--
-- Name: COLUMN crm_lead.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_lead.day_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.day_open IS 'Days to Assign';


--
-- Name: COLUMN crm_lead.day_close; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.day_close IS 'Days to Close';


--
-- Name: COLUMN crm_lead.probability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.probability IS 'Probability';


--
-- Name: COLUMN crm_lead.automated_probability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.automated_probability IS 'Automated Probability';


--
-- Name: COLUMN crm_lead.reveal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.reveal_id IS 'Reveal ID';


--
-- Name: COLUMN crm_lead.iap_enrich_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.iap_enrich_done IS 'Enrichment done';


--
-- Name: COLUMN crm_lead.lead_mining_request_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.lead_mining_request_id IS 'Lead Mining Request';


--
-- Name: COLUMN crm_lead.datahub_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.datahub_company_id IS 'Marketing Hub Company';


--
-- Name: CONSTRAINT crm_lead_check_probability ON crm_lead; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT crm_lead_check_probability ON public.crm_lead IS 'check(probability >= 0 and probability <= 100)';


--
-- Name: mail_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message (
    id integer NOT NULL,
    parent_id integer,
    res_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    author_id integer,
    author_guest_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    subject character varying,
    model character varying,
    record_name character varying,
    message_type character varying NOT NULL,
    email_from character varying,
    message_id character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    body text,
    is_internal boolean,
    reply_to_force_new boolean,
    email_add_signature boolean,
    date timestamp without time zone,
    pinned_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    document_message_id integer,
    external_messenger_id character varying
);


ALTER TABLE public.mail_message OWNER TO runbot;

--
-- Name: TABLE mail_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message IS 'Message';


--
-- Name: COLUMN mail_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_message.record_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_id IS 'Author';


--
-- Name: COLUMN mail_message.author_guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_guest_id IS 'Guest';


--
-- Name: COLUMN mail_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subject IS 'Subject';


--
-- Name: COLUMN mail_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_message.record_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_name IS 'Message Record Name';


--
-- Name: COLUMN mail_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_type IS 'Type';


--
-- Name: COLUMN mail_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_from IS 'From';


--
-- Name: COLUMN mail_message.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_id IS 'Message-Id';


--
-- Name: COLUMN mail_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_layout_xmlid IS 'Layout';


--
-- Name: COLUMN mail_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.body IS 'Contents';


--
-- Name: COLUMN mail_message.is_internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.is_internal IS 'Employee Only';


--
-- Name: COLUMN mail_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to_force_new IS 'No threading for answers';


--
-- Name: COLUMN mail_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_add_signature IS 'Email Add Signature';


--
-- Name: COLUMN mail_message.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.date IS 'Date';


--
-- Name: COLUMN mail_message.pinned_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.pinned_at IS 'Pinned';


--
-- Name: COLUMN mail_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_message.document_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.document_message_id IS 'Document Message';


--
-- Name: COLUMN mail_message.external_messenger_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.external_messenger_id IS 'External Messenger';


--
-- Name: crm_activity_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.crm_activity_report AS
 SELECT m.id,
    l.create_date AS lead_create_date,
    l.date_conversion,
    l.date_deadline,
    l.date_closed,
    m.subtype_id,
    m.mail_activity_type_id,
    m.author_id,
    m.date,
    m.body,
    l.id AS lead_id,
    l.user_id,
    l.team_id,
    l.country_id,
    l.company_id,
    l.stage_id,
    l.partner_id,
    l.type AS lead_type,
    l.active
   FROM (public.mail_message m
     JOIN public.crm_lead l ON ((m.res_id = l.id)))
  WHERE (((m.model)::text = 'crm.lead'::text) AND (m.mail_activity_type_id IS NOT NULL));


ALTER VIEW public.crm_activity_report OWNER TO runbot;

--
-- Name: crm_convert_lead_mass_lead_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_convert_lead_mass_lead_rel (
    crm_lead2opportunity_partner_mass_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


ALTER TABLE public.crm_convert_lead_mass_lead_rel OWNER TO runbot;

--
-- Name: TABLE crm_convert_lead_mass_lead_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_convert_lead_mass_lead_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner_mass AND crm_lead';


--
-- Name: crm_iap_lead_helpers; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_helpers (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_iap_lead_helpers OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_helpers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_helpers IS 'Helper methods for crm_iap_mine modules';


--
-- Name: COLUMN crm_iap_lead_helpers.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_helpers.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_helpers.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_helpers.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_helpers_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_iap_lead_helpers_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_iap_lead_helpers_id_seq OWNER TO runbot;

--
-- Name: crm_iap_lead_helpers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_iap_lead_helpers_id_seq OWNED BY public.crm_iap_lead_helpers.id;


--
-- Name: crm_iap_lead_industry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_industry (
    id integer NOT NULL,
    color integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    reveal_ids character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_iap_lead_industry OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_industry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_industry IS 'CRM IAP Lead Industry';


--
-- Name: COLUMN crm_iap_lead_industry.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.color IS 'Color Index';


--
-- Name: COLUMN crm_iap_lead_industry.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.sequence IS 'Sequence';


--
-- Name: COLUMN crm_iap_lead_industry.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_industry.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_industry.reveal_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.reveal_ids IS 'Reveal';


--
-- Name: COLUMN crm_iap_lead_industry.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.name IS 'Industry';


--
-- Name: COLUMN crm_iap_lead_industry.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_industry.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_industry_crm_iap_lead_mining_request_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_industry_crm_iap_lead_mining_request_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    crm_iap_lead_industry_id integer NOT NULL
);


ALTER TABLE public.crm_iap_lead_industry_crm_iap_lead_mining_request_rel OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_industry_crm_iap_lead_mining_request_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_industry_crm_iap_lead_mining_request_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND crm_iap_lead_industry';


--
-- Name: crm_iap_lead_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_iap_lead_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_iap_lead_industry_id_seq OWNER TO runbot;

--
-- Name: crm_iap_lead_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_iap_lead_industry_id_seq OWNED BY public.crm_iap_lead_industry.id;


--
-- Name: crm_iap_lead_mining_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_mining_request (
    id integer NOT NULL,
    lead_number integer NOT NULL,
    team_id integer,
    user_id integer,
    company_size_min integer,
    company_size_max integer,
    contact_number integer,
    preferred_role_id integer,
    seniority_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying NOT NULL,
    search_type character varying NOT NULL,
    error_type character varying,
    lead_type character varying NOT NULL,
    contact_filter_type character varying,
    filter_on_size boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_iap_lead_mining_request OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_mining_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_mining_request IS 'CRM Lead Mining Request';


--
-- Name: COLUMN crm_iap_lead_mining_request.lead_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.lead_number IS 'Number of Leads';


--
-- Name: COLUMN crm_iap_lead_mining_request.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_iap_lead_mining_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_iap_lead_mining_request.company_size_min; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.company_size_min IS 'Size';


--
-- Name: COLUMN crm_iap_lead_mining_request.company_size_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.company_size_max IS 'Company Size Max';


--
-- Name: COLUMN crm_iap_lead_mining_request.contact_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.contact_number IS 'Number of Contacts';


--
-- Name: COLUMN crm_iap_lead_mining_request.preferred_role_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.preferred_role_id IS 'Preferred Role';


--
-- Name: COLUMN crm_iap_lead_mining_request.seniority_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.seniority_id IS 'Seniority';


--
-- Name: COLUMN crm_iap_lead_mining_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_mining_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_mining_request.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.name IS 'Request Number';


--
-- Name: COLUMN crm_iap_lead_mining_request.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.state IS 'Status';


--
-- Name: COLUMN crm_iap_lead_mining_request.search_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.search_type IS 'Target';


--
-- Name: COLUMN crm_iap_lead_mining_request.error_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.error_type IS 'Error Type';


--
-- Name: COLUMN crm_iap_lead_mining_request.lead_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.lead_type IS 'Type';


--
-- Name: COLUMN crm_iap_lead_mining_request.contact_filter_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.contact_filter_type IS 'Filter on';


--
-- Name: COLUMN crm_iap_lead_mining_request.filter_on_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.filter_on_size IS 'Filter on Size';


--
-- Name: COLUMN crm_iap_lead_mining_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_mining_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_mining_request_crm_iap_lead_role_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_mining_request_crm_iap_lead_role_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    crm_iap_lead_role_id integer NOT NULL
);


ALTER TABLE public.crm_iap_lead_mining_request_crm_iap_lead_role_rel OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_mining_request_crm_iap_lead_role_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_crm_iap_lead_role_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND crm_iap_lead_role';


--
-- Name: crm_iap_lead_mining_request_crm_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_mining_request_crm_tag_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    crm_tag_id integer NOT NULL
);


ALTER TABLE public.crm_iap_lead_mining_request_crm_tag_rel OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_mining_request_crm_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_crm_tag_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND crm_tag';


--
-- Name: crm_iap_lead_mining_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_iap_lead_mining_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_iap_lead_mining_request_id_seq OWNER TO runbot;

--
-- Name: crm_iap_lead_mining_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_iap_lead_mining_request_id_seq OWNED BY public.crm_iap_lead_mining_request.id;


--
-- Name: crm_iap_lead_mining_request_res_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_mining_request_res_country_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    res_country_id integer NOT NULL
);


ALTER TABLE public.crm_iap_lead_mining_request_res_country_rel OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_mining_request_res_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_res_country_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND res_country';


--
-- Name: crm_iap_lead_mining_request_res_country_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_mining_request_res_country_state_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


ALTER TABLE public.crm_iap_lead_mining_request_res_country_state_rel OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_mining_request_res_country_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_res_country_state_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND res_country_state';


--
-- Name: crm_iap_lead_role; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_role (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    reveal_id character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_iap_lead_role OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_role; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_role IS 'People Role';


--
-- Name: COLUMN crm_iap_lead_role.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.color IS 'Color Index';


--
-- Name: COLUMN crm_iap_lead_role.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_role.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_role.reveal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.reveal_id IS 'Reveal';


--
-- Name: COLUMN crm_iap_lead_role.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.name IS 'Role Name';


--
-- Name: COLUMN crm_iap_lead_role.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_role.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_role_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_iap_lead_role_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_iap_lead_role_id_seq OWNER TO runbot;

--
-- Name: crm_iap_lead_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_iap_lead_role_id_seq OWNED BY public.crm_iap_lead_role.id;


--
-- Name: crm_iap_lead_seniority; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_seniority (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reveal_id character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_iap_lead_seniority OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_seniority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_seniority IS 'People Seniority';


--
-- Name: COLUMN crm_iap_lead_seniority.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_seniority.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_seniority.reveal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.reveal_id IS 'Reveal';


--
-- Name: COLUMN crm_iap_lead_seniority.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.name IS 'Name';


--
-- Name: COLUMN crm_iap_lead_seniority.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_seniority.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_seniority_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_iap_lead_seniority_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_iap_lead_seniority_id_seq OWNER TO runbot;

--
-- Name: crm_iap_lead_seniority_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_iap_lead_seniority_id_seq OWNED BY public.crm_iap_lead_seniority.id;


--
-- Name: crm_lead2opportunity_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead2opportunity_partner (
    id integer NOT NULL,
    lead_id integer NOT NULL,
    partner_id integer,
    user_id integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    action character varying,
    force_assignment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead2opportunity_partner OWNER TO runbot;

--
-- Name: TABLE crm_lead2opportunity_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead2opportunity_partner IS 'Convert Lead to Opportunity (not in mass)';


--
-- Name: COLUMN crm_lead2opportunity_partner.lead_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.lead_id IS 'Associated Lead';


--
-- Name: COLUMN crm_lead2opportunity_partner.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead2opportunity_partner.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead2opportunity_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead2opportunity_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead2opportunity_partner.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.name IS 'Conversion Action';


--
-- Name: COLUMN crm_lead2opportunity_partner.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.action IS 'Related Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner.force_assignment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.force_assignment IS 'Force assignment';


--
-- Name: COLUMN crm_lead2opportunity_partner.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead2opportunity_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.write_date IS 'Last Updated on';


--
-- Name: crm_lead2opportunity_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead2opportunity_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead2opportunity_partner_id_seq OWNER TO runbot;

--
-- Name: crm_lead2opportunity_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead2opportunity_partner_id_seq OWNED BY public.crm_lead2opportunity_partner.id;


--
-- Name: crm_lead2opportunity_partner_mass; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead2opportunity_partner_mass (
    id integer NOT NULL,
    lead_id integer,
    partner_id integer,
    user_id integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    action character varying,
    force_assignment boolean,
    deduplicate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead2opportunity_partner_mass OWNER TO runbot;

--
-- Name: TABLE crm_lead2opportunity_partner_mass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead2opportunity_partner_mass IS 'Convert Lead to Opportunity (in mass)';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.lead_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.lead_id IS 'Associated Lead';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.name IS 'Conversion Action';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.action IS 'Related Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.force_assignment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.force_assignment IS 'Force assignment';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.deduplicate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.deduplicate IS 'Apply deduplication';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.write_date IS 'Last Updated on';


--
-- Name: crm_lead2opportunity_partner_mass_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead2opportunity_partner_mass_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead2opportunity_partner_mass_id_seq OWNER TO runbot;

--
-- Name: crm_lead2opportunity_partner_mass_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead2opportunity_partner_mass_id_seq OWNED BY public.crm_lead2opportunity_partner_mass.id;


--
-- Name: crm_lead2opportunity_partner_mass_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead2opportunity_partner_mass_res_users_rel (
    crm_lead2opportunity_partner_mass_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.crm_lead2opportunity_partner_mass_res_users_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead2opportunity_partner_mass_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead2opportunity_partner_mass_res_users_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner_mass AND res_users';


--
-- Name: crm_lead_crm_lead2opportunity_partner_mass_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_crm_lead2opportunity_partner_mass_rel (
    crm_lead2opportunity_partner_mass_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


ALTER TABLE public.crm_lead_crm_lead2opportunity_partner_mass_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_crm_lead2opportunity_partner_mass_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_crm_lead2opportunity_partner_mass_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner_mass AND crm_lead';


--
-- Name: crm_lead_crm_lead2opportunity_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_crm_lead2opportunity_partner_rel (
    crm_lead2opportunity_partner_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


ALTER TABLE public.crm_lead_crm_lead2opportunity_partner_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_crm_lead2opportunity_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_crm_lead2opportunity_partner_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner AND crm_lead';


--
-- Name: crm_lead_crm_lead_lost_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_crm_lead_lost_rel (
    crm_lead_lost_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


ALTER TABLE public.crm_lead_crm_lead_lost_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_crm_lead_lost_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_crm_lead_lost_rel IS 'RELATION BETWEEN crm_lead_lost AND crm_lead';


--
-- Name: crm_lead_datahub_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_datahub_company_rel (
    datahub_company_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


ALTER TABLE public.crm_lead_datahub_company_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_datahub_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_datahub_company_rel IS 'RELATION BETWEEN datahub_company AND crm_lead';


--
-- Name: crm_lead_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_id_seq OWNER TO runbot;

--
-- Name: crm_lead_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_id_seq OWNED BY public.crm_lead.id;


--
-- Name: crm_lead_lost; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_lost (
    id integer NOT NULL,
    lost_reason_id integer,
    create_uid integer,
    write_uid integer,
    lost_feedback text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_lost OWNER TO runbot;

--
-- Name: TABLE crm_lead_lost; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_lost IS 'Get Lost Reason';


--
-- Name: COLUMN crm_lead_lost.lost_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.lost_reason_id IS 'Lost Reason';


--
-- Name: COLUMN crm_lead_lost.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_lost.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_lost.lost_feedback; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.lost_feedback IS 'Closing Note';


--
-- Name: COLUMN crm_lead_lost.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_lost.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.write_date IS 'Last Updated on';


--
-- Name: crm_lead_lost_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_lost_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_lost_id_seq OWNER TO runbot;

--
-- Name: crm_lead_lost_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_lost_id_seq OWNED BY public.crm_lead_lost.id;


--
-- Name: crm_lead_pls_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_pls_update (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    pls_start_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_pls_update OWNER TO runbot;

--
-- Name: TABLE crm_lead_pls_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_pls_update IS 'Update the probabilities';


--
-- Name: COLUMN crm_lead_pls_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_pls_update.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_pls_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_pls_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_pls_update.pls_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_pls_update.pls_start_date IS 'Pls Start Date';


--
-- Name: COLUMN crm_lead_pls_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_pls_update.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_pls_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_pls_update.write_date IS 'Last Updated on';


--
-- Name: crm_lead_pls_update_crm_lead_scoring_frequency_field_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_pls_update_crm_lead_scoring_frequency_field_rel (
    crm_lead_pls_update_id integer NOT NULL,
    crm_lead_scoring_frequency_field_id integer NOT NULL
);


ALTER TABLE public.crm_lead_pls_update_crm_lead_scoring_frequency_field_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_pls_update_crm_lead_scoring_frequency_field_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_pls_update_crm_lead_scoring_frequency_field_rel IS 'RELATION BETWEEN crm_lead_pls_update AND crm_lead_scoring_frequency_field';


--
-- Name: crm_lead_pls_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_pls_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_pls_update_id_seq OWNER TO runbot;

--
-- Name: crm_lead_pls_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_pls_update_id_seq OWNED BY public.crm_lead_pls_update.id;


--
-- Name: crm_lead_scoring_frequency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_scoring_frequency (
    id integer NOT NULL,
    team_id integer,
    create_uid integer,
    write_uid integer,
    variable character varying,
    value character varying,
    won_count numeric,
    lost_count numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_scoring_frequency OWNER TO runbot;

--
-- Name: TABLE crm_lead_scoring_frequency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_scoring_frequency IS 'Lead Scoring Frequency';


--
-- Name: COLUMN crm_lead_scoring_frequency.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead_scoring_frequency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_scoring_frequency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_scoring_frequency.variable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.variable IS 'Variable';


--
-- Name: COLUMN crm_lead_scoring_frequency.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.value IS 'Value';


--
-- Name: COLUMN crm_lead_scoring_frequency.won_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.won_count IS 'Won Count';


--
-- Name: COLUMN crm_lead_scoring_frequency.lost_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.lost_count IS 'Lost Count';


--
-- Name: COLUMN crm_lead_scoring_frequency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_scoring_frequency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.write_date IS 'Last Updated on';


--
-- Name: crm_lead_scoring_frequency_field; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_scoring_frequency_field (
    id integer NOT NULL,
    field_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_scoring_frequency_field OWNER TO runbot;

--
-- Name: TABLE crm_lead_scoring_frequency_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_scoring_frequency_field IS 'Fields that can be used for predictive lead scoring computation';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.field_id IS 'Field';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.write_date IS 'Last Updated on';


--
-- Name: crm_lead_scoring_frequency_field_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_scoring_frequency_field_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_scoring_frequency_field_id_seq OWNER TO runbot;

--
-- Name: crm_lead_scoring_frequency_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_scoring_frequency_field_id_seq OWNED BY public.crm_lead_scoring_frequency_field.id;


--
-- Name: crm_lead_scoring_frequency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_scoring_frequency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_scoring_frequency_id_seq OWNER TO runbot;

--
-- Name: crm_lead_scoring_frequency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_scoring_frequency_id_seq OWNED BY public.crm_lead_scoring_frequency.id;


--
-- Name: crm_lead_website_visitor_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_website_visitor_rel (
    crm_lead_id integer NOT NULL,
    website_visitor_id integer NOT NULL
);


ALTER TABLE public.crm_lead_website_visitor_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_website_visitor_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_website_visitor_rel IS 'RELATION BETWEEN crm_lead AND website_visitor';


--
-- Name: crm_lost_reason; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lost_reason (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lost_reason OWNER TO runbot;

--
-- Name: TABLE crm_lost_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lost_reason IS 'Opp. Lost Reason';


--
-- Name: COLUMN crm_lost_reason.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lost_reason.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lost_reason.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.name IS 'Description';


--
-- Name: COLUMN crm_lost_reason.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.active IS 'Active';


--
-- Name: COLUMN crm_lost_reason.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.create_date IS 'Created on';


--
-- Name: COLUMN crm_lost_reason.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.write_date IS 'Last Updated on';


--
-- Name: crm_lost_reason_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lost_reason_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lost_reason_id_seq OWNER TO runbot;

--
-- Name: crm_lost_reason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lost_reason_id_seq OWNED BY public.crm_lost_reason.id;


--
-- Name: crm_merge_opportunity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_merge_opportunity (
    id integer NOT NULL,
    user_id integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_merge_opportunity OWNER TO runbot;

--
-- Name: TABLE crm_merge_opportunity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_merge_opportunity IS 'Merge Opportunities';


--
-- Name: COLUMN crm_merge_opportunity.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_merge_opportunity.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_merge_opportunity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.create_uid IS 'Created by';


--
-- Name: COLUMN crm_merge_opportunity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_merge_opportunity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.create_date IS 'Created on';


--
-- Name: COLUMN crm_merge_opportunity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.write_date IS 'Last Updated on';


--
-- Name: crm_merge_opportunity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_merge_opportunity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_merge_opportunity_id_seq OWNER TO runbot;

--
-- Name: crm_merge_opportunity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_merge_opportunity_id_seq OWNED BY public.crm_merge_opportunity.id;


--
-- Name: crm_quotation_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_quotation_partner (
    id integer NOT NULL,
    lead_id integer NOT NULL,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_quotation_partner OWNER TO runbot;

--
-- Name: TABLE crm_quotation_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_quotation_partner IS 'Create new or use existing Customer on new Quotation';


--
-- Name: COLUMN crm_quotation_partner.lead_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.lead_id IS 'Associated Lead';


--
-- Name: COLUMN crm_quotation_partner.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.partner_id IS 'Customer';


--
-- Name: COLUMN crm_quotation_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.create_uid IS 'Created by';


--
-- Name: COLUMN crm_quotation_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_quotation_partner.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.action IS 'Quotation Customer';


--
-- Name: COLUMN crm_quotation_partner.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.create_date IS 'Created on';


--
-- Name: COLUMN crm_quotation_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.write_date IS 'Last Updated on';


--
-- Name: crm_quotation_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_quotation_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_quotation_partner_id_seq OWNER TO runbot;

--
-- Name: crm_quotation_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_quotation_partner_id_seq OWNED BY public.crm_quotation_partner.id;


--
-- Name: crm_recurring_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_recurring_plan (
    id integer NOT NULL,
    number_of_months integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT crm_recurring_plan_check_number_of_months CHECK ((number_of_months >= 0))
);


ALTER TABLE public.crm_recurring_plan OWNER TO runbot;

--
-- Name: TABLE crm_recurring_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_recurring_plan IS 'CRM Recurring revenue plans';


--
-- Name: COLUMN crm_recurring_plan.number_of_months; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.number_of_months IS '# Months';


--
-- Name: COLUMN crm_recurring_plan.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.sequence IS 'Sequence';


--
-- Name: COLUMN crm_recurring_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.create_uid IS 'Created by';


--
-- Name: COLUMN crm_recurring_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_recurring_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.name IS 'Plan Name';


--
-- Name: COLUMN crm_recurring_plan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.active IS 'Active';


--
-- Name: COLUMN crm_recurring_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.create_date IS 'Created on';


--
-- Name: COLUMN crm_recurring_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT crm_recurring_plan_check_number_of_months ON crm_recurring_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT crm_recurring_plan_check_number_of_months ON public.crm_recurring_plan IS 'CHECK(number_of_months >= 0)';


--
-- Name: crm_recurring_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_recurring_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_recurring_plan_id_seq OWNER TO runbot;

--
-- Name: crm_recurring_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_recurring_plan_id_seq OWNED BY public.crm_recurring_plan.id;


--
-- Name: crm_stage; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_stage (
    id integer NOT NULL,
    sequence integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    requirements text,
    is_won boolean,
    fold boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_stage OWNER TO runbot;

--
-- Name: TABLE crm_stage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_stage IS 'CRM Stages';


--
-- Name: COLUMN crm_stage.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.sequence IS 'Sequence';


--
-- Name: COLUMN crm_stage.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_stage.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.create_uid IS 'Created by';


--
-- Name: COLUMN crm_stage.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_stage.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.name IS 'Stage Name';


--
-- Name: COLUMN crm_stage.requirements; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.requirements IS 'Requirements';


--
-- Name: COLUMN crm_stage.is_won; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.is_won IS 'Is Won Stage?';


--
-- Name: COLUMN crm_stage.fold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.fold IS 'Folded in Pipeline';


--
-- Name: COLUMN crm_stage.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.create_date IS 'Created on';


--
-- Name: COLUMN crm_stage.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.write_date IS 'Last Updated on';


--
-- Name: crm_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_stage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_stage_id_seq OWNER TO runbot;

--
-- Name: crm_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_stage_id_seq OWNED BY public.crm_stage.id;


--
-- Name: crm_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_tag OWNER TO runbot;

--
-- Name: TABLE crm_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_tag IS 'CRM Tag';


--
-- Name: COLUMN crm_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.color IS 'Color';


--
-- Name: COLUMN crm_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_uid IS 'Created by';


--
-- Name: COLUMN crm_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.name IS 'Tag Name';


--
-- Name: COLUMN crm_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_date IS 'Created on';


--
-- Name: COLUMN crm_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_date IS 'Last Updated on';


--
-- Name: crm_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_tag_id_seq OWNER TO runbot;

--
-- Name: crm_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_tag_id_seq OWNED BY public.crm_tag.id;


--
-- Name: crm_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_tag_rel (
    lead_id integer NOT NULL,
    tag_id integer NOT NULL
);


ALTER TABLE public.crm_tag_rel OWNER TO runbot;

--
-- Name: TABLE crm_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_tag_rel IS 'RELATION BETWEEN crm_lead AND crm_tag';


--
-- Name: crm_team; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team (
    id integer NOT NULL,
    sequence integer,
    company_id integer,
    user_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    alias_id integer NOT NULL,
    assignment_domain character varying,
    lead_properties_definition jsonb,
    use_leads boolean,
    use_opportunities boolean,
    assignment_optout boolean,
    invoiced_target double precision
);


ALTER TABLE public.crm_team OWNER TO runbot;

--
-- Name: TABLE crm_team; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team IS 'Sales Team';


--
-- Name: COLUMN crm_team.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.sequence IS 'Sequence';


--
-- Name: COLUMN crm_team.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.company_id IS 'Company';


--
-- Name: COLUMN crm_team.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.user_id IS 'Team Leader';


--
-- Name: COLUMN crm_team.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.color IS 'Color Index';


--
-- Name: COLUMN crm_team.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.name IS 'Sales Team';


--
-- Name: COLUMN crm_team.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.active IS 'Active';


--
-- Name: COLUMN crm_team.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_date IS 'Created on';


--
-- Name: COLUMN crm_team.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_team.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.alias_id IS 'Alias';


--
-- Name: COLUMN crm_team.assignment_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.assignment_domain IS 'Assignment Domain';


--
-- Name: COLUMN crm_team.lead_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.lead_properties_definition IS 'Lead Properties';


--
-- Name: COLUMN crm_team.use_leads; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.use_leads IS 'Leads';


--
-- Name: COLUMN crm_team.use_opportunities; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.use_opportunities IS 'Pipeline';


--
-- Name: COLUMN crm_team.assignment_optout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.assignment_optout IS 'Skip auto assignment';


--
-- Name: COLUMN crm_team.invoiced_target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.invoiced_target IS 'Invoicing Target';


--
-- Name: crm_team_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_id_seq OWNER TO runbot;

--
-- Name: crm_team_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_id_seq OWNED BY public.crm_team.id;


--
-- Name: crm_team_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team_member (
    id integer NOT NULL,
    crm_team_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    assignment_max integer,
    assignment_domain character varying,
    assignment_optout boolean
);


ALTER TABLE public.crm_team_member OWNER TO runbot;

--
-- Name: TABLE crm_team_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team_member IS 'Sales Team Member';


--
-- Name: COLUMN crm_team_member.crm_team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.crm_team_id IS 'Sales Team';


--
-- Name: COLUMN crm_team_member.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_team_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team_member.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.active IS 'Active';


--
-- Name: COLUMN crm_team_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_date IS 'Created on';


--
-- Name: COLUMN crm_team_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_team_member.assignment_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.assignment_max IS 'Average Leads Capacity (on 30 days)';


--
-- Name: COLUMN crm_team_member.assignment_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.assignment_domain IS 'Assignment Domain';


--
-- Name: COLUMN crm_team_member.assignment_optout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.assignment_optout IS 'Skip auto assignment';


--
-- Name: crm_team_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_member_id_seq OWNER TO runbot;

--
-- Name: crm_team_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_member_id_seq OWNED BY public.crm_team_member.id;


--
-- Name: datahub_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.datahub_company (
    id integer NOT NULL,
    province_state integer,
    country_id integer,
    primary_naics integer,
    mailing_province integer,
    total_employees integer,
    local_employees integer,
    year_started integer,
    headquarters_country_name integer,
    partner_id integer,
    primary_res_partner_id integer,
    secondary_res_partner_id integer,
    tertiary_res_partner_id integer,
    primary_mailing_contact integer,
    secondary_mailing_contact integer,
    tertiary_mailing_contact integer,
    winning_tenders integer,
    submitted_tenders integer,
    reviews_nuber integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    business_name character varying,
    city character varying,
    postal_code character varying,
    street_address character varying,
    url character varying,
    duns character varying,
    mailing_street_address character varying,
    mailing_city character varying,
    mailing_postal_code character varying,
    telephone_number character varying,
    status character varying,
    line_of_business character varying,
    public_or_private character varying,
    primary_contact_prefix character varying,
    primary_contact_first_name character varying,
    primary_contact_middle_initial character varying,
    primary_contact_last_name character varying,
    primary_contact_suffix character varying,
    primary_contact character varying,
    primary_contact_title character varying,
    secondary_contact character varying,
    tertiary_contact character varying,
    home_based_business character varying,
    province_of_incorporation character varying,
    b_e_m_f_a_b_indicator character varying,
    state character varying NOT NULL,
    form_mode character varying,
    second_telephone_number character varying,
    district character varying,
    code character varying,
    business_entity_status character varying,
    legal_form_type character varying,
    hs_codes character varying,
    total_export character varying,
    total_import character varying,
    market_score character varying,
    fin_score character varying,
    express_analysis character varying,
    sanctions character varying,
    company_type_by_financial_reporting_form character varying,
    you_control_url character varying,
    buy_amount character varying,
    long_address character varying,
    phone_3 character varying,
    phone_4 character varying,
    phone_4_owner character varying,
    phone_5 character varying,
    phone_5_owner character varying,
    registration_date date,
    company_about text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sales_volume double precision,
    latitude double precision,
    longitude double precision,
    charter_capital double precision,
    revenue double precision,
    relative_revenue_growth_for_year double precision,
    assets double precision,
    cash_and_cash_equivalents double precision,
    bank_loans double precision,
    liabilities double precision,
    net_profit double precision,
    ebit double precision,
    ebitda double precision,
    net_debt double precision,
    net_debt_to_ebit double precision
);


ALTER TABLE public.datahub_company OWNER TO runbot;

--
-- Name: TABLE datahub_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.datahub_company IS 'Company';


--
-- Name: COLUMN datahub_company.province_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.province_state IS 'Province/State';


--
-- Name: COLUMN datahub_company.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.country_id IS 'Country';


--
-- Name: COLUMN datahub_company.primary_naics; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.primary_naics IS 'Primary NAICS Code';


--
-- Name: COLUMN datahub_company.mailing_province; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.mailing_province IS 'Mailing Province';


--
-- Name: COLUMN datahub_company.total_employees; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.total_employees IS 'Total Employees';


--
-- Name: COLUMN datahub_company.local_employees; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.local_employees IS 'Local Employees';


--
-- Name: COLUMN datahub_company.year_started; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.year_started IS 'Year Started';


--
-- Name: COLUMN datahub_company.headquarters_country_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.headquarters_country_name IS 'Headquarters_Country_Name';


--
-- Name: COLUMN datahub_company.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.partner_id IS 'Related Partner';


--
-- Name: COLUMN datahub_company.primary_res_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.primary_res_partner_id IS 'Primary Res Partner';


--
-- Name: COLUMN datahub_company.secondary_res_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.secondary_res_partner_id IS 'Secondary Res Partner';


--
-- Name: COLUMN datahub_company.tertiary_res_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.tertiary_res_partner_id IS 'Tertiary Res Partner';


--
-- Name: COLUMN datahub_company.primary_mailing_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.primary_mailing_contact IS 'Primary Mailing Contact';


--
-- Name: COLUMN datahub_company.secondary_mailing_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.secondary_mailing_contact IS 'Secondary Mailing Contact';


--
-- Name: COLUMN datahub_company.tertiary_mailing_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.tertiary_mailing_contact IS 'Tertiary Mailing Contact';


--
-- Name: COLUMN datahub_company.winning_tenders; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.winning_tenders IS 'Number of Winning Tenders';


--
-- Name: COLUMN datahub_company.submitted_tenders; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.submitted_tenders IS 'Number of Tender Proposals Submitted';


--
-- Name: COLUMN datahub_company.reviews_nuber; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.reviews_nuber IS 'Number of reviews';


--
-- Name: COLUMN datahub_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.create_uid IS 'Created by';


--
-- Name: COLUMN datahub_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN datahub_company.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.name IS 'Name';


--
-- Name: COLUMN datahub_company.business_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.business_name IS 'Business Name';


--
-- Name: COLUMN datahub_company.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.city IS 'City';


--
-- Name: COLUMN datahub_company.postal_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.postal_code IS 'Postal code';


--
-- Name: COLUMN datahub_company.street_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.street_address IS 'Street Address';


--
-- Name: COLUMN datahub_company.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.url IS 'URL';


--
-- Name: COLUMN datahub_company.duns; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.duns IS 'duns';


--
-- Name: COLUMN datahub_company.mailing_street_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.mailing_street_address IS 'Mailing Street Address';


--
-- Name: COLUMN datahub_company.mailing_city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.mailing_city IS 'Mailing City';


--
-- Name: COLUMN datahub_company.mailing_postal_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.mailing_postal_code IS 'Mailing Postal Code';


--
-- Name: COLUMN datahub_company.telephone_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.telephone_number IS 'Telephone Number';


--
-- Name: COLUMN datahub_company.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.status IS 'Status';


--
-- Name: COLUMN datahub_company.line_of_business; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.line_of_business IS 'Line Of Business';


--
-- Name: COLUMN datahub_company.public_or_private; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.public_or_private IS 'Public Or Private';


--
-- Name: COLUMN datahub_company.primary_contact_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.primary_contact_prefix IS 'Primary Contact Prefix';


--
-- Name: COLUMN datahub_company.primary_contact_first_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.primary_contact_first_name IS 'Primary Contact First Name';


--
-- Name: COLUMN datahub_company.primary_contact_middle_initial; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.primary_contact_middle_initial IS 'Primary Contact Middle Initial';


--
-- Name: COLUMN datahub_company.primary_contact_last_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.primary_contact_last_name IS 'Primary Contact Last Name';


--
-- Name: COLUMN datahub_company.primary_contact_suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.primary_contact_suffix IS 'Primary Contact Suffix';


--
-- Name: COLUMN datahub_company.primary_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.primary_contact IS 'Primary Contact';


--
-- Name: COLUMN datahub_company.primary_contact_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.primary_contact_title IS 'Primary Contact Title';


--
-- Name: COLUMN datahub_company.secondary_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.secondary_contact IS 'Secondary Contact';


--
-- Name: COLUMN datahub_company.tertiary_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.tertiary_contact IS 'Tertiary Contact';


--
-- Name: COLUMN datahub_company.home_based_business; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.home_based_business IS 'Home Based Business';


--
-- Name: COLUMN datahub_company.province_of_incorporation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.province_of_incorporation IS 'Province Of Incorporation';


--
-- Name: COLUMN datahub_company.b_e_m_f_a_b_indicator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.b_e_m_f_a_b_indicator IS 'B E M F A B Indicator';


--
-- Name: COLUMN datahub_company.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.state IS 'State';


--
-- Name: COLUMN datahub_company.form_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.form_mode IS 'Form Mode';


--
-- Name: COLUMN datahub_company.second_telephone_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.second_telephone_number IS 'Second Telephone Number';


--
-- Name: COLUMN datahub_company.district; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.district IS 'District';


--
-- Name: COLUMN datahub_company.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.code IS 'Code';


--
-- Name: COLUMN datahub_company.business_entity_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.business_entity_status IS 'Business Entity Status';


--
-- Name: COLUMN datahub_company.legal_form_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.legal_form_type IS 'Legal Form Type';


--
-- Name: COLUMN datahub_company.hs_codes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.hs_codes IS 'Hs Codes';


--
-- Name: COLUMN datahub_company.total_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.total_export IS 'Total Export';


--
-- Name: COLUMN datahub_company.total_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.total_import IS 'Total Import';


--
-- Name: COLUMN datahub_company.market_score; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.market_score IS 'Market Score';


--
-- Name: COLUMN datahub_company.fin_score; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.fin_score IS 'Fin Score';


--
-- Name: COLUMN datahub_company.express_analysis; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.express_analysis IS 'Express Analysis';


--
-- Name: COLUMN datahub_company.sanctions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.sanctions IS 'Sanctions';


--
-- Name: COLUMN datahub_company.company_type_by_financial_reporting_form; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.company_type_by_financial_reporting_form IS 'Company Type By Financial Reporting Form';


--
-- Name: COLUMN datahub_company.you_control_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.you_control_url IS 'Resource Link';


--
-- Name: COLUMN datahub_company.buy_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.buy_amount IS 'Number of sales';


--
-- Name: COLUMN datahub_company.long_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.long_address IS 'Long Address';


--
-- Name: COLUMN datahub_company.phone_3; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.phone_3 IS 'Phone 3';


--
-- Name: COLUMN datahub_company.phone_4; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.phone_4 IS 'Phone 4';


--
-- Name: COLUMN datahub_company.phone_4_owner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.phone_4_owner IS 'Phone 4 Owner';


--
-- Name: COLUMN datahub_company.phone_5; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.phone_5 IS 'Phone 5';


--
-- Name: COLUMN datahub_company.phone_5_owner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.phone_5_owner IS 'Phone 5 Owner';


--
-- Name: COLUMN datahub_company.registration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.registration_date IS 'Registration Date';


--
-- Name: COLUMN datahub_company.company_about; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.company_about IS 'Company About';


--
-- Name: COLUMN datahub_company.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.create_date IS 'Created on';


--
-- Name: COLUMN datahub_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN datahub_company.sales_volume; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.sales_volume IS 'Sales Volume';


--
-- Name: COLUMN datahub_company.latitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.latitude IS 'Latitude';


--
-- Name: COLUMN datahub_company.longitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.longitude IS 'Longitude';


--
-- Name: COLUMN datahub_company.charter_capital; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.charter_capital IS 'Charter Capital';


--
-- Name: COLUMN datahub_company.revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.revenue IS 'Revenue';


--
-- Name: COLUMN datahub_company.relative_revenue_growth_for_year; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.relative_revenue_growth_for_year IS 'Relative Revenue Growth for the Year, %';


--
-- Name: COLUMN datahub_company.assets; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.assets IS 'Assets';


--
-- Name: COLUMN datahub_company.cash_and_cash_equivalents; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.cash_and_cash_equivalents IS 'Cash And Cash Equivalents';


--
-- Name: COLUMN datahub_company.bank_loans; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.bank_loans IS 'Bank Loans';


--
-- Name: COLUMN datahub_company.liabilities; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.liabilities IS 'Long-term Liabilities, Target Financing and Provisions';


--
-- Name: COLUMN datahub_company.net_profit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.net_profit IS 'Net Profit';


--
-- Name: COLUMN datahub_company.ebit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.ebit IS 'Ebit';


--
-- Name: COLUMN datahub_company.ebitda; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.ebitda IS 'Ebitda';


--
-- Name: COLUMN datahub_company.net_debt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.net_debt IS 'Net Debt';


--
-- Name: COLUMN datahub_company.net_debt_to_ebit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company.net_debt_to_ebit IS 'Net Debt To Ebit';


--
-- Name: datahub_company_contact_person_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.datahub_company_contact_person_wizard (
    id integer NOT NULL,
    wizard_id integer,
    company_id integer,
    email_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    phone character varying,
    job_position character varying,
    contact_for character varying,
    contact_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.datahub_company_contact_person_wizard OWNER TO runbot;

--
-- Name: TABLE datahub_company_contact_person_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.datahub_company_contact_person_wizard IS 'Wizard to add contact for company';


--
-- Name: COLUMN datahub_company_contact_person_wizard.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_person_wizard.wizard_id IS 'Wizard';


--
-- Name: COLUMN datahub_company_contact_person_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_person_wizard.company_id IS 'Company';


--
-- Name: COLUMN datahub_company_contact_person_wizard.email_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_person_wizard.email_id IS 'Email';


--
-- Name: COLUMN datahub_company_contact_person_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_person_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN datahub_company_contact_person_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_person_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN datahub_company_contact_person_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_person_wizard.name IS 'Name';


--
-- Name: COLUMN datahub_company_contact_person_wizard.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_person_wizard.phone IS 'Phone';


--
-- Name: COLUMN datahub_company_contact_person_wizard.job_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_person_wizard.job_position IS 'Job Position';


--
-- Name: COLUMN datahub_company_contact_person_wizard.contact_for; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_person_wizard.contact_for IS 'Contact For';


--
-- Name: COLUMN datahub_company_contact_person_wizard.contact_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_person_wizard.contact_type IS 'Contact Type';


--
-- Name: COLUMN datahub_company_contact_person_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_person_wizard.create_date IS 'Created on';


--
-- Name: COLUMN datahub_company_contact_person_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_person_wizard.write_date IS 'Last Updated on';


--
-- Name: datahub_company_contact_person_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.datahub_company_contact_person_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.datahub_company_contact_person_wizard_id_seq OWNER TO runbot;

--
-- Name: datahub_company_contact_person_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.datahub_company_contact_person_wizard_id_seq OWNED BY public.datahub_company_contact_person_wizard.id;


--
-- Name: datahub_company_contact_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.datahub_company_contact_wizard (
    id integer NOT NULL,
    company_id integer,
    country_id integer,
    state_id integer,
    email_id integer,
    primary_res_partner_id integer,
    secondary_res_partner_id integer,
    tertiary_res_partner_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    company_name character varying NOT NULL,
    city character varying,
    street character varying,
    zip character varying,
    phone character varying,
    url character varying,
    lead_name_prefix character varying,
    use_contact_selection character varying,
    contact_name character varying,
    job_position character varying,
    tax_code character varying,
    add_personal_contact boolean,
    add_primary boolean,
    add_secondary boolean,
    add_tertiary boolean,
    use_company_phone boolean,
    use_existed_company boolean,
    for_primary boolean,
    for_secondary boolean,
    for_tertiary boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.datahub_company_contact_wizard OWNER TO runbot;

--
-- Name: TABLE datahub_company_contact_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.datahub_company_contact_wizard IS 'Wizard to Create Contact and Lead for Company';


--
-- Name: COLUMN datahub_company_contact_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.company_id IS 'Company';


--
-- Name: COLUMN datahub_company_contact_wizard.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.country_id IS 'Country';


--
-- Name: COLUMN datahub_company_contact_wizard.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.state_id IS 'Province/State';


--
-- Name: COLUMN datahub_company_contact_wizard.email_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.email_id IS 'Email';


--
-- Name: COLUMN datahub_company_contact_wizard.primary_res_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.primary_res_partner_id IS 'Primary Res Partner';


--
-- Name: COLUMN datahub_company_contact_wizard.secondary_res_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.secondary_res_partner_id IS 'Secondary Res Partner';


--
-- Name: COLUMN datahub_company_contact_wizard.tertiary_res_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.tertiary_res_partner_id IS 'Tertiary Res Partner';


--
-- Name: COLUMN datahub_company_contact_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN datahub_company_contact_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN datahub_company_contact_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN datahub_company_contact_wizard.company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.company_name IS 'Company Name';


--
-- Name: COLUMN datahub_company_contact_wizard.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.city IS 'City';


--
-- Name: COLUMN datahub_company_contact_wizard.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.street IS 'Street';


--
-- Name: COLUMN datahub_company_contact_wizard.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.zip IS 'Postal code';


--
-- Name: COLUMN datahub_company_contact_wizard.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.phone IS 'Phone';


--
-- Name: COLUMN datahub_company_contact_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.url IS 'URL';


--
-- Name: COLUMN datahub_company_contact_wizard.lead_name_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.lead_name_prefix IS 'Lead Name Prefix';


--
-- Name: COLUMN datahub_company_contact_wizard.use_contact_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.use_contact_selection IS 'Use Contact Selection';


--
-- Name: COLUMN datahub_company_contact_wizard.contact_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.contact_name IS 'Name';


--
-- Name: COLUMN datahub_company_contact_wizard.job_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.job_position IS 'Job Position';


--
-- Name: COLUMN datahub_company_contact_wizard.tax_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.tax_code IS 'Tax Code';


--
-- Name: COLUMN datahub_company_contact_wizard.add_personal_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.add_personal_contact IS 'Add Personal Contact if exist';


--
-- Name: COLUMN datahub_company_contact_wizard.add_primary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.add_primary IS 'Primary';


--
-- Name: COLUMN datahub_company_contact_wizard.add_secondary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.add_secondary IS 'Secondary';


--
-- Name: COLUMN datahub_company_contact_wizard.add_tertiary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.add_tertiary IS 'Tertiary';


--
-- Name: COLUMN datahub_company_contact_wizard.use_company_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.use_company_phone IS 'Use company telephone number for individual contact';


--
-- Name: COLUMN datahub_company_contact_wizard.use_existed_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.use_existed_company IS 'Use Existed Company';


--
-- Name: COLUMN datahub_company_contact_wizard.for_primary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.for_primary IS 'For Primary';


--
-- Name: COLUMN datahub_company_contact_wizard.for_secondary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.for_secondary IS 'For Secondary';


--
-- Name: COLUMN datahub_company_contact_wizard.for_tertiary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.for_tertiary IS 'For Tertiary';


--
-- Name: COLUMN datahub_company_contact_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.create_date IS 'Created on';


--
-- Name: COLUMN datahub_company_contact_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_contact_wizard.write_date IS 'Last Updated on';


--
-- Name: datahub_company_contact_wizard_datahub_company_email_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.datahub_company_contact_wizard_datahub_company_email_rel (
    datahub_company_contact_wizard_id integer NOT NULL,
    datahub_company_email_id integer NOT NULL
);


ALTER TABLE public.datahub_company_contact_wizard_datahub_company_email_rel OWNER TO runbot;

--
-- Name: TABLE datahub_company_contact_wizard_datahub_company_email_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.datahub_company_contact_wizard_datahub_company_email_rel IS 'RELATION BETWEEN datahub_company_contact_wizard AND datahub_company_email';


--
-- Name: datahub_company_contact_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.datahub_company_contact_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.datahub_company_contact_wizard_id_seq OWNER TO runbot;

--
-- Name: datahub_company_contact_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.datahub_company_contact_wizard_id_seq OWNED BY public.datahub_company_contact_wizard.id;


--
-- Name: datahub_company_datahub_naics_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.datahub_company_datahub_naics_rel (
    datahub_company_id integer NOT NULL,
    datahub_naics_id integer NOT NULL
);


ALTER TABLE public.datahub_company_datahub_naics_rel OWNER TO runbot;

--
-- Name: TABLE datahub_company_datahub_naics_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.datahub_company_datahub_naics_rel IS 'RELATION BETWEEN datahub_company AND datahub_naics';


--
-- Name: datahub_company_datahub_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.datahub_company_datahub_tag_rel (
    datahub_company_id integer NOT NULL,
    datahub_tag_id integer NOT NULL
);


ALTER TABLE public.datahub_company_datahub_tag_rel OWNER TO runbot;

--
-- Name: TABLE datahub_company_datahub_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.datahub_company_datahub_tag_rel IS 'RELATION BETWEEN datahub_company AND datahub_tag';


--
-- Name: datahub_company_email; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.datahub_company_email (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    email_belong character varying,
    individual_to character varying,
    is_default boolean,
    email_format_valid boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.datahub_company_email OWNER TO runbot;

--
-- Name: TABLE datahub_company_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.datahub_company_email IS 'Company Email';


--
-- Name: COLUMN datahub_company_email.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_email.company_id IS 'Company';


--
-- Name: COLUMN datahub_company_email.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_email.create_uid IS 'Created by';


--
-- Name: COLUMN datahub_company_email.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_email.write_uid IS 'Last Updated by';


--
-- Name: COLUMN datahub_company_email.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_email.email IS 'Email Address';


--
-- Name: COLUMN datahub_company_email.email_belong; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_email.email_belong IS 'Email Belong';


--
-- Name: COLUMN datahub_company_email.individual_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_email.individual_to IS 'Individual To';


--
-- Name: COLUMN datahub_company_email.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_email.is_default IS 'Is Default Email';


--
-- Name: COLUMN datahub_company_email.email_format_valid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_email.email_format_valid IS 'Email Format Valid';


--
-- Name: COLUMN datahub_company_email.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_email.create_date IS 'Created on';


--
-- Name: COLUMN datahub_company_email.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_company_email.write_date IS 'Last Updated on';


--
-- Name: datahub_company_email_datahub_mailing_list_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.datahub_company_email_datahub_mailing_list_wizard_rel (
    datahub_mailing_list_wizard_id integer NOT NULL,
    datahub_company_email_id integer NOT NULL
);


ALTER TABLE public.datahub_company_email_datahub_mailing_list_wizard_rel OWNER TO runbot;

--
-- Name: TABLE datahub_company_email_datahub_mailing_list_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.datahub_company_email_datahub_mailing_list_wizard_rel IS 'RELATION BETWEEN datahub_mailing_list_wizard AND datahub_company_email';


--
-- Name: datahub_company_email_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.datahub_company_email_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.datahub_company_email_id_seq OWNER TO runbot;

--
-- Name: datahub_company_email_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.datahub_company_email_id_seq OWNED BY public.datahub_company_email.id;


--
-- Name: datahub_company_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.datahub_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.datahub_company_id_seq OWNER TO runbot;

--
-- Name: datahub_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.datahub_company_id_seq OWNED BY public.datahub_company.id;


--
-- Name: datahub_mailing_list_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.datahub_mailing_list_wizard (
    id integer NOT NULL,
    mailing_list_id integer,
    country_id integer,
    primary_email integer,
    secondary_email integer,
    tertiary_email integer,
    default_company_email integer,
    existed_primary_mailing_contact integer,
    existed_secondary_mailing_contact integer,
    existed_tertiary_mailing_contact integer,
    create_uid integer,
    write_uid integer,
    contact_name character varying,
    contact_email character varying,
    contact_phone character varying,
    company_name character varying,
    primary_name character varying,
    primary_title character varying,
    secondary_name character varying,
    tertiary_name character varying,
    use_def_company_email boolean,
    use_company_phone boolean,
    for_primary boolean,
    for_secondary boolean,
    for_tertiary boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.datahub_mailing_list_wizard OWNER TO runbot;

--
-- Name: TABLE datahub_mailing_list_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.datahub_mailing_list_wizard IS 'Wizard for Adding Contacts to Mailing List';


--
-- Name: COLUMN datahub_mailing_list_wizard.mailing_list_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.mailing_list_id IS 'Mailing List';


--
-- Name: COLUMN datahub_mailing_list_wizard.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.country_id IS 'Country';


--
-- Name: COLUMN datahub_mailing_list_wizard.primary_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.primary_email IS 'Primary email';


--
-- Name: COLUMN datahub_mailing_list_wizard.secondary_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.secondary_email IS 'Secondary email';


--
-- Name: COLUMN datahub_mailing_list_wizard.tertiary_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.tertiary_email IS 'Tertiary email';


--
-- Name: COLUMN datahub_mailing_list_wizard.default_company_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.default_company_email IS 'Default Company Email';


--
-- Name: COLUMN datahub_mailing_list_wizard.existed_primary_mailing_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.existed_primary_mailing_contact IS 'Existed Primary Mailing Contact';


--
-- Name: COLUMN datahub_mailing_list_wizard.existed_secondary_mailing_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.existed_secondary_mailing_contact IS 'Existed Secondary Mailing Contact';


--
-- Name: COLUMN datahub_mailing_list_wizard.existed_tertiary_mailing_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.existed_tertiary_mailing_contact IS 'Existed Tertiary Mailing Contact';


--
-- Name: COLUMN datahub_mailing_list_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN datahub_mailing_list_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN datahub_mailing_list_wizard.contact_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.contact_name IS 'Contact Name';


--
-- Name: COLUMN datahub_mailing_list_wizard.contact_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.contact_email IS 'Contact Email';


--
-- Name: COLUMN datahub_mailing_list_wizard.contact_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.contact_phone IS 'Contact Phone';


--
-- Name: COLUMN datahub_mailing_list_wizard.company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.company_name IS 'Company Name';


--
-- Name: COLUMN datahub_mailing_list_wizard.primary_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.primary_name IS 'Primary Name';


--
-- Name: COLUMN datahub_mailing_list_wizard.primary_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.primary_title IS 'Primary Title';


--
-- Name: COLUMN datahub_mailing_list_wizard.secondary_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.secondary_name IS 'Secondary Name';


--
-- Name: COLUMN datahub_mailing_list_wizard.tertiary_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.tertiary_name IS 'Tertiary Name';


--
-- Name: COLUMN datahub_mailing_list_wizard.use_def_company_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.use_def_company_email IS 'Use Def Company Email';


--
-- Name: COLUMN datahub_mailing_list_wizard.use_company_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.use_company_phone IS 'Use Company Phone';


--
-- Name: COLUMN datahub_mailing_list_wizard.for_primary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.for_primary IS 'For Primary';


--
-- Name: COLUMN datahub_mailing_list_wizard.for_secondary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.for_secondary IS 'For Secondary';


--
-- Name: COLUMN datahub_mailing_list_wizard.for_tertiary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.for_tertiary IS 'For Tertiary';


--
-- Name: COLUMN datahub_mailing_list_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.create_date IS 'Created on';


--
-- Name: COLUMN datahub_mailing_list_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_mailing_list_wizard.write_date IS 'Last Updated on';


--
-- Name: datahub_mailing_list_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.datahub_mailing_list_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.datahub_mailing_list_wizard_id_seq OWNER TO runbot;

--
-- Name: datahub_mailing_list_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.datahub_mailing_list_wizard_id_seq OWNED BY public.datahub_mailing_list_wizard.id;


--
-- Name: datahub_naics; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.datahub_naics (
    id integer NOT NULL,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    title character varying NOT NULL,
    code character varying,
    type character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.datahub_naics OWNER TO runbot;

--
-- Name: TABLE datahub_naics; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.datahub_naics IS 'NAICS codes';


--
-- Name: COLUMN datahub_naics.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_naics.parent_id IS 'Parent Code';


--
-- Name: COLUMN datahub_naics.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_naics.create_uid IS 'Created by';


--
-- Name: COLUMN datahub_naics.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_naics.write_uid IS 'Last Updated by';


--
-- Name: COLUMN datahub_naics.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_naics.title IS 'Title';


--
-- Name: COLUMN datahub_naics.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_naics.code IS 'Code';


--
-- Name: COLUMN datahub_naics.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_naics.type IS 'Type';


--
-- Name: COLUMN datahub_naics.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_naics.create_date IS 'Created on';


--
-- Name: COLUMN datahub_naics.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_naics.write_date IS 'Last Updated on';


--
-- Name: datahub_naics_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.datahub_naics_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.datahub_naics_id_seq OWNER TO runbot;

--
-- Name: datahub_naics_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.datahub_naics_id_seq OWNED BY public.datahub_naics.id;


--
-- Name: datahub_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.datahub_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.datahub_tag OWNER TO runbot;

--
-- Name: TABLE datahub_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.datahub_tag IS 'Tags of company';


--
-- Name: COLUMN datahub_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_tag.color IS 'Color';


--
-- Name: COLUMN datahub_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_tag.create_uid IS 'Created by';


--
-- Name: COLUMN datahub_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN datahub_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_tag.name IS 'Name';


--
-- Name: COLUMN datahub_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_tag.create_date IS 'Created on';


--
-- Name: COLUMN datahub_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.datahub_tag.write_date IS 'Last Updated on';


--
-- Name: datahub_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.datahub_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.datahub_tag_id_seq OWNER TO runbot;

--
-- Name: datahub_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.datahub_tag_id_seq OWNED BY public.datahub_tag.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: delivery_carrier; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_carrier (
    id integer NOT NULL,
    sequence integer,
    company_id integer,
    product_id integer NOT NULL,
    shipping_insurance integer,
    create_uid integer,
    write_uid integer,
    delivery_type character varying NOT NULL,
    integration_level character varying,
    tracking_url character varying,
    invoice_policy character varying NOT NULL,
    name jsonb NOT NULL,
    carrier_description jsonb,
    active boolean,
    prod_environment boolean,
    debug_logging boolean,
    free_over boolean,
    return_label_on_delivery boolean,
    get_return_label_from_portal boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_weight double precision,
    max_volume double precision,
    margin double precision,
    fixed_margin double precision,
    amount double precision,
    fixed_price double precision,
    website_id integer,
    remote_website_url character varying,
    remote_page_id character varying,
    is_published boolean,
    CONSTRAINT delivery_carrier_margin_not_under_100_percent CHECK ((margin >= ('-1'::integer)::double precision)),
    CONSTRAINT delivery_carrier_shipping_insurance_is_percentage CHECK (((shipping_insurance >= 0) AND (shipping_insurance <= 100)))
);


ALTER TABLE public.delivery_carrier OWNER TO runbot;

--
-- Name: TABLE delivery_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_carrier IS 'Shipping Methods';


--
-- Name: COLUMN delivery_carrier.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.sequence IS 'Sequence';


--
-- Name: COLUMN delivery_carrier.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.company_id IS 'Company';


--
-- Name: COLUMN delivery_carrier.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.product_id IS 'Delivery Product';


--
-- Name: COLUMN delivery_carrier.shipping_insurance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.shipping_insurance IS 'Insurance Percentage';


--
-- Name: COLUMN delivery_carrier.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.create_uid IS 'Created by';


--
-- Name: COLUMN delivery_carrier.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.write_uid IS 'Last Updated by';


--
-- Name: COLUMN delivery_carrier.delivery_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.delivery_type IS 'Provider';


--
-- Name: COLUMN delivery_carrier.integration_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.integration_level IS 'Integration Level';


--
-- Name: COLUMN delivery_carrier.tracking_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.tracking_url IS 'Tracking Link';


--
-- Name: COLUMN delivery_carrier.invoice_policy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.invoice_policy IS 'Invoicing Policy';


--
-- Name: COLUMN delivery_carrier.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.name IS 'Delivery Method';


--
-- Name: COLUMN delivery_carrier.carrier_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.carrier_description IS 'Carrier Description';


--
-- Name: COLUMN delivery_carrier.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.active IS 'Active';


--
-- Name: COLUMN delivery_carrier.prod_environment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.prod_environment IS 'Environment';


--
-- Name: COLUMN delivery_carrier.debug_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.debug_logging IS 'Debug logging';


--
-- Name: COLUMN delivery_carrier.free_over; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.free_over IS 'Free if order amount is above';


--
-- Name: COLUMN delivery_carrier.return_label_on_delivery; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.return_label_on_delivery IS 'Generate Return Label';


--
-- Name: COLUMN delivery_carrier.get_return_label_from_portal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.get_return_label_from_portal IS 'Return Label Accessible from Customer Portal';


--
-- Name: COLUMN delivery_carrier.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.create_date IS 'Created on';


--
-- Name: COLUMN delivery_carrier.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.write_date IS 'Last Updated on';


--
-- Name: COLUMN delivery_carrier.max_weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.max_weight IS 'Max Weight';


--
-- Name: COLUMN delivery_carrier.max_volume; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.max_volume IS 'Max Volume';


--
-- Name: COLUMN delivery_carrier.margin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.margin IS 'Margin';


--
-- Name: COLUMN delivery_carrier.fixed_margin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.fixed_margin IS 'Fixed Margin';


--
-- Name: COLUMN delivery_carrier.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.amount IS 'Amount';


--
-- Name: COLUMN delivery_carrier.fixed_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.fixed_price IS 'Fixed Price';


--
-- Name: COLUMN delivery_carrier.website_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.website_id IS 'Website';


--
-- Name: COLUMN delivery_carrier.remote_website_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.remote_website_url IS 'Remote Website URL';


--
-- Name: COLUMN delivery_carrier.remote_page_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.remote_page_id IS 'Remote Page Id';


--
-- Name: COLUMN delivery_carrier.is_published; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.is_published IS 'Is Published';


--
-- Name: CONSTRAINT delivery_carrier_margin_not_under_100_percent ON delivery_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT delivery_carrier_margin_not_under_100_percent ON public.delivery_carrier IS 'CHECK (margin >= -1)';


--
-- Name: CONSTRAINT delivery_carrier_shipping_insurance_is_percentage ON delivery_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT delivery_carrier_shipping_insurance_is_percentage ON public.delivery_carrier IS 'CHECK(shipping_insurance >= 0 AND shipping_insurance <= 100)';


--
-- Name: delivery_carrier_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_carrier_country_rel (
    carrier_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.delivery_carrier_country_rel OWNER TO runbot;

--
-- Name: TABLE delivery_carrier_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_carrier_country_rel IS 'RELATION BETWEEN delivery_carrier AND res_country';


--
-- Name: delivery_carrier_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.delivery_carrier_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.delivery_carrier_id_seq OWNER TO runbot;

--
-- Name: delivery_carrier_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.delivery_carrier_id_seq OWNED BY public.delivery_carrier.id;


--
-- Name: delivery_carrier_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_carrier_state_rel (
    carrier_id integer NOT NULL,
    state_id integer NOT NULL
);


ALTER TABLE public.delivery_carrier_state_rel OWNER TO runbot;

--
-- Name: TABLE delivery_carrier_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_carrier_state_rel IS 'RELATION BETWEEN delivery_carrier AND res_country_state';


--
-- Name: delivery_price_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_price_rule (
    id integer NOT NULL,
    sequence integer NOT NULL,
    carrier_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    variable character varying NOT NULL,
    operator character varying NOT NULL,
    variable_factor character varying NOT NULL,
    list_base_price numeric NOT NULL,
    list_price numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_value double precision NOT NULL
);


ALTER TABLE public.delivery_price_rule OWNER TO runbot;

--
-- Name: TABLE delivery_price_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_price_rule IS 'Delivery Price Rules';


--
-- Name: COLUMN delivery_price_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.sequence IS 'Sequence';


--
-- Name: COLUMN delivery_price_rule.carrier_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.carrier_id IS 'Carrier';


--
-- Name: COLUMN delivery_price_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.create_uid IS 'Created by';


--
-- Name: COLUMN delivery_price_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN delivery_price_rule.variable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.variable IS 'Variable';


--
-- Name: COLUMN delivery_price_rule.operator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.operator IS 'Operator';


--
-- Name: COLUMN delivery_price_rule.variable_factor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.variable_factor IS 'Variable Factor';


--
-- Name: COLUMN delivery_price_rule.list_base_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.list_base_price IS 'Sale Base Price';


--
-- Name: COLUMN delivery_price_rule.list_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.list_price IS 'Sale Price';


--
-- Name: COLUMN delivery_price_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.create_date IS 'Created on';


--
-- Name: COLUMN delivery_price_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN delivery_price_rule.max_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.max_value IS 'Maximum Value';


--
-- Name: delivery_price_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.delivery_price_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.delivery_price_rule_id_seq OWNER TO runbot;

--
-- Name: delivery_price_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.delivery_price_rule_id_seq OWNED BY public.delivery_price_rule.id;


--
-- Name: delivery_zip_prefix; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_zip_prefix (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.delivery_zip_prefix OWNER TO runbot;

--
-- Name: TABLE delivery_zip_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_zip_prefix IS 'Delivery Zip Prefix';


--
-- Name: COLUMN delivery_zip_prefix.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_zip_prefix.create_uid IS 'Created by';


--
-- Name: COLUMN delivery_zip_prefix.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_zip_prefix.write_uid IS 'Last Updated by';


--
-- Name: COLUMN delivery_zip_prefix.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_zip_prefix.name IS 'Prefix';


--
-- Name: COLUMN delivery_zip_prefix.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_zip_prefix.create_date IS 'Created on';


--
-- Name: COLUMN delivery_zip_prefix.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_zip_prefix.write_date IS 'Last Updated on';


--
-- Name: delivery_zip_prefix_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.delivery_zip_prefix_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.delivery_zip_prefix_id_seq OWNER TO runbot;

--
-- Name: delivery_zip_prefix_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.delivery_zip_prefix_id_seq OWNED BY public.delivery_zip_prefix.id;


--
-- Name: delivery_zip_prefix_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_zip_prefix_rel (
    carrier_id integer NOT NULL,
    zip_prefix_id integer NOT NULL
);


ALTER TABLE public.delivery_zip_prefix_rel OWNER TO runbot;

--
-- Name: TABLE delivery_zip_prefix_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_zip_prefix_rel IS 'RELATION BETWEEN delivery_carrier AND delivery_zip_prefix';


--
-- Name: digest_digest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    periodicity character varying NOT NULL,
    state character varying,
    next_run_date date,
    name jsonb NOT NULL,
    kpi_res_users_connected boolean,
    kpi_mail_message_total boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    kpi_account_total_revenue boolean,
    kpi_crm_lead_created boolean,
    kpi_crm_opportunities_won boolean,
    kpi_livechat_rating boolean,
    kpi_livechat_conversations boolean,
    kpi_livechat_response boolean,
    kpi_website_sale_total boolean
);


ALTER TABLE public.digest_digest OWNER TO runbot;

--
-- Name: TABLE digest_digest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest IS 'Digest';


--
-- Name: COLUMN digest_digest.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.company_id IS 'Company';


--
-- Name: COLUMN digest_digest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_uid IS 'Created by';


--
-- Name: COLUMN digest_digest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_digest.periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.periodicity IS 'Periodicity';


--
-- Name: COLUMN digest_digest.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.state IS 'Status';


--
-- Name: COLUMN digest_digest.next_run_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.next_run_date IS 'Next Mailing Date';


--
-- Name: COLUMN digest_digest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.name IS 'Name';


--
-- Name: COLUMN digest_digest.kpi_res_users_connected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_res_users_connected IS 'Connected Users';


--
-- Name: COLUMN digest_digest.kpi_mail_message_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_mail_message_total IS 'Messages Sent';


--
-- Name: COLUMN digest_digest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_date IS 'Created on';


--
-- Name: COLUMN digest_digest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_date IS 'Last Updated on';


--
-- Name: COLUMN digest_digest.kpi_account_total_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_account_total_revenue IS 'Revenue';


--
-- Name: COLUMN digest_digest.kpi_crm_lead_created; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_crm_lead_created IS 'New Leads';


--
-- Name: COLUMN digest_digest.kpi_crm_opportunities_won; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_crm_opportunities_won IS 'Opportunities Won';


--
-- Name: COLUMN digest_digest.kpi_livechat_rating; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_livechat_rating IS '% of Happiness';


--
-- Name: COLUMN digest_digest.kpi_livechat_conversations; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_livechat_conversations IS 'Conversations handled';


--
-- Name: COLUMN digest_digest.kpi_livechat_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_livechat_response IS 'Time to answer (sec)';


--
-- Name: COLUMN digest_digest.kpi_website_sale_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_website_sale_total IS 'eCommerce Sales';


--
-- Name: digest_digest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_digest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_digest_id_seq OWNER TO runbot;

--
-- Name: digest_digest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_digest_id_seq OWNED BY public.digest_digest.id;


--
-- Name: digest_digest_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest_res_users_rel (
    digest_digest_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_digest_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_digest_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest_res_users_rel IS 'RELATION BETWEEN digest_digest AND res_users';


--
-- Name: digest_tip; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip (
    id integer NOT NULL,
    sequence integer,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb,
    tip_description jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.digest_tip OWNER TO runbot;

--
-- Name: TABLE digest_tip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip IS 'Digest Tips';


--
-- Name: COLUMN digest_tip.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.sequence IS 'Sequence';


--
-- Name: COLUMN digest_tip.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.group_id IS 'Authorized Group';


--
-- Name: COLUMN digest_tip.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_uid IS 'Created by';


--
-- Name: COLUMN digest_tip.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_tip.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.name IS 'Name';


--
-- Name: COLUMN digest_tip.tip_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.tip_description IS 'Tip description';


--
-- Name: COLUMN digest_tip.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_date IS 'Created on';


--
-- Name: COLUMN digest_tip.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_date IS 'Last Updated on';


--
-- Name: digest_tip_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_tip_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_tip_id_seq OWNER TO runbot;

--
-- Name: digest_tip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_tip_id_seq OWNED BY public.digest_tip.id;


--
-- Name: digest_tip_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip_res_users_rel (
    digest_tip_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_tip_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_tip_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip_res_users_rel IS 'RELATION BETWEEN digest_tip AND res_users';


--
-- Name: discuss_channel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel (
    id integer NOT NULL,
    parent_channel_id integer,
    from_message_id integer,
    group_public_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    channel_type character varying NOT NULL,
    default_display_mode character varying,
    sfu_channel_uuid character varying,
    sfu_server_url character varying,
    uuid character varying(50),
    description text,
    active boolean,
    allow_public_upload boolean,
    last_interest_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    messenger_operator_id integer,
    livechat_channel_id integer,
    livechat_operator_id integer,
    chatbot_current_step_id integer,
    country_id integer,
    anonymous_name character varying,
    livechat_active boolean,
    rating_last_value double precision,
    conversation_id character varying,
    history_messages jsonb,
    is_assistant_typing boolean,
    livechat_visitor_id integer,
    CONSTRAINT discuss_channel_group_public_id_check CHECK ((((channel_type)::text = 'channel'::text) OR ((channel_type)::text = 'whatsapp_twilio'::text) OR (group_public_id IS NULL))),
    CONSTRAINT discuss_channel_livechat_operator_id CHECK (((((channel_type)::text = 'livechat'::text) AND (livechat_operator_id IS NOT NULL)) OR ((channel_type)::text <> 'livechat'::text))),
    CONSTRAINT discuss_channel_sub_channel_no_group_public_id CHECK (((parent_channel_id IS NULL) OR (group_public_id IS NULL)))
);


ALTER TABLE public.discuss_channel OWNER TO runbot;

--
-- Name: TABLE discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel IS 'Discussion Channel';


--
-- Name: COLUMN discuss_channel.parent_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.parent_channel_id IS 'Parent Channel';


--
-- Name: COLUMN discuss_channel.from_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.from_message_id IS 'From Message';


--
-- Name: COLUMN discuss_channel.group_public_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.group_public_id IS 'Authorized Group';


--
-- Name: COLUMN discuss_channel.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.name IS 'Name';


--
-- Name: COLUMN discuss_channel.channel_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.channel_type IS 'Channel Type';


--
-- Name: COLUMN discuss_channel.default_display_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.default_display_mode IS 'Default Display Mode';


--
-- Name: COLUMN discuss_channel.sfu_channel_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_channel_uuid IS 'Sfu Channel Uuid';


--
-- Name: COLUMN discuss_channel.sfu_server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_server_url IS 'Sfu Server Url';


--
-- Name: COLUMN discuss_channel.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.uuid IS 'UUID';


--
-- Name: COLUMN discuss_channel.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.description IS 'Description';


--
-- Name: COLUMN discuss_channel.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.active IS 'Active';


--
-- Name: COLUMN discuss_channel.allow_public_upload; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.allow_public_upload IS 'Allow Public Upload';


--
-- Name: COLUMN discuss_channel.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_date IS 'Last Updated on';


--
-- Name: COLUMN discuss_channel.messenger_operator_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.messenger_operator_id IS 'Operator';


--
-- Name: COLUMN discuss_channel.livechat_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel.livechat_operator_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_operator_id IS 'Operator';


--
-- Name: COLUMN discuss_channel.chatbot_current_step_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.chatbot_current_step_id IS 'Chatbot Current Step';


--
-- Name: COLUMN discuss_channel.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.country_id IS 'Country';


--
-- Name: COLUMN discuss_channel.anonymous_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.anonymous_name IS 'Anonymous Name';


--
-- Name: COLUMN discuss_channel.livechat_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_active IS 'Is livechat ongoing?';


--
-- Name: COLUMN discuss_channel.rating_last_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.rating_last_value IS 'Rating Last Value';


--
-- Name: COLUMN discuss_channel.conversation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.conversation_id IS 'Assistant conversation id';


--
-- Name: COLUMN discuss_channel.history_messages; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.history_messages IS 'History';


--
-- Name: COLUMN discuss_channel.is_assistant_typing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.is_assistant_typing IS 'Is typing assistant message';


--
-- Name: COLUMN discuss_channel.livechat_visitor_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_visitor_id IS 'Visitor';


--
-- Name: CONSTRAINT discuss_channel_group_public_id_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_group_public_id_check ON public.discuss_channel IS 'CHECK (channel_type = ''channel'' OR channel_type = ''whatsapp_twilio'' OR group_public_id IS NULL)';


--
-- Name: CONSTRAINT discuss_channel_livechat_operator_id ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_livechat_operator_id ON public.discuss_channel IS 'CHECK((channel_type = ''livechat'' and livechat_operator_id is not null) or (channel_type != ''livechat''))';


--
-- Name: CONSTRAINT discuss_channel_sub_channel_no_group_public_id ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_sub_channel_no_group_public_id ON public.discuss_channel IS 'CHECK(parent_channel_id IS NULL OR group_public_id IS NULL)';


--
-- Name: discuss_channel_hr_department_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_hr_department_rel (
    discuss_channel_id integer NOT NULL,
    hr_department_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_hr_department_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_hr_department_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_hr_department_rel IS 'RELATION BETWEEN discuss_channel AND hr_department';


--
-- Name: discuss_channel_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_id_seq OWNED BY public.discuss_channel.id;


--
-- Name: discuss_channel_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_member (
    id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    channel_id integer NOT NULL,
    fetched_message_id integer,
    seen_message_id integer,
    new_message_separator integer NOT NULL,
    rtc_inviting_session_id integer,
    create_uid integer,
    write_uid integer,
    custom_channel_name character varying,
    fold_state character varying,
    custom_notifications character varying,
    mute_until_dt timestamp without time zone,
    unpin_dt timestamp without time zone,
    last_interest_dt timestamp without time zone,
    last_seen_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    assistant_toggle_status boolean,
    CONSTRAINT discuss_channel_member_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.discuss_channel_member OWNER TO runbot;

--
-- Name: TABLE discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_member IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_member.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_member.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.guest_id IS 'Guest';


--
-- Name: COLUMN discuss_channel_member.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_member.fetched_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.fetched_message_id IS 'Last Fetched';


--
-- Name: COLUMN discuss_channel_member.seen_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.seen_message_id IS 'Last Seen';


--
-- Name: COLUMN discuss_channel_member.new_message_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.new_message_separator IS 'New Message Separator';


--
-- Name: COLUMN discuss_channel_member.rtc_inviting_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.rtc_inviting_session_id IS 'Ringing session';


--
-- Name: COLUMN discuss_channel_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_member.custom_channel_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_channel_name IS 'Custom channel name';


--
-- Name: COLUMN discuss_channel_member.fold_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.fold_state IS 'Conversation Fold State';


--
-- Name: COLUMN discuss_channel_member.custom_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_notifications IS 'Customized Notifications';


--
-- Name: COLUMN discuss_channel_member.mute_until_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.mute_until_dt IS 'Mute notifications until';


--
-- Name: COLUMN discuss_channel_member.unpin_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.unpin_dt IS 'Unpin date';


--
-- Name: COLUMN discuss_channel_member.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel_member.last_seen_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_seen_dt IS 'Last seen date';


--
-- Name: COLUMN discuss_channel_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_date IS 'Last Updated on';


--
-- Name: COLUMN discuss_channel_member.assistant_toggle_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.assistant_toggle_status IS 'Force assistant to keep quite';


--
-- Name: CONSTRAINT discuss_channel_member_partner_or_guest_exists ON discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_member_partner_or_guest_exists ON public.discuss_channel_member IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_member_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_member_id_seq OWNED BY public.discuss_channel_member.id;


--
-- Name: discuss_channel_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_res_groups_rel (
    discuss_channel_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_res_groups_rel IS 'RELATION BETWEEN discuss_channel AND res_groups';


--
-- Name: discuss_channel_rtc_session; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_rtc_session (
    id integer NOT NULL,
    channel_member_id integer NOT NULL,
    channel_id integer,
    create_uid integer,
    write_uid integer,
    is_screen_sharing_on boolean,
    is_camera_on boolean,
    is_muted boolean,
    is_deaf boolean,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.discuss_channel_rtc_session OWNER TO runbot;

--
-- Name: TABLE discuss_channel_rtc_session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_rtc_session IS 'Mail RTC session';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_member_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_member_id IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_rtc_session.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_rtc_session.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_rtc_session.is_screen_sharing_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_screen_sharing_on IS 'Is sharing the screen';


--
-- Name: COLUMN discuss_channel_rtc_session.is_camera_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_camera_on IS 'Is sending user video';


--
-- Name: COLUMN discuss_channel_rtc_session.is_muted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_muted IS 'Is microphone muted';


--
-- Name: COLUMN discuss_channel_rtc_session.is_deaf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_deaf IS 'Has disabled incoming sound';


--
-- Name: COLUMN discuss_channel_rtc_session.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_date IS 'Last Updated On';


--
-- Name: COLUMN discuss_channel_rtc_session.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_date IS 'Created on';


--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_rtc_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNED BY public.discuss_channel_rtc_session.id;


--
-- Name: discuss_gif_favorite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_gif_favorite (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tenor_gif_id character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_gif_favorite OWNER TO runbot;

--
-- Name: TABLE discuss_gif_favorite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_gif_favorite IS 'Save favorite GIF from Tenor API';


--
-- Name: COLUMN discuss_gif_favorite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_gif_favorite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_gif_favorite.tenor_gif_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.tenor_gif_id IS 'GIF id from Tenor';


--
-- Name: COLUMN discuss_gif_favorite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_date IS 'Created on';


--
-- Name: COLUMN discuss_gif_favorite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_date IS 'Last Updated on';


--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_gif_favorite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNER TO runbot;

--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNED BY public.discuss_gif_favorite.id;


--
-- Name: discuss_voice_metadata; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_voice_metadata (
    id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_voice_metadata OWNER TO runbot;

--
-- Name: TABLE discuss_voice_metadata; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_voice_metadata IS 'Metadata for voice attachments';


--
-- Name: COLUMN discuss_voice_metadata.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.attachment_id IS 'Attachment';


--
-- Name: COLUMN discuss_voice_metadata.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_voice_metadata.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_voice_metadata.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_date IS 'Created on';


--
-- Name: COLUMN discuss_voice_metadata.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_date IS 'Last Updated on';


--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_voice_metadata_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNER TO runbot;

--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNED BY public.discuss_voice_metadata.id;


--
-- Name: email_template_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.email_template_attachment_rel (
    email_template_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.email_template_attachment_rel OWNER TO runbot;

--
-- Name: TABLE email_template_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.email_template_attachment_rel IS 'RELATION BETWEEN mail_template AND ir_attachment';


--
-- Name: employee_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.employee_category_rel (
    employee_id integer NOT NULL,
    category_id integer NOT NULL
);


ALTER TABLE public.employee_category_rel OWNER TO runbot;

--
-- Name: TABLE employee_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.employee_category_rel IS 'RELATION BETWEEN hr_employee AND hr_employee_category';


--
-- Name: fetchmail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.fetchmail_server (
    id integer NOT NULL,
    port integer,
    object_id integer,
    priority integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    server character varying,
    server_type character varying NOT NULL,
    "user" character varying,
    password character varying,
    script character varying,
    configuration text,
    active boolean,
    is_ssl boolean,
    attach boolean,
    original boolean,
    date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    google_gmail_access_token_expiration integer,
    google_gmail_authorization_code character varying,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying
);


ALTER TABLE public.fetchmail_server OWNER TO runbot;

--
-- Name: TABLE fetchmail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.fetchmail_server IS 'Incoming Mail Server';


--
-- Name: COLUMN fetchmail_server.port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.port IS 'Port';


--
-- Name: COLUMN fetchmail_server.object_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.object_id IS 'Create a New Record';


--
-- Name: COLUMN fetchmail_server.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.priority IS 'Server Priority';


--
-- Name: COLUMN fetchmail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_uid IS 'Created by';


--
-- Name: COLUMN fetchmail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN fetchmail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.name IS 'Name';


--
-- Name: COLUMN fetchmail_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.state IS 'Status';


--
-- Name: COLUMN fetchmail_server.server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server IS 'Server Name';


--
-- Name: COLUMN fetchmail_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server_type IS 'Server Type';


--
-- Name: COLUMN fetchmail_server."user"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server."user" IS 'Username';


--
-- Name: COLUMN fetchmail_server.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.password IS 'Password';


--
-- Name: COLUMN fetchmail_server.script; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.script IS 'Script';


--
-- Name: COLUMN fetchmail_server.configuration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.configuration IS 'Configuration';


--
-- Name: COLUMN fetchmail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.active IS 'Active';


--
-- Name: COLUMN fetchmail_server.is_ssl; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.is_ssl IS 'SSL/TLS';


--
-- Name: COLUMN fetchmail_server.attach; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.attach IS 'Keep Attachments';


--
-- Name: COLUMN fetchmail_server.original; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.original IS 'Keep Original';


--
-- Name: COLUMN fetchmail_server.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.date IS 'Last Fetch Date';


--
-- Name: COLUMN fetchmail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_date IS 'Created on';


--
-- Name: COLUMN fetchmail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.google_gmail_authorization_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_authorization_code IS 'Authorization Code';


--
-- Name: COLUMN fetchmail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.fetchmail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.fetchmail_server_id_seq OWNER TO runbot;

--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.fetchmail_server_id_seq OWNED BY public.fetchmail_server.id;


--
-- Name: file_upload_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.file_upload_wizard (
    id integer NOT NULL,
    vector_store_id integer,
    create_uid integer,
    write_uid integer,
    update_current_file boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.file_upload_wizard OWNER TO runbot;

--
-- Name: TABLE file_upload_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.file_upload_wizard IS 'Wizard File Upload';


--
-- Name: COLUMN file_upload_wizard.vector_store_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.file_upload_wizard.vector_store_id IS 'Vector Store';


--
-- Name: COLUMN file_upload_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.file_upload_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN file_upload_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.file_upload_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN file_upload_wizard.update_current_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.file_upload_wizard.update_current_file IS 'Replace Files With The Same Names';


--
-- Name: COLUMN file_upload_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.file_upload_wizard.create_date IS 'Created on';


--
-- Name: COLUMN file_upload_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.file_upload_wizard.write_date IS 'Last Updated on';


--
-- Name: file_upload_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.file_upload_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.file_upload_wizard_id_seq OWNER TO runbot;

--
-- Name: file_upload_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.file_upload_wizard_id_seq OWNED BY public.file_upload_wizard.id;


--
-- Name: file_upload_wizard_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.file_upload_wizard_ir_attachment_rel (
    file_upload_wizard_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.file_upload_wizard_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE file_upload_wizard_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.file_upload_wizard_ir_attachment_rel IS 'RELATION BETWEEN file_upload_wizard AND ir_attachment';


--
-- Name: hr_contract_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_contract_type (
    id integer NOT NULL,
    sequence integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_contract_type OWNER TO runbot;

--
-- Name: TABLE hr_contract_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_contract_type IS 'Contract Type';


--
-- Name: COLUMN hr_contract_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.sequence IS 'Sequence';


--
-- Name: COLUMN hr_contract_type.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.country_id IS 'Country';


--
-- Name: COLUMN hr_contract_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_contract_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_contract_type.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.code IS 'Code';


--
-- Name: COLUMN hr_contract_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.name IS 'Name';


--
-- Name: COLUMN hr_contract_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_contract_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.write_date IS 'Last Updated on';


--
-- Name: hr_contract_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_contract_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_contract_type_id_seq OWNER TO runbot;

--
-- Name: hr_contract_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_contract_type_id_seq OWNED BY public.hr_contract_type.id;


--
-- Name: hr_department; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_department (
    id integer NOT NULL,
    company_id integer,
    parent_id integer,
    manager_id integer,
    color integer,
    master_department_id integer,
    create_uid integer,
    write_uid integer,
    complete_name character varying,
    parent_path character varying,
    name jsonb NOT NULL,
    note text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_department OWNER TO runbot;

--
-- Name: TABLE hr_department; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_department IS 'Department';


--
-- Name: COLUMN hr_department.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.company_id IS 'Company';


--
-- Name: COLUMN hr_department.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.parent_id IS 'Parent Department';


--
-- Name: COLUMN hr_department.manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.manager_id IS 'Manager';


--
-- Name: COLUMN hr_department.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.color IS 'Color Index';


--
-- Name: COLUMN hr_department.master_department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.master_department_id IS 'Master Department';


--
-- Name: COLUMN hr_department.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.create_uid IS 'Created by';


--
-- Name: COLUMN hr_department.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_department.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.complete_name IS 'Complete Name';


--
-- Name: COLUMN hr_department.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.parent_path IS 'Parent Path';


--
-- Name: COLUMN hr_department.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.name IS 'Department Name';


--
-- Name: COLUMN hr_department.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.note IS 'Note';


--
-- Name: COLUMN hr_department.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.active IS 'Active';


--
-- Name: COLUMN hr_department.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.create_date IS 'Created on';


--
-- Name: COLUMN hr_department.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.write_date IS 'Last Updated on';


--
-- Name: hr_department_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_department_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_department_id_seq OWNER TO runbot;

--
-- Name: hr_department_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_department_id_seq OWNED BY public.hr_department.id;


--
-- Name: hr_departure_reason; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_departure_reason (
    id integer NOT NULL,
    sequence integer,
    reason_code integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_departure_reason OWNER TO runbot;

--
-- Name: TABLE hr_departure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_departure_reason IS 'Departure Reason';


--
-- Name: COLUMN hr_departure_reason.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.sequence IS 'Sequence';


--
-- Name: COLUMN hr_departure_reason.reason_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.reason_code IS 'Reason Code';


--
-- Name: COLUMN hr_departure_reason.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.create_uid IS 'Created by';


--
-- Name: COLUMN hr_departure_reason.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_departure_reason.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.name IS 'Reason';


--
-- Name: COLUMN hr_departure_reason.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.create_date IS 'Created on';


--
-- Name: COLUMN hr_departure_reason.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.write_date IS 'Last Updated on';


--
-- Name: hr_departure_reason_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_departure_reason_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_departure_reason_id_seq OWNER TO runbot;

--
-- Name: hr_departure_reason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_departure_reason_id_seq OWNED BY public.hr_departure_reason.id;


--
-- Name: hr_departure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_departure_wizard (
    id integer NOT NULL,
    departure_reason_id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    departure_date date NOT NULL,
    departure_description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_departure_wizard OWNER TO runbot;

--
-- Name: TABLE hr_departure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_departure_wizard IS 'Departure Wizard';


--
-- Name: COLUMN hr_departure_wizard.departure_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_reason_id IS 'Departure Reason';


--
-- Name: COLUMN hr_departure_wizard.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.employee_id IS 'Employee';


--
-- Name: COLUMN hr_departure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_departure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_departure_wizard.departure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_date IS 'Departure Date';


--
-- Name: COLUMN hr_departure_wizard.departure_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_description IS 'Additional Information';


--
-- Name: COLUMN hr_departure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_departure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_departure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_departure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_departure_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_departure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_departure_wizard_id_seq OWNED BY public.hr_departure_wizard.id;


--
-- Name: hr_employee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee (
    id integer NOT NULL,
    resource_id integer NOT NULL,
    company_id integer NOT NULL,
    resource_calendar_id integer,
    message_main_attachment_id integer,
    color integer,
    department_id integer,
    job_id integer,
    address_id integer,
    work_contact_id integer,
    work_location_id integer,
    user_id integer,
    parent_id integer,
    coach_id integer,
    private_state_id integer,
    private_country_id integer,
    country_id integer,
    children integer,
    country_of_birth integer,
    bank_account_id integer,
    distance_home_work integer,
    km_home_work integer,
    departure_reason_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    job_title character varying,
    work_phone character varying,
    mobile_phone character varying,
    work_email character varying,
    private_street character varying,
    private_street2 character varying,
    private_city character varying,
    private_zip character varying,
    private_phone character varying,
    private_email character varying,
    lang character varying,
    gender character varying,
    marital character varying NOT NULL,
    spouse_complete_name character varying,
    place_of_birth character varying,
    ssnid character varying,
    sinid character varying,
    identification_id character varying,
    passport_id character varying,
    permit_no character varying,
    visa_no character varying,
    certificate character varying,
    study_field character varying,
    study_school character varying,
    emergency_contact character varying,
    emergency_phone character varying,
    distance_home_work_unit character varying NOT NULL,
    employee_type character varying NOT NULL,
    barcode character varying,
    pin character varying,
    private_car_plate character varying,
    spouse_birthdate date,
    birthday date,
    visa_expire date,
    work_permit_expiration_date date,
    departure_date date,
    employee_properties jsonb,
    additional_note text,
    notes text,
    departure_description text,
    active boolean,
    is_flexible boolean,
    is_fully_flexible boolean,
    work_permit_scheduled_activity boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    passport_series character varying(2),
    passport_who_issued character varying,
    certificate_of_pension_series character varying(2),
    certificate_of_pension_id character varying,
    department_code character varying,
    guarantees_type character varying,
    "Redmine_ID" character varying,
    passport_date date,
    passport_validity_period date,
    certificate_of_disability_date date,
    certificate_of_disability_validity_period date,
    certificate_of_pension_date date,
    guarantees_validity_period date
);


ALTER TABLE public.hr_employee OWNER TO runbot;

--
-- Name: TABLE hr_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee IS 'Employee';


--
-- Name: COLUMN hr_employee.resource_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.resource_id IS 'Resource';


--
-- Name: COLUMN hr_employee.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.company_id IS 'Company';


--
-- Name: COLUMN hr_employee.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN hr_employee.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN hr_employee.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.color IS 'Color Index';


--
-- Name: COLUMN hr_employee.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.department_id IS 'Department';


--
-- Name: COLUMN hr_employee.job_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.job_id IS 'Job Position';


--
-- Name: COLUMN hr_employee.address_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.address_id IS 'Work Address';


--
-- Name: COLUMN hr_employee.work_contact_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_contact_id IS 'Work Contact';


--
-- Name: COLUMN hr_employee.work_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_location_id IS 'Work Location';


--
-- Name: COLUMN hr_employee.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.user_id IS 'User';


--
-- Name: COLUMN hr_employee.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.parent_id IS 'Manager';


--
-- Name: COLUMN hr_employee.coach_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.coach_id IS 'Coach';


--
-- Name: COLUMN hr_employee.private_state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_state_id IS 'Private State';


--
-- Name: COLUMN hr_employee.private_country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_country_id IS 'Private Country';


--
-- Name: COLUMN hr_employee.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.country_id IS 'Nationality (Country)';


--
-- Name: COLUMN hr_employee.children; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.children IS 'Number of Dependent Children';


--
-- Name: COLUMN hr_employee.country_of_birth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.country_of_birth IS 'Country of Birth';


--
-- Name: COLUMN hr_employee.bank_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN hr_employee.distance_home_work; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.distance_home_work IS 'Home-Work Distance';


--
-- Name: COLUMN hr_employee.km_home_work; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.km_home_work IS 'Home-Work Distance in Km';


--
-- Name: COLUMN hr_employee.departure_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.departure_reason_id IS 'Departure Reason';


--
-- Name: COLUMN hr_employee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.name IS 'Employee Name';


--
-- Name: COLUMN hr_employee.job_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.job_title IS 'Job Title';


--
-- Name: COLUMN hr_employee.work_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_phone IS 'Work Phone';


--
-- Name: COLUMN hr_employee.mobile_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.mobile_phone IS 'Work Mobile';


--
-- Name: COLUMN hr_employee.work_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_email IS 'Work Email';


--
-- Name: COLUMN hr_employee.private_street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_street IS 'Private Street';


--
-- Name: COLUMN hr_employee.private_street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_street2 IS 'Private Street2';


--
-- Name: COLUMN hr_employee.private_city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_city IS 'Private City';


--
-- Name: COLUMN hr_employee.private_zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_zip IS 'Private Zip';


--
-- Name: COLUMN hr_employee.private_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_phone IS 'Private Phone';


--
-- Name: COLUMN hr_employee.private_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_email IS 'Private Email';


--
-- Name: COLUMN hr_employee.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.lang IS 'Lang';


--
-- Name: COLUMN hr_employee.gender; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.gender IS 'Gender';


--
-- Name: COLUMN hr_employee.marital; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.marital IS 'Marital Status';


--
-- Name: COLUMN hr_employee.spouse_complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.spouse_complete_name IS 'Spouse Complete Name';


--
-- Name: COLUMN hr_employee.place_of_birth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.place_of_birth IS 'Place of Birth';


--
-- Name: COLUMN hr_employee.ssnid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.ssnid IS 'SSN No';


--
-- Name: COLUMN hr_employee.sinid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.sinid IS 'SIN No';


--
-- Name: COLUMN hr_employee.identification_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.identification_id IS 'Identification No';


--
-- Name: COLUMN hr_employee.passport_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.passport_id IS 'Passport No';


--
-- Name: COLUMN hr_employee.permit_no; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.permit_no IS 'Work Permit No';


--
-- Name: COLUMN hr_employee.visa_no; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.visa_no IS 'Visa No';


--
-- Name: COLUMN hr_employee.certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.certificate IS 'Certificate Level';


--
-- Name: COLUMN hr_employee.study_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.study_field IS 'Field of Study';


--
-- Name: COLUMN hr_employee.study_school; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.study_school IS 'School';


--
-- Name: COLUMN hr_employee.emergency_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.emergency_contact IS 'Contact Name';


--
-- Name: COLUMN hr_employee.emergency_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.emergency_phone IS 'Contact Phone';


--
-- Name: COLUMN hr_employee.distance_home_work_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.distance_home_work_unit IS 'Home-Work Distance unit';


--
-- Name: COLUMN hr_employee.employee_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.employee_type IS 'Employee Type';


--
-- Name: COLUMN hr_employee.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.barcode IS 'Badge ID';


--
-- Name: COLUMN hr_employee.pin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.pin IS 'PIN';


--
-- Name: COLUMN hr_employee.private_car_plate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_car_plate IS 'Private Car Plate';


--
-- Name: COLUMN hr_employee.spouse_birthdate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.spouse_birthdate IS 'Spouse Birthdate';


--
-- Name: COLUMN hr_employee.birthday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.birthday IS 'Date of Birth';


--
-- Name: COLUMN hr_employee.visa_expire; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.visa_expire IS 'Visa Expiration Date';


--
-- Name: COLUMN hr_employee.work_permit_expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_permit_expiration_date IS 'Work Permit Expiration Date';


--
-- Name: COLUMN hr_employee.departure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.departure_date IS 'Departure Date';


--
-- Name: COLUMN hr_employee.employee_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.employee_properties IS 'Properties';


--
-- Name: COLUMN hr_employee.additional_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.additional_note IS 'Additional Note';


--
-- Name: COLUMN hr_employee.notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.notes IS 'Notes';


--
-- Name: COLUMN hr_employee.departure_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.departure_description IS 'Additional Information';


--
-- Name: COLUMN hr_employee.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.active IS 'Active';


--
-- Name: COLUMN hr_employee.is_flexible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.is_flexible IS 'Is Flexible';


--
-- Name: COLUMN hr_employee.is_fully_flexible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.is_fully_flexible IS 'Is Fully Flexible';


--
-- Name: COLUMN hr_employee.work_permit_scheduled_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_permit_scheduled_activity IS 'Work Permit Scheduled Activity';


--
-- Name: COLUMN hr_employee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_employee.passport_series; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.passport_series IS 'Passport Series';


--
-- Name: COLUMN hr_employee.passport_who_issued; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.passport_who_issued IS 'Who issued passport';


--
-- Name: COLUMN hr_employee.certificate_of_pension_series; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.certificate_of_pension_series IS 'Certificate of pension series';


--
-- Name: COLUMN hr_employee.certificate_of_pension_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.certificate_of_pension_id IS 'Certificate of pension No';


--
-- Name: COLUMN hr_employee.department_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.department_code IS 'Department Code';


--
-- Name: COLUMN hr_employee.guarantees_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.guarantees_type IS 'Guarantees Type';


--
-- Name: COLUMN hr_employee."Redmine_ID"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee."Redmine_ID" IS 'Redmine ID';


--
-- Name: COLUMN hr_employee.passport_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.passport_date IS 'Passport date';


--
-- Name: COLUMN hr_employee.passport_validity_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.passport_validity_period IS 'Passport validity period';


--
-- Name: COLUMN hr_employee.certificate_of_disability_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.certificate_of_disability_date IS 'Certificate of disability date';


--
-- Name: COLUMN hr_employee.certificate_of_disability_validity_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.certificate_of_disability_validity_period IS 'Certificate of disability validity period';


--
-- Name: COLUMN hr_employee.certificate_of_pension_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.certificate_of_pension_date IS 'Certificate of pension date';


--
-- Name: COLUMN hr_employee.guarantees_validity_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.guarantees_validity_period IS 'Guarantees validity period';


--
-- Name: hr_employee_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_category (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_category OWNER TO runbot;

--
-- Name: TABLE hr_employee_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_category IS 'Employee Category';


--
-- Name: COLUMN hr_employee_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.color IS 'Color Index';


--
-- Name: COLUMN hr_employee_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.name IS 'Tag Name';


--
-- Name: COLUMN hr_employee_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.write_date IS 'Last Updated on';


--
-- Name: hr_employee_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_category_id_seq OWNER TO runbot;

--
-- Name: hr_employee_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_category_id_seq OWNED BY public.hr_employee_category.id;


--
-- Name: hr_employee_cv_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_cv_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    color_primary character varying NOT NULL,
    color_secondary character varying NOT NULL,
    show_skills boolean,
    show_contact boolean,
    show_others boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_cv_wizard OWNER TO runbot;

--
-- Name: TABLE hr_employee_cv_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_cv_wizard IS 'Print Resume';


--
-- Name: COLUMN hr_employee_cv_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_cv_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_cv_wizard.color_primary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.color_primary IS 'Primary Color';


--
-- Name: COLUMN hr_employee_cv_wizard.color_secondary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.color_secondary IS 'Secondary Color';


--
-- Name: COLUMN hr_employee_cv_wizard.show_skills; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.show_skills IS 'Skills';


--
-- Name: COLUMN hr_employee_cv_wizard.show_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.show_contact IS 'Contact Information';


--
-- Name: COLUMN hr_employee_cv_wizard.show_others; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.show_others IS 'Others';


--
-- Name: COLUMN hr_employee_cv_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_cv_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_employee_cv_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_cv_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_cv_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_employee_cv_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_cv_wizard_id_seq OWNED BY public.hr_employee_cv_wizard.id;


--
-- Name: hr_employee_hr_employee_cv_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_employee_cv_wizard_rel (
    hr_employee_cv_wizard_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_employee_cv_wizard_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_employee_cv_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_employee_cv_wizard_rel IS 'RELATION BETWEEN hr_employee_cv_wizard AND hr_employee';


--
-- Name: hr_employee_hr_skill_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_skill_rel (
    hr_employee_id integer NOT NULL,
    hr_skill_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_skill_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_skill_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_skill_rel IS 'RELATION BETWEEN hr_employee AND hr_skill';


--
-- Name: hr_employee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_id_seq OWNER TO runbot;

--
-- Name: hr_employee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_id_seq OWNED BY public.hr_employee.id;


--
-- Name: hr_employee_public; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_public AS
 SELECT name,
    active,
    color,
    department_id,
    job_id,
    job_title,
    company_id,
    address_id,
    work_phone,
    mobile_phone,
    work_email,
    work_contact_id,
    work_location_id,
    user_id,
    resource_id,
    resource_calendar_id,
    is_flexible,
    is_fully_flexible,
    parent_id,
    coach_id,
    create_date,
    id,
    create_uid,
    write_uid,
    write_date
   FROM public.hr_employee emp;


ALTER VIEW public.hr_employee_public OWNER TO runbot;

--
-- Name: hr_employee_skill; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_skill (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    skill_id integer NOT NULL,
    skill_level_id integer NOT NULL,
    skill_type_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_skill OWNER TO runbot;

--
-- Name: TABLE hr_employee_skill; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_skill IS 'Skill level for an employee';


--
-- Name: COLUMN hr_employee_skill.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.employee_id IS 'Employee';


--
-- Name: COLUMN hr_employee_skill.skill_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.skill_id IS 'Skill';


--
-- Name: COLUMN hr_employee_skill.skill_level_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.skill_level_id IS 'Skill Level';


--
-- Name: COLUMN hr_employee_skill.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_employee_skill.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_skill.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_skill.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_skill.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.write_date IS 'Last Updated on';


--
-- Name: hr_employee_skill_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_skill_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_skill_id_seq OWNER TO runbot;

--
-- Name: hr_employee_skill_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_skill_id_seq OWNED BY public.hr_employee_skill.id;


--
-- Name: hr_employee_skill_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_skill_log (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    department_id integer,
    skill_id integer NOT NULL,
    skill_level_id integer NOT NULL,
    skill_type_id integer NOT NULL,
    level_progress integer,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_skill_log OWNER TO runbot;

--
-- Name: TABLE hr_employee_skill_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_skill_log IS 'Skills History';


--
-- Name: COLUMN hr_employee_skill_log.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.employee_id IS 'Employee';


--
-- Name: COLUMN hr_employee_skill_log.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.department_id IS 'Department';


--
-- Name: COLUMN hr_employee_skill_log.skill_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.skill_id IS 'Skill';


--
-- Name: COLUMN hr_employee_skill_log.skill_level_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.skill_level_id IS 'Skill Level';


--
-- Name: COLUMN hr_employee_skill_log.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_employee_skill_log.level_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.level_progress IS 'Progress';


--
-- Name: COLUMN hr_employee_skill_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_skill_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_skill_log.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.date IS 'Date';


--
-- Name: COLUMN hr_employee_skill_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_skill_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.write_date IS 'Last Updated on';


--
-- Name: hr_employee_skill_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_skill_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_skill_log_id_seq OWNER TO runbot;

--
-- Name: hr_employee_skill_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_skill_log_id_seq OWNED BY public.hr_employee_skill_log.id;


--
-- Name: hr_skill_level; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_skill_level (
    id integer NOT NULL,
    skill_type_id integer,
    level_progress integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    default_level boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_skill_level_check_level_progress CHECK (((level_progress >= 0) AND (level_progress <= 100)))
);


ALTER TABLE public.hr_skill_level OWNER TO runbot;

--
-- Name: TABLE hr_skill_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_skill_level IS 'Skill Level';


--
-- Name: COLUMN hr_skill_level.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_skill_level.level_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.level_progress IS 'Progress';


--
-- Name: COLUMN hr_skill_level.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.create_uid IS 'Created by';


--
-- Name: COLUMN hr_skill_level.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_skill_level.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.name IS 'Name';


--
-- Name: COLUMN hr_skill_level.default_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.default_level IS 'Default Level';


--
-- Name: COLUMN hr_skill_level.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.create_date IS 'Created on';


--
-- Name: COLUMN hr_skill_level.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_skill_level_check_level_progress ON hr_skill_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_skill_level_check_level_progress ON public.hr_skill_level IS 'CHECK(level_progress BETWEEN 0 AND 100)';


--
-- Name: hr_skill_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_skill_type (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_skill_type OWNER TO runbot;

--
-- Name: TABLE hr_skill_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_skill_type IS 'Skill Type';


--
-- Name: COLUMN hr_skill_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.color IS 'Color';


--
-- Name: COLUMN hr_skill_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_skill_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_skill_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.name IS 'Name';


--
-- Name: COLUMN hr_skill_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.active IS 'Active';


--
-- Name: COLUMN hr_skill_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_skill_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.write_date IS 'Last Updated on';


--
-- Name: hr_employee_skill_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_skill_report AS
 SELECT row_number() OVER () AS id,
    e.id AS employee_id,
    e.company_id,
    e.department_id,
    s.skill_id,
    s.skill_type_id,
    ((sl.level_progress)::numeric / 100.0) AS level_progress,
    sl.name AS skill_level
   FROM (((public.hr_employee e
     LEFT JOIN public.hr_employee_skill s ON ((e.id = s.employee_id)))
     LEFT JOIN public.hr_skill_level sl ON ((sl.id = s.skill_level_id)))
     LEFT JOIN public.hr_skill_type st ON ((st.id = sl.skill_type_id)))
  WHERE (st.active IS TRUE);


ALTER VIEW public.hr_employee_skill_report OWNER TO runbot;

--
-- Name: hr_job; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_job (
    id integer NOT NULL,
    sequence integer,
    expected_employees integer,
    no_of_employee integer,
    no_of_recruitment integer,
    department_id integer,
    company_id integer,
    contract_type_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description text,
    requirements text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_job_no_of_recruitment_positive CHECK ((no_of_recruitment >= 0))
);


ALTER TABLE public.hr_job OWNER TO runbot;

--
-- Name: TABLE hr_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_job IS 'Job Position';


--
-- Name: COLUMN hr_job.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.sequence IS 'Sequence';


--
-- Name: COLUMN hr_job.expected_employees; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.expected_employees IS 'Total Forecasted Employees';


--
-- Name: COLUMN hr_job.no_of_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.no_of_employee IS 'Current Number of Employees';


--
-- Name: COLUMN hr_job.no_of_recruitment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.no_of_recruitment IS 'Target';


--
-- Name: COLUMN hr_job.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.department_id IS 'Department';


--
-- Name: COLUMN hr_job.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.company_id IS 'Company';


--
-- Name: COLUMN hr_job.contract_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.contract_type_id IS 'Employment Type';


--
-- Name: COLUMN hr_job.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.create_uid IS 'Created by';


--
-- Name: COLUMN hr_job.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_job.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.name IS 'Job Position';


--
-- Name: COLUMN hr_job.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.description IS 'Job Description';


--
-- Name: COLUMN hr_job.requirements; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.requirements IS 'Requirements';


--
-- Name: COLUMN hr_job.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.active IS 'Active';


--
-- Name: COLUMN hr_job.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.create_date IS 'Created on';


--
-- Name: COLUMN hr_job.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_job_no_of_recruitment_positive ON hr_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_job_no_of_recruitment_positive ON public.hr_job IS 'CHECK(no_of_recruitment >= 0)';


--
-- Name: hr_job_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_job_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_job_id_seq OWNER TO runbot;

--
-- Name: hr_job_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_job_id_seq OWNED BY public.hr_job.id;


--
-- Name: hr_resume_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_resume_line (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    line_type_id integer,
    create_uid integer,
    write_uid integer,
    display_type character varying,
    date_start date NOT NULL,
    date_end date,
    name jsonb NOT NULL,
    description jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_resume_line_date_check CHECK (((date_start <= date_end) OR (date_end IS NULL)))
);


ALTER TABLE public.hr_resume_line OWNER TO runbot;

--
-- Name: TABLE hr_resume_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_resume_line IS 'Resume line of an employee';


--
-- Name: COLUMN hr_resume_line.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.employee_id IS 'Employee';


--
-- Name: COLUMN hr_resume_line.line_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.line_type_id IS 'Type';


--
-- Name: COLUMN hr_resume_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.create_uid IS 'Created by';


--
-- Name: COLUMN hr_resume_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_resume_line.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.display_type IS 'Display Type';


--
-- Name: COLUMN hr_resume_line.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.date_start IS 'Date Start';


--
-- Name: COLUMN hr_resume_line.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.date_end IS 'Date End';


--
-- Name: COLUMN hr_resume_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.name IS 'Name';


--
-- Name: COLUMN hr_resume_line.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.description IS 'Description';


--
-- Name: COLUMN hr_resume_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.create_date IS 'Created on';


--
-- Name: COLUMN hr_resume_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_resume_line_date_check ON hr_resume_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_resume_line_date_check ON public.hr_resume_line IS 'CHECK ((date_start <= date_end OR date_end IS NULL))';


--
-- Name: hr_resume_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_resume_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_resume_line_id_seq OWNER TO runbot;

--
-- Name: hr_resume_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_resume_line_id_seq OWNED BY public.hr_resume_line.id;


--
-- Name: hr_resume_line_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_resume_line_type (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_resume_line_type OWNER TO runbot;

--
-- Name: TABLE hr_resume_line_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_resume_line_type IS 'Type of a resume line';


--
-- Name: COLUMN hr_resume_line_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.sequence IS 'Sequence';


--
-- Name: COLUMN hr_resume_line_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_resume_line_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_resume_line_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.name IS 'Name';


--
-- Name: COLUMN hr_resume_line_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_resume_line_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.write_date IS 'Last Updated on';


--
-- Name: hr_resume_line_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_resume_line_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_resume_line_type_id_seq OWNER TO runbot;

--
-- Name: hr_resume_line_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_resume_line_type_id_seq OWNED BY public.hr_resume_line_type.id;


--
-- Name: hr_skill; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_skill (
    id integer NOT NULL,
    sequence integer,
    skill_type_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_skill OWNER TO runbot;

--
-- Name: TABLE hr_skill; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_skill IS 'Skill';


--
-- Name: COLUMN hr_skill.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.sequence IS 'Sequence';


--
-- Name: COLUMN hr_skill.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_skill.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.create_uid IS 'Created by';


--
-- Name: COLUMN hr_skill.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_skill.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.name IS 'Name';


--
-- Name: COLUMN hr_skill.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.create_date IS 'Created on';


--
-- Name: COLUMN hr_skill.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.write_date IS 'Last Updated on';


--
-- Name: hr_skill_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_skill_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_skill_id_seq OWNER TO runbot;

--
-- Name: hr_skill_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_skill_id_seq OWNED BY public.hr_skill.id;


--
-- Name: hr_skill_level_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_skill_level_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_skill_level_id_seq OWNER TO runbot;

--
-- Name: hr_skill_level_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_skill_level_id_seq OWNED BY public.hr_skill_level.id;


--
-- Name: hr_skill_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_skill_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_skill_type_id_seq OWNER TO runbot;

--
-- Name: hr_skill_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_skill_type_id_seq OWNED BY public.hr_skill_type.id;


--
-- Name: hr_work_location; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_work_location (
    id integer NOT NULL,
    company_id integer NOT NULL,
    address_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    location_type character varying NOT NULL,
    location_number character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_work_location OWNER TO runbot;

--
-- Name: TABLE hr_work_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_work_location IS 'Work Location';


--
-- Name: COLUMN hr_work_location.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.company_id IS 'Company';


--
-- Name: COLUMN hr_work_location.address_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.address_id IS 'Work Address';


--
-- Name: COLUMN hr_work_location.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.create_uid IS 'Created by';


--
-- Name: COLUMN hr_work_location.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_work_location.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.name IS 'Work Location';


--
-- Name: COLUMN hr_work_location.location_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.location_type IS 'Cover Image';


--
-- Name: COLUMN hr_work_location.location_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.location_number IS 'Location Number';


--
-- Name: COLUMN hr_work_location.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.active IS 'Active';


--
-- Name: COLUMN hr_work_location.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.create_date IS 'Created on';


--
-- Name: COLUMN hr_work_location.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.write_date IS 'Last Updated on';


--
-- Name: hr_work_location_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_work_location_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_work_location_id_seq OWNER TO runbot;

--
-- Name: hr_work_location_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_work_location_id_seq OWNED BY public.hr_work_location.id;


--
-- Name: iap_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account (
    id integer NOT NULL,
    service_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    account_token character varying(43),
    balance character varying,
    state character varying,
    service_locked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    warning_threshold double precision,
    sender_name character varying
);


ALTER TABLE public.iap_account OWNER TO runbot;

--
-- Name: TABLE iap_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account IS 'IAP Account';


--
-- Name: COLUMN iap_account.service_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_id IS 'Service';


--
-- Name: COLUMN iap_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.name IS 'Name';


--
-- Name: COLUMN iap_account.account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.balance IS 'Balance';


--
-- Name: COLUMN iap_account.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.state IS 'State';


--
-- Name: COLUMN iap_account.service_locked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_locked IS 'Service Locked';


--
-- Name: COLUMN iap_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_date IS 'Created on';


--
-- Name: COLUMN iap_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN iap_account.warning_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.warning_threshold IS 'Email Alert Threshold';


--
-- Name: COLUMN iap_account.sender_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.sender_name IS 'Sender Name';


--
-- Name: iap_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_account_id_seq OWNER TO runbot;

--
-- Name: iap_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_account_id_seq OWNED BY public.iap_account.id;


--
-- Name: iap_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_company_rel (
    iap_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_company_rel IS 'RELATION BETWEEN iap_account AND res_company';


--
-- Name: iap_account_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_users_rel (
    iap_account_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_users_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_users_rel IS 'RELATION BETWEEN iap_account AND res_users';


--
-- Name: iap_service; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_service (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    technical_name character varying NOT NULL,
    description jsonb NOT NULL,
    unit_name jsonb NOT NULL,
    integer_balance boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.iap_service OWNER TO runbot;

--
-- Name: TABLE iap_service; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_service IS 'IAP Service';


--
-- Name: COLUMN iap_service.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_uid IS 'Created by';


--
-- Name: COLUMN iap_service.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_service.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.name IS 'Name';


--
-- Name: COLUMN iap_service.technical_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.technical_name IS 'Technical Name';


--
-- Name: COLUMN iap_service.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.description IS 'Description';


--
-- Name: COLUMN iap_service.unit_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.unit_name IS 'Unit Name';


--
-- Name: COLUMN iap_service.integer_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.integer_balance IS 'Integer Balance';


--
-- Name: COLUMN iap_service.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_date IS 'Created on';


--
-- Name: COLUMN iap_service.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_date IS 'Last Updated on';


--
-- Name: iap_service_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_service_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_service_id_seq OWNER TO runbot;

--
-- Name: iap_service_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_service_id_seq OWNED BY public.iap_service.id;


--
-- Name: im_livechat_channel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.im_livechat_channel (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    header_background_color character varying,
    title_color character varying,
    button_background_color character varying,
    button_text_color character varying,
    button_text jsonb,
    default_message jsonb,
    input_placeholder jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    partner_assistant_id integer,
    responsible_user integer,
    is_only_hint_available boolean,
    website_description jsonb,
    is_published boolean
);


ALTER TABLE public.im_livechat_channel OWNER TO runbot;

--
-- Name: TABLE im_livechat_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.im_livechat_channel IS 'Livechat Channel';


--
-- Name: COLUMN im_livechat_channel.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.create_uid IS 'Created by';


--
-- Name: COLUMN im_livechat_channel.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN im_livechat_channel.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.name IS 'Channel Name';


--
-- Name: COLUMN im_livechat_channel.header_background_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.header_background_color IS 'Header Background Color';


--
-- Name: COLUMN im_livechat_channel.title_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.title_color IS 'Title Color';


--
-- Name: COLUMN im_livechat_channel.button_background_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.button_background_color IS 'Button Background Color';


--
-- Name: COLUMN im_livechat_channel.button_text_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.button_text_color IS 'Button Text Color';


--
-- Name: COLUMN im_livechat_channel.button_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.button_text IS 'Text of the Button';


--
-- Name: COLUMN im_livechat_channel.default_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.default_message IS 'Welcome Message';


--
-- Name: COLUMN im_livechat_channel.input_placeholder; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.input_placeholder IS 'Chat Input Placeholder';


--
-- Name: COLUMN im_livechat_channel.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.create_date IS 'Created on';


--
-- Name: COLUMN im_livechat_channel.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.write_date IS 'Last Updated on';


--
-- Name: COLUMN im_livechat_channel.partner_assistant_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.partner_assistant_id IS 'Assistant';


--
-- Name: COLUMN im_livechat_channel.responsible_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.responsible_user IS 'Responsible operator';


--
-- Name: COLUMN im_livechat_channel.is_only_hint_available; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.is_only_hint_available IS 'Use only assistant hint';


--
-- Name: COLUMN im_livechat_channel.website_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.website_description IS 'Website description';


--
-- Name: COLUMN im_livechat_channel.is_published; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel.is_published IS 'Is Published';


--
-- Name: im_livechat_channel_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.im_livechat_channel_country_rel (
    channel_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.im_livechat_channel_country_rel OWNER TO runbot;

--
-- Name: TABLE im_livechat_channel_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.im_livechat_channel_country_rel IS 'RELATION BETWEEN im_livechat_channel_rule AND res_country';


--
-- Name: im_livechat_channel_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.im_livechat_channel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.im_livechat_channel_id_seq OWNER TO runbot;

--
-- Name: im_livechat_channel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.im_livechat_channel_id_seq OWNED BY public.im_livechat_channel.id;


--
-- Name: im_livechat_channel_im_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.im_livechat_channel_im_user (
    channel_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.im_livechat_channel_im_user OWNER TO runbot;

--
-- Name: TABLE im_livechat_channel_im_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.im_livechat_channel_im_user IS 'RELATION BETWEEN im_livechat_channel AND res_users';


--
-- Name: im_livechat_channel_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.im_livechat_channel_rule (
    id integer NOT NULL,
    auto_popup_timer integer,
    chatbot_script_id integer,
    channel_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    regex_url character varying,
    action character varying NOT NULL,
    chatbot_only_if_no_operator boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.im_livechat_channel_rule OWNER TO runbot;

--
-- Name: TABLE im_livechat_channel_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.im_livechat_channel_rule IS 'Livechat Channel Rules';


--
-- Name: COLUMN im_livechat_channel_rule.auto_popup_timer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel_rule.auto_popup_timer IS 'Open automatically timer';


--
-- Name: COLUMN im_livechat_channel_rule.chatbot_script_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel_rule.chatbot_script_id IS 'Chatbot';


--
-- Name: COLUMN im_livechat_channel_rule.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel_rule.channel_id IS 'Channel';


--
-- Name: COLUMN im_livechat_channel_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel_rule.sequence IS 'Matching order';


--
-- Name: COLUMN im_livechat_channel_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel_rule.create_uid IS 'Created by';


--
-- Name: COLUMN im_livechat_channel_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN im_livechat_channel_rule.regex_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel_rule.regex_url IS 'URL Regex';


--
-- Name: COLUMN im_livechat_channel_rule.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel_rule.action IS 'Live Chat Button';


--
-- Name: COLUMN im_livechat_channel_rule.chatbot_only_if_no_operator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel_rule.chatbot_only_if_no_operator IS 'Enabled only if no operator';


--
-- Name: COLUMN im_livechat_channel_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel_rule.create_date IS 'Created on';


--
-- Name: COLUMN im_livechat_channel_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.im_livechat_channel_rule.write_date IS 'Last Updated on';


--
-- Name: im_livechat_channel_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.im_livechat_channel_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.im_livechat_channel_rule_id_seq OWNER TO runbot;

--
-- Name: im_livechat_channel_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.im_livechat_channel_rule_id_seq OWNED BY public.im_livechat_channel_rule.id;


--
-- Name: im_livechat_report_channel; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.im_livechat_report_channel AS
SELECT
    NULL::integer AS id,
    NULL::character varying(50) AS uuid,
    NULL::integer AS channel_id,
    NULL::character varying AS channel_name,
    NULL::text AS technical_name,
    NULL::integer AS livechat_channel_id,
    NULL::timestamp without time zone AS start_date,
    NULL::text AS start_date_hour,
    NULL::text AS start_hour,
    NULL::numeric AS day_number,
    NULL::numeric AS duration,
    NULL::numeric AS time_to_answer,
    NULL::bigint AS nbr_speaker,
    NULL::bigint AS nbr_message,
    NULL::integer AS is_without_answer,
    NULL::double precision AS days_of_activity,
    NULL::integer AS is_anonymous,
    NULL::integer AS country_id,
    NULL::integer AS is_happy,
    NULL::double precision AS rating,
    NULL::text AS rating_text,
    NULL::integer AS is_unrated,
    NULL::integer AS partner_id;


ALTER VIEW public.im_livechat_report_channel OWNER TO runbot;

--
-- Name: im_livechat_report_operator; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.im_livechat_report_operator AS
SELECT
    NULL::bigint AS id,
    NULL::integer AS partner_id,
    NULL::integer AS livechat_channel_id,
    NULL::bigint AS nbr_channel,
    NULL::integer AS channel_id,
    NULL::timestamp without time zone AS start_date,
    NULL::double precision AS rating,
    NULL::numeric AS duration,
    NULL::numeric AS time_to_answer;


ALTER VIEW public.im_livechat_report_operator OWNER TO runbot;

--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    binding_model_id integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    path character varying,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    name jsonb NOT NULL,
    help jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.path IS 'Path to show in the URL';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Action Name';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    paperformat_id integer,
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    attachment character varying,
    domain character varying,
    print_report_name jsonb,
    multi boolean,
    attachment_use boolean,
    is_invoice_report boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.domain IS 'Filter domain';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: COLUMN ir_act_report_xml.is_invoice_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.is_invoice_report IS 'Invoice report';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    sequence integer,
    model_id integer NOT NULL,
    crud_model_id integer,
    link_field_id integer,
    update_field_id integer,
    update_related_model_id integer,
    selection_value integer,
    usage character varying NOT NULL,
    state character varying NOT NULL,
    model_name character varying,
    update_path character varying,
    update_m2m_operation character varying,
    update_boolean_value character varying,
    evaluation_type character varying,
    resource_ref character varying,
    webhook_url character varying,
    code text,
    value text,
    template_id integer,
    activity_type_id integer,
    activity_date_deadline_range integer,
    activity_user_id integer,
    mail_post_method character varying,
    activity_summary character varying,
    activity_date_deadline_range_type character varying,
    activity_user_type character varying,
    activity_user_field_name character varying,
    activity_note text,
    mail_post_autofollow boolean,
    sms_template_id integer,
    sms_method character varying,
    base_automation_id integer,
    website_path character varying,
    website_published boolean,
    messenger_task_id integer
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Record to Create';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.update_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_field_id IS 'Field to Update';


--
-- Name: COLUMN ir_act_server.update_related_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_related_model_id IS 'Update Related Model';


--
-- Name: COLUMN ir_act_server.selection_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.selection_value IS 'Custom Value';


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Type';


--
-- Name: COLUMN ir_act_server.model_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_name IS 'Model Name';


--
-- Name: COLUMN ir_act_server.update_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_path IS 'Field to Update Path';


--
-- Name: COLUMN ir_act_server.update_m2m_operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_m2m_operation IS 'Many2many Operations';


--
-- Name: COLUMN ir_act_server.update_boolean_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_boolean_value IS 'Boolean Value';


--
-- Name: COLUMN ir_act_server.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.evaluation_type IS 'Value Type';


--
-- Name: COLUMN ir_act_server.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.resource_ref IS 'Record';


--
-- Name: COLUMN ir_act_server.webhook_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.webhook_url IS 'Webhook URL';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.value IS 'Value';


--
-- Name: COLUMN ir_act_server.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.template_id IS 'Email Template';


--
-- Name: COLUMN ir_act_server.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN ir_act_server.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_id IS 'Responsible';


--
-- Name: COLUMN ir_act_server.mail_post_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_method IS 'Send Email As';


--
-- Name: COLUMN ir_act_server.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_summary IS 'Title';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN ir_act_server.activity_user_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_type IS 'User Type';


--
-- Name: COLUMN ir_act_server.activity_user_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_field_name IS 'User Field';


--
-- Name: COLUMN ir_act_server.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_note IS 'Note';


--
-- Name: COLUMN ir_act_server.mail_post_autofollow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_autofollow IS 'Subscribe Recipients';


--
-- Name: COLUMN ir_act_server.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN ir_act_server.sms_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_method IS 'Send SMS As';


--
-- Name: COLUMN ir_act_server.base_automation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.base_automation_id IS 'Automation Rule';


--
-- Name: COLUMN ir_act_server.website_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.website_path IS 'Website Path';


--
-- Name: COLUMN ir_act_server.website_published; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.website_published IS 'Available on the Website';


--
-- Name: COLUMN ir_act_server.messenger_task_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.messenger_task_id IS 'Messenger Task';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_server_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_res_partner_rel (
    ir_act_server_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_res_partner_rel IS 'RELATION BETWEEN ir_act_server AND res_partner';


--
-- Name: ir_act_server_webhook_field_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_webhook_field_rel (
    server_id integer NOT NULL,
    field_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_webhook_field_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_webhook_field_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_webhook_field_rel IS 'RELATION BETWEEN ir_act_server AND ir_model_fields';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    res_id integer,
    "limit" integer,
    search_view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    mobile_view_mode character varying,
    usage character varying,
    filter boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.mobile_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.mobile_view_mode IS 'Mobile View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    act_window_id integer,
    create_uid integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    multi boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    website_id integer,
    theme_template_id integer,
    key character varying
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_asset.website_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.website_id IS 'Website';


--
-- Name: COLUMN ir_asset.theme_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.theme_template_id IS 'Theme Template';


--
-- Name: COLUMN ir_asset.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.key IS 'Key';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    res_id integer,
    company_id integer,
    file_size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    res_field character varying,
    type character varying NOT NULL,
    url character varying(1024),
    access_token character varying,
    store_fname character varying,
    checksum character varying(40),
    mimetype character varying,
    description text,
    index_content text,
    public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    db_datas bytea,
    original_id integer,
    website_id integer,
    theme_template_id integer,
    key character varying,
    remote_attachment_url character varying
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: COLUMN ir_attachment.website_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.website_id IS 'Website';


--
-- Name: COLUMN ir_attachment.theme_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.theme_template_id IS 'Theme Template';


--
-- Name: COLUMN ir_attachment.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.key IS 'Key';


--
-- Name: COLUMN ir_attachment.remote_attachment_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.remote_attachment_url IS 'Remote Attachment URL';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_attachment_vector_store_file_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment_vector_store_file_rel (
    vector_store_file_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.ir_attachment_vector_store_file_rel OWNER TO runbot;

--
-- Name: TABLE ir_attachment_vector_store_file_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment_vector_store_file_rel IS 'RELATION BETWEEN vector_store_file AND ir_attachment';


--
-- Name: ir_attachment_vector_store_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment_vector_store_rel (
    vector_store_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.ir_attachment_vector_store_rel OWNER TO runbot;

--
-- Name: TABLE ir_attachment_vector_store_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment_vector_store_rel IS 'RELATION BETWEEN vector_store AND ir_attachment';


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    user_id integer NOT NULL,
    interval_number integer NOT NULL,
    priority integer,
    failure_count integer,
    create_uid integer,
    write_uid integer,
    cron_name character varying,
    interval_type character varying NOT NULL,
    active boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    first_failure_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_cron_check_strictly_positive_interval CHECK ((interval_number > 0))
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.failure_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.failure_count IS 'Failure Count';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.first_failure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.first_failure_date IS 'First Failure Date';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_cron_check_strictly_positive_interval ON ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_cron_check_strictly_positive_interval ON public.ir_cron IS 'CHECK(interval_number > 0)';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_progress; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_progress (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    remaining integer,
    done integer,
    timed_out_counter integer,
    create_uid integer,
    write_uid integer,
    deactivate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_progress OWNER TO runbot;

--
-- Name: TABLE ir_cron_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_progress IS 'Progress of Scheduled Actions';


--
-- Name: COLUMN ir_cron_progress.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_progress.remaining; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.remaining IS 'Remaining';


--
-- Name: COLUMN ir_cron_progress.done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.done IS 'Done';


--
-- Name: COLUMN ir_cron_progress.timed_out_counter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.timed_out_counter IS 'Timed Out Counter';


--
-- Name: COLUMN ir_cron_progress.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_progress.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_progress.deactivate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.deactivate IS 'Deactivate';


--
-- Name: COLUMN ir_cron_progress.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_progress.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_date IS 'Last Updated on';


--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_progress_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_progress_id_seq OWNER TO runbot;

--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_progress_id_seq OWNED BY public.ir_cron_progress.id;


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer,
    create_uid integer,
    write_uid integer,
    call_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    condition character varying,
    "json_value" character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default."json_value"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default."json_value" IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    error character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_embedded_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions (
    id integer NOT NULL,
    sequence integer,
    parent_action_id integer NOT NULL,
    parent_res_id integer,
    action_id integer,
    user_id integer,
    create_uid integer,
    write_uid integer,
    parent_res_model character varying NOT NULL,
    python_method character varying,
    default_view_mode character varying,
    domain character varying,
    context character varying,
    name jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_embedded_actions_check_only_one_action_defined CHECK ((((action_id IS NOT NULL) AND (python_method IS NULL)) OR ((action_id IS NULL) AND (python_method IS NOT NULL)))),
    CONSTRAINT ir_embedded_actions_check_python_method_requires_name CHECK ((NOT ((python_method IS NOT NULL) AND (name IS NULL))))
);


ALTER TABLE public.ir_embedded_actions OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions IS 'Embedded Actions';


--
-- Name: COLUMN ir_embedded_actions.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.sequence IS 'Sequence';


--
-- Name: COLUMN ir_embedded_actions.parent_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_action_id IS 'Parent Action';


--
-- Name: COLUMN ir_embedded_actions.parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_id IS 'Active Parent Id';


--
-- Name: COLUMN ir_embedded_actions.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.action_id IS 'Action';


--
-- Name: COLUMN ir_embedded_actions.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.user_id IS 'User';


--
-- Name: COLUMN ir_embedded_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_embedded_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_embedded_actions.parent_res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_model IS 'Active Parent Model';


--
-- Name: COLUMN ir_embedded_actions.python_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.python_method IS 'Python Method';


--
-- Name: COLUMN ir_embedded_actions.default_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.default_view_mode IS 'Default View';


--
-- Name: COLUMN ir_embedded_actions.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.domain IS 'Domain';


--
-- Name: COLUMN ir_embedded_actions.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.context IS 'Context';


--
-- Name: COLUMN ir_embedded_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.name IS 'Name';


--
-- Name: COLUMN ir_embedded_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_embedded_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON public.ir_embedded_actions IS 'CHECK(
                (action_id IS NOT NULL AND python_method IS NULL) OR
                (action_id IS NULL AND python_method IS NOT NULL)
            )';


--
-- Name: CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON public.ir_embedded_actions IS 'CHECK(
                NOT (python_method IS NOT NULL AND name IS NULL)
            )';


--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_embedded_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNER TO runbot;

--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNED BY public.ir_embedded_actions.id;


--
-- Name: ir_embedded_actions_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions_res_groups_rel (
    ir_embedded_actions_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.ir_embedded_actions_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions_res_groups_rel IS 'RELATION BETWEEN ir_embedded_actions AND res_groups';


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    resource character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    export_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    user_id integer,
    action_id integer,
    embedded_action_id integer,
    embedded_parent_res_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    sort character varying NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    context text NOT NULL,
    is_default boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_filters_check_res_id_only_when_embedded_action CHECK ((NOT ((embedded_parent_res_id IS NOT NULL) AND (embedded_action_id IS NULL)))),
    CONSTRAINT ir_filters_check_sort_json CHECK (((sort IS NULL) OR (jsonb_typeof((sort)::jsonb) = 'array'::text)))
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.user_id IS 'User';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.embedded_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_action_id IS 'Embedded Action';


--
-- Name: COLUMN ir_filters.embedded_parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_parent_res_id IS 'Embedded Parent Res';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON public.ir_filters IS 'CHECK(
                NOT (embedded_parent_res_id IS NOT NULL AND embedded_action_id IS NULL)
            )';


--
-- Name: CONSTRAINT ir_filters_check_sort_json ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_sort_json ON public.ir_filters IS 'CHECK(sort IS NULL OR jsonb_typeof(sort::jsonb) = ''array'')';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL,
    message text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    messenger_job_id integer
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_logging.messenger_job_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.messenger_job_id IS 'Messenger Job';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    smtp_port integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_email_size double precision,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea,
    google_gmail_access_token_expiration integer,
    google_gmail_authorization_code character varying,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying,
    CONSTRAINT ir_mail_server_certificate_requires_tls CHECK ((((smtp_encryption)::text <> 'none'::text) OR ((smtp_authentication)::text <> 'certificate'::text)))
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Name';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'FROM Filtering';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Encryption';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.max_email_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.max_email_size IS 'Max Email Size';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN ir_mail_server.google_gmail_authorization_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_authorization_code IS 'Authorization Code';


--
-- Name: COLUMN ir_mail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: CONSTRAINT ir_mail_server_certificate_requires_tls ON ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_mail_server_certificate_requires_tls ON public.ir_mail_server IS 'CHECK(smtp_encryption != ''none'' OR smtp_authentication != ''certificate'')';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    state character varying,
    name jsonb NOT NULL,
    info text,
    transient boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    is_mail_thread boolean,
    is_mail_activity boolean,
    is_mail_blacklist boolean,
    website_form_default_field_id integer,
    website_form_label character varying,
    website_form_key character varying,
    website_form_access boolean
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model.is_mail_thread; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_thread IS 'Has Mail Thread';


--
-- Name: COLUMN ir_model.is_mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_activity IS 'Has Mail Activity';


--
-- Name: COLUMN ir_model.is_mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_blacklist IS 'Has Mail Blacklist';


--
-- Name: COLUMN ir_model.website_form_default_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.website_form_default_field_id IS 'Field for custom form data';


--
-- Name: COLUMN ir_model.website_form_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.website_form_label IS 'Label for form action';


--
-- Name: COLUMN ir_model.website_form_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.website_form_key IS 'Website Form Key';


--
-- Name: COLUMN ir_model.website_form_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.website_form_access IS 'Allowed to use in forms';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    definition character varying,
    type character varying(1) NOT NULL,
    message jsonb,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Create Date';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    res_id integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '% %'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''% %'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    relation_field_id integer,
    model_id integer NOT NULL,
    related_field_id integer,
    size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    ttype character varying NOT NULL,
    related character varying,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    depends character varying,
    currency_field character varying,
    field_description jsonb NOT NULL,
    help jsonb,
    compute text,
    copied boolean,
    required boolean,
    readonly boolean,
    index boolean,
    translate boolean,
    company_dependent boolean,
    group_expand boolean,
    selectable boolean,
    store boolean,
    sanitize boolean,
    sanitize_overridable boolean,
    sanitize_tags boolean,
    sanitize_attributes boolean,
    sanitize_style boolean,
    sanitize_form boolean,
    strip_style boolean,
    strip_classes boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    serialization_field_id integer,
    tracking integer,
    website_form_blacklisted boolean DEFAULT true,
    CONSTRAINT ir_model_fields_name_manual_field CHECK ((((state)::text <> 'manual'::text) OR ((name)::text ~~ 'x\_%'::text))),
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.complete_name IS 'Complete Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field Definition';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.currency_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.currency_field IS 'Currency field';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.company_dependent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.company_dependent IS 'Company Dependent';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.sanitize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize IS 'Sanitize HTML';


--
-- Name: COLUMN ir_model_fields.sanitize_overridable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_overridable IS 'Sanitize HTML overridable';


--
-- Name: COLUMN ir_model_fields.sanitize_tags; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_tags IS 'Sanitize HTML Tags';


--
-- Name: COLUMN ir_model_fields.sanitize_attributes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_attributes IS 'Sanitize HTML Attributes';


--
-- Name: COLUMN ir_model_fields.sanitize_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_style IS 'Sanitize HTML Style';


--
-- Name: COLUMN ir_model_fields.sanitize_form; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_form IS 'Sanitize HTML Form';


--
-- Name: COLUMN ir_model_fields.strip_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_style IS 'Strip Style Attribute';


--
-- Name: COLUMN ir_model_fields.strip_classes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_classes IS 'Strip Class Attribute';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model_fields.serialization_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.serialization_field_id IS 'Serialization Field';


--
-- Name: COLUMN ir_model_fields.tracking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.tracking IS 'Enable Ordered Tracking';


--
-- Name: COLUMN ir_model_fields.website_form_blacklisted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.website_form_blacklisted IS 'Blacklisted in web forms';


--
-- Name: CONSTRAINT ir_model_fields_name_manual_field ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_name_manual_field ON public.ir_model_fields IS 'CHECK (state != ''manual'' OR name LIKE ''x\_%'')';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_inherit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_inherit (
    id integer NOT NULL,
    model_id integer NOT NULL,
    parent_id integer NOT NULL,
    parent_field_id integer
);


ALTER TABLE public.ir_model_inherit OWNER TO runbot;

--
-- Name: TABLE ir_model_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_inherit IS 'Model Inheritance Tree';


--
-- Name: COLUMN ir_model_inherit.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.model_id IS 'Model';


--
-- Name: COLUMN ir_model_inherit.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_id IS 'Parent';


--
-- Name: COLUMN ir_model_inherit.parent_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_field_id IS 'Parent Field';


--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_inherit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_inherit_id_seq OWNER TO runbot;

--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_inherit_id_seq OWNED BY public.ir_model_inherit.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_relation OWNER TO runbot;

--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_relation_id_seq OWNER TO runbot;

--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_model_spreadsheet_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_spreadsheet_dashboard_rel (
    spreadsheet_dashboard_id integer NOT NULL,
    ir_model_id integer NOT NULL
);


ALTER TABLE public.ir_model_spreadsheet_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_spreadsheet_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_spreadsheet_dashboard_rel IS 'RELATION BETWEEN spreadsheet_dashboard AND ir_model';


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name jsonb NOT NULL,
    sequence integer,
    description jsonb,
    visible boolean,
    exclusive boolean
);


ALTER TABLE public.ir_module_category OWNER TO runbot;

--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_category_id_seq OWNER TO runbot;

--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary jsonb,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc jsonb,
    category_id integer,
    description jsonb,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    published_version character varying,
    url character varying,
    contributors text,
    menus_by_module text,
    reports_by_module text,
    views_by_module text,
    module_type character varying,
    imported boolean
);


ALTER TABLE public.ir_module_module OWNER TO runbot;

--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: COLUMN ir_module_module.module_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.module_type IS 'Module Type';


--
-- Name: COLUMN ir_module_module.imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.imported IS 'Imported Module';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


ALTER TABLE public.ir_module_module_dependency OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    module_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_module_module_exclusion OWNER TO runbot;

--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_module_module_us_ai_translation_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_us_ai_translation_rel (
    us_ai_translation_id integer NOT NULL,
    ir_module_module_id integer NOT NULL
);


ALTER TABLE public.ir_module_module_us_ai_translation_rel OWNER TO runbot;

--
-- Name: TABLE ir_module_module_us_ai_translation_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_us_ai_translation_rel IS 'RELATION BETWEEN us_ai_translation AND ir_module_module';


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    sql_count integer,
    entry_count integer,
    session character varying,
    name character varying,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    qweb text,
    create_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.ir_profile OWNER TO runbot;

--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.sql_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql_count IS 'Queries Count';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_profile_id_seq OWNER TO runbot;

--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    domain_force text,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    global boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


ALTER TABLE public.ir_rule OWNER TO runbot;

--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Delete';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_rule_id_seq OWNER TO runbot;

--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    prefix character varying,
    suffix character varying,
    active boolean,
    use_date_range boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence OWNER TO runbot;

--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_002; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_002
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_002 OWNER TO runbot;

--
-- Name: ir_sequence_004; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_004
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_004 OWNER TO runbot;

--
-- Name: ir_sequence_005; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_005
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_005 OWNER TO runbot;

--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence_date_range OWNER TO runbot;

--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    sequence integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_menu OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_ui_menu_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_menu_id_seq OWNER TO runbot;

--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    priority integer NOT NULL,
    inherit_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    type character varying,
    arch_fs character varying,
    mode character varying NOT NULL,
    arch_db jsonb,
    arch_prev text,
    arch_updated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    customize_show boolean,
    website_id integer,
    theme_template_id integer,
    website_meta_og_img character varying,
    visibility character varying,
    visibility_password character varying,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    track boolean,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


ALTER TABLE public.ir_ui_view OWNER TO runbot;

--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_ui_view.customize_show; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.customize_show IS 'Show As Optional Inherit';


--
-- Name: COLUMN ir_ui_view.website_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.website_id IS 'Website';


--
-- Name: COLUMN ir_ui_view.theme_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.theme_template_id IS 'Theme Template';


--
-- Name: COLUMN ir_ui_view.website_meta_og_img; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN ir_ui_view.visibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.visibility IS 'Visibility';


--
-- Name: COLUMN ir_ui_view.visibility_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.visibility_password IS 'Visibility Password';


--
-- Name: COLUMN ir_ui_view.website_meta_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN ir_ui_view.website_meta_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN ir_ui_view.website_meta_keywords; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN ir_ui_view.seo_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.seo_name IS 'Seo name';


--
-- Name: COLUMN ir_ui_view.track; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.track IS 'Track';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    arch text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_view_custom OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: journal_account_control_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.journal_account_control_rel (
    journal_id integer NOT NULL,
    account_id integer NOT NULL
);


ALTER TABLE public.journal_account_control_rel OWNER TO runbot;

--
-- Name: TABLE journal_account_control_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.journal_account_control_rel IS 'RELATION BETWEEN account_journal AND account_account';


--
-- Name: link_tracker; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.link_tracker (
    id integer NOT NULL,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    count integer,
    create_uid integer,
    write_uid integer,
    url character varying NOT NULL,
    title character varying,
    label character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    mass_mailing_id integer
);


ALTER TABLE public.link_tracker OWNER TO runbot;

--
-- Name: TABLE link_tracker; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.link_tracker IS 'Link Tracker';


--
-- Name: COLUMN link_tracker.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker.campaign_id IS 'Campaign';


--
-- Name: COLUMN link_tracker.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker.source_id IS 'Source';


--
-- Name: COLUMN link_tracker.medium_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker.medium_id IS 'Medium';


--
-- Name: COLUMN link_tracker.count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker.count IS 'Number of Clicks';


--
-- Name: COLUMN link_tracker.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker.create_uid IS 'Created by';


--
-- Name: COLUMN link_tracker.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker.write_uid IS 'Last Updated by';


--
-- Name: COLUMN link_tracker.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker.url IS 'Target URL';


--
-- Name: COLUMN link_tracker.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker.title IS 'Page Title';


--
-- Name: COLUMN link_tracker.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker.label IS 'Button label';


--
-- Name: COLUMN link_tracker.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker.create_date IS 'Created on';


--
-- Name: COLUMN link_tracker.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker.write_date IS 'Last Updated on';


--
-- Name: COLUMN link_tracker.mass_mailing_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker.mass_mailing_id IS 'Mass Mailing';


--
-- Name: link_tracker_click; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.link_tracker_click (
    id integer NOT NULL,
    campaign_id integer,
    link_id integer NOT NULL,
    country_id integer,
    create_uid integer,
    write_uid integer,
    ip character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    mailing_trace_id integer,
    mass_mailing_id integer
);


ALTER TABLE public.link_tracker_click OWNER TO runbot;

--
-- Name: TABLE link_tracker_click; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.link_tracker_click IS 'Link Tracker Click';


--
-- Name: COLUMN link_tracker_click.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_click.campaign_id IS 'UTM Campaign';


--
-- Name: COLUMN link_tracker_click.link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_click.link_id IS 'Link';


--
-- Name: COLUMN link_tracker_click.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_click.country_id IS 'Country';


--
-- Name: COLUMN link_tracker_click.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_click.create_uid IS 'Created by';


--
-- Name: COLUMN link_tracker_click.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_click.write_uid IS 'Last Updated by';


--
-- Name: COLUMN link_tracker_click.ip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_click.ip IS 'Internet Protocol';


--
-- Name: COLUMN link_tracker_click.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_click.create_date IS 'Created on';


--
-- Name: COLUMN link_tracker_click.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_click.write_date IS 'Last Updated on';


--
-- Name: COLUMN link_tracker_click.mailing_trace_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_click.mailing_trace_id IS 'Mail Statistics';


--
-- Name: COLUMN link_tracker_click.mass_mailing_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_click.mass_mailing_id IS 'Mass Mailing';


--
-- Name: link_tracker_click_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.link_tracker_click_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.link_tracker_click_id_seq OWNER TO runbot;

--
-- Name: link_tracker_click_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.link_tracker_click_id_seq OWNED BY public.link_tracker_click.id;


--
-- Name: link_tracker_code; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.link_tracker_code (
    id integer NOT NULL,
    link_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.link_tracker_code OWNER TO runbot;

--
-- Name: TABLE link_tracker_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.link_tracker_code IS 'Link Tracker Code';


--
-- Name: COLUMN link_tracker_code.link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_code.link_id IS 'Link';


--
-- Name: COLUMN link_tracker_code.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_code.create_uid IS 'Created by';


--
-- Name: COLUMN link_tracker_code.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_code.write_uid IS 'Last Updated by';


--
-- Name: COLUMN link_tracker_code.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_code.code IS 'Short URL Code';


--
-- Name: COLUMN link_tracker_code.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_code.create_date IS 'Created on';


--
-- Name: COLUMN link_tracker_code.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.link_tracker_code.write_date IS 'Last Updated on';


--
-- Name: link_tracker_code_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.link_tracker_code_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.link_tracker_code_id_seq OWNER TO runbot;

--
-- Name: link_tracker_code_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.link_tracker_code_id_seq OWNED BY public.link_tracker_code.id;


--
-- Name: link_tracker_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.link_tracker_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.link_tracker_id_seq OWNER TO runbot;

--
-- Name: link_tracker_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.link_tracker_id_seq OWNED BY public.link_tracker.id;


--
-- Name: mail_activity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity (
    id integer NOT NULL,
    res_model_id integer NOT NULL,
    res_id integer,
    activity_type_id integer,
    user_id integer NOT NULL,
    request_partner_id integer,
    recommended_activity_type_id integer,
    previous_activity_type_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    res_name character varying,
    summary character varying,
    user_tz character varying,
    date_deadline date NOT NULL,
    date_done date,
    note text,
    automated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    calendar_event_id integer,
    CONSTRAINT mail_activity_check_res_id_is_set CHECK (((res_id IS NOT NULL) AND (res_id <> 0)))
);


ALTER TABLE public.mail_activity OWNER TO runbot;

--
-- Name: TABLE mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity IS 'Activity';


--
-- Name: COLUMN mail_activity.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model_id IS 'Document Model';


--
-- Name: COLUMN mail_activity.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_activity.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity.request_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.request_partner_id IS 'Requesting Partner';


--
-- Name: COLUMN mail_activity.recommended_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.recommended_activity_type_id IS 'Recommended Activity Type';


--
-- Name: COLUMN mail_activity.previous_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.previous_activity_type_id IS 'Previous Activity Type';


--
-- Name: COLUMN mail_activity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_activity.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_name IS 'Document Name';


--
-- Name: COLUMN mail_activity.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.summary IS 'Summary';


--
-- Name: COLUMN mail_activity.user_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_tz IS 'Timezone';


--
-- Name: COLUMN mail_activity.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity.date_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_done IS 'Done Date';


--
-- Name: COLUMN mail_activity.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.note IS 'Note';


--
-- Name: COLUMN mail_activity.automated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.automated IS 'Automated activity';


--
-- Name: COLUMN mail_activity.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.active IS 'Active';


--
-- Name: COLUMN mail_activity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_activity.calendar_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.calendar_event_id IS 'Calendar Meeting';


--
-- Name: CONSTRAINT mail_activity_check_res_id_is_set ON mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_activity_check_res_id_is_set ON public.mail_activity IS 'CHECK(res_id IS NOT NULL AND res_id !=0 )';


--
-- Name: mail_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_id_seq OWNER TO runbot;

--
-- Name: mail_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_id_seq OWNED BY public.mail_activity.id;


--
-- Name: mail_activity_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan (
    id integer NOT NULL,
    company_id integer,
    res_model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    department_id integer
);


ALTER TABLE public.mail_activity_plan OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan IS 'Activity Plan';


--
-- Name: COLUMN mail_activity_plan.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.company_id IS 'Company';


--
-- Name: COLUMN mail_activity_plan.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.res_model_id IS 'Applies to';


--
-- Name: COLUMN mail_activity_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.name IS 'Name';


--
-- Name: COLUMN mail_activity_plan.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_plan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.active IS 'Active';


--
-- Name: COLUMN mail_activity_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_activity_plan.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.department_id IS 'Department';


--
-- Name: mail_activity_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_plan_id_seq OWNER TO runbot;

--
-- Name: mail_activity_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_plan_id_seq OWNED BY public.mail_activity_plan.id;


--
-- Name: mail_activity_plan_mail_activity_schedule_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_mail_activity_schedule_rel (
    mail_activity_schedule_id integer NOT NULL,
    mail_activity_plan_id integer NOT NULL
);


ALTER TABLE public.mail_activity_plan_mail_activity_schedule_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_mail_activity_schedule_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_mail_activity_schedule_rel IS 'RELATION BETWEEN mail_activity_schedule AND mail_activity_plan';


--
-- Name: mail_activity_plan_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_template (
    id integer NOT NULL,
    plan_id integer NOT NULL,
    sequence integer,
    activity_type_id integer NOT NULL,
    delay_count integer,
    responsible_id integer,
    create_uid integer,
    write_uid integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    summary character varying,
    responsible_type character varying NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_plan_template OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_template IS 'Activity plan template';


--
-- Name: COLUMN mail_activity_plan_template.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.plan_id IS 'Plan';


--
-- Name: COLUMN mail_activity_plan_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_plan_template.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity_plan_template.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_count IS 'Interval';


--
-- Name: COLUMN mail_activity_plan_template.responsible_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.responsible_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity_plan_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_plan_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_plan_template.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_plan_template.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_from IS 'Trigger';


--
-- Name: COLUMN mail_activity_plan_template.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.summary IS 'Summary';


--
-- Name: COLUMN mail_activity_plan_template.responsible_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.responsible_type IS 'Assignment';


--
-- Name: COLUMN mail_activity_plan_template.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.note IS 'Note';


--
-- Name: COLUMN mail_activity_plan_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_plan_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.write_date IS 'Last Updated on';


--
-- Name: mail_activity_plan_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_plan_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_plan_template_id_seq OWNER TO runbot;

--
-- Name: mail_activity_plan_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_plan_template_id_seq OWNED BY public.mail_activity_plan_template.id;


--
-- Name: mail_activity_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_rel (
    activity_id integer NOT NULL,
    recommended_id integer NOT NULL
);


ALTER TABLE public.mail_activity_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_rel IS 'RELATION BETWEEN mail_activity_type AND mail_activity_type';


--
-- Name: mail_activity_schedule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_schedule (
    id integer NOT NULL,
    res_model_id integer NOT NULL,
    plan_id integer,
    plan_on_demand_user_id integer,
    activity_type_id integer,
    activity_user_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    summary character varying,
    plan_date date,
    date_deadline date,
    res_ids text,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_schedule OWNER TO runbot;

--
-- Name: TABLE mail_activity_schedule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_schedule IS 'Activity schedule plan Wizard';


--
-- Name: COLUMN mail_activity_schedule.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_model_id IS 'Applies to';


--
-- Name: COLUMN mail_activity_schedule.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_id IS 'Plan';


--
-- Name: COLUMN mail_activity_schedule.plan_on_demand_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_on_demand_user_id IS 'Assigned To';


--
-- Name: COLUMN mail_activity_schedule.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity_schedule.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.activity_user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity_schedule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_schedule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_schedule.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_schedule.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.summary IS 'Summary';


--
-- Name: COLUMN mail_activity_schedule.plan_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_date IS 'Plan Date';


--
-- Name: COLUMN mail_activity_schedule.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity_schedule.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_ids IS 'Document IDs';


--
-- Name: COLUMN mail_activity_schedule.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.note IS 'Note';


--
-- Name: COLUMN mail_activity_schedule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_schedule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.write_date IS 'Last Updated on';


--
-- Name: mail_activity_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_schedule_id_seq OWNER TO runbot;

--
-- Name: mail_activity_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_schedule_id_seq OWNED BY public.mail_activity_schedule.id;


--
-- Name: mail_activity_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    delay_count integer,
    triggered_next_type_id integer,
    default_user_id integer,
    write_uid integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    icon character varying,
    decoration_type character varying,
    res_model character varying,
    chaining_type character varying NOT NULL,
    category character varying,
    name jsonb NOT NULL,
    summary jsonb,
    default_note jsonb,
    active boolean,
    keep_done boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_type OWNER TO runbot;

--
-- Name: TABLE mail_activity_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type IS 'Activity Type';


--
-- Name: COLUMN mail_activity_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_uid IS 'Create Uid';


--
-- Name: COLUMN mail_activity_type.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_count IS 'Schedule';


--
-- Name: COLUMN mail_activity_type.triggered_next_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.triggered_next_type_id IS 'Trigger';


--
-- Name: COLUMN mail_activity_type.default_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_user_id IS 'Default User';


--
-- Name: COLUMN mail_activity_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_type.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_type.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_from IS 'Delay Type';


--
-- Name: COLUMN mail_activity_type.icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.icon IS 'Icon';


--
-- Name: COLUMN mail_activity_type.decoration_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.decoration_type IS 'Decoration Type';


--
-- Name: COLUMN mail_activity_type.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_type.chaining_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.chaining_type IS 'Chaining Type';


--
-- Name: COLUMN mail_activity_type.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.category IS 'Action';


--
-- Name: COLUMN mail_activity_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.name IS 'Name';


--
-- Name: COLUMN mail_activity_type.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.summary IS 'Default Summary';


--
-- Name: COLUMN mail_activity_type.default_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_note IS 'Default Note';


--
-- Name: COLUMN mail_activity_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.active IS 'Active';


--
-- Name: COLUMN mail_activity_type.keep_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.keep_done IS 'Keep Done';


--
-- Name: COLUMN mail_activity_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_date IS 'Last Updated on';


--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_type_id_seq OWNER TO runbot;

--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_type_id_seq OWNED BY public.mail_activity_type.id;


--
-- Name: mail_activity_type_mail_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type_mail_template_rel (
    mail_activity_type_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_activity_type_mail_template_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_type_mail_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type_mail_template_rel IS 'RELATION BETWEEN mail_activity_type AND mail_template';


--
-- Name: mail_alias; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias (
    id integer NOT NULL,
    alias_domain_id integer,
    alias_model_id integer NOT NULL,
    alias_force_thread_id integer,
    alias_parent_model_id integer,
    alias_parent_thread_id integer,
    create_uid integer,
    write_uid integer,
    alias_name character varying,
    alias_full_name character varying,
    alias_contact character varying NOT NULL,
    alias_status character varying,
    alias_bounced_content jsonb,
    alias_defaults text NOT NULL,
    alias_incoming_local boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias OWNER TO runbot;

--
-- Name: TABLE mail_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias IS 'Email Aliases';


--
-- Name: COLUMN mail_alias.alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_alias.alias_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_model_id IS 'Aliased Model';


--
-- Name: COLUMN mail_alias.alias_force_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_force_thread_id IS 'Record Thread ID';


--
-- Name: COLUMN mail_alias.alias_parent_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_model_id IS 'Parent Model';


--
-- Name: COLUMN mail_alias.alias_parent_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_thread_id IS 'Parent Record Thread ID';


--
-- Name: COLUMN mail_alias.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias.alias_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_name IS 'Alias Name';


--
-- Name: COLUMN mail_alias.alias_full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_full_name IS 'Alias Email';


--
-- Name: COLUMN mail_alias.alias_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_contact IS 'Alias Contact Security';


--
-- Name: COLUMN mail_alias.alias_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_status IS 'Alias Status';


--
-- Name: COLUMN mail_alias.alias_bounced_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_bounced_content IS 'Custom Bounced Message';


--
-- Name: COLUMN mail_alias.alias_defaults; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_defaults IS 'Default Values';


--
-- Name: COLUMN mail_alias.alias_incoming_local; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_incoming_local IS 'Local-part based incoming detection';


--
-- Name: COLUMN mail_alias.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_date IS 'Last Updated on';


--
-- Name: mail_alias_domain; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias_domain (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bounce_alias character varying NOT NULL,
    catchall_alias character varying NOT NULL,
    default_from character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias_domain OWNER TO runbot;

--
-- Name: TABLE mail_alias_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias_domain IS 'Email Domain';


--
-- Name: COLUMN mail_alias_domain.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.sequence IS 'Sequence';


--
-- Name: COLUMN mail_alias_domain.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias_domain.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias_domain.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.name IS 'Name';


--
-- Name: COLUMN mail_alias_domain.bounce_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.bounce_alias IS 'Bounce Alias';


--
-- Name: COLUMN mail_alias_domain.catchall_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.catchall_alias IS 'Catchall Alias';


--
-- Name: COLUMN mail_alias_domain.default_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.default_from IS 'Default From Alias';


--
-- Name: COLUMN mail_alias_domain.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias_domain.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.write_date IS 'Last Updated on';


--
-- Name: mail_alias_domain_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_domain_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_domain_id_seq OWNER TO runbot;

--
-- Name: mail_alias_domain_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_domain_id_seq OWNED BY public.mail_alias_domain.id;


--
-- Name: mail_alias_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_id_seq OWNER TO runbot;

--
-- Name: mail_alias_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_id_seq OWNED BY public.mail_alias.id;


--
-- Name: mail_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    opt_out_reason_id integer
);


ALTER TABLE public.mail_blacklist OWNER TO runbot;

--
-- Name: TABLE mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist IS 'Mail Blacklist';


--
-- Name: COLUMN mail_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.email IS 'Email Address';


--
-- Name: COLUMN mail_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.active IS 'Active';


--
-- Name: COLUMN mail_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_blacklist.opt_out_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.opt_out_reason_id IS 'Opt-out Reason';


--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_id_seq OWNED BY public.mail_blacklist.id;


--
-- Name: mail_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE mail_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist_remove IS 'Remove email from blacklist wizard';


--
-- Name: COLUMN mail_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist_remove.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.email IS 'Email';


--
-- Name: COLUMN mail_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN mail_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNED BY public.mail_blacklist_remove.id;


--
-- Name: mail_canned_response; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_canned_response (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source character varying NOT NULL,
    description character varying,
    substitution text NOT NULL,
    is_shared boolean,
    last_used timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_canned_response OWNER TO runbot;

--
-- Name: TABLE mail_canned_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_canned_response IS 'Canned Response';


--
-- Name: COLUMN mail_canned_response.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.create_uid IS 'Created by';


--
-- Name: COLUMN mail_canned_response.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_canned_response.source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.source IS 'Shortcut';


--
-- Name: COLUMN mail_canned_response.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.description IS 'Description';


--
-- Name: COLUMN mail_canned_response.substitution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.substitution IS 'Substitution';


--
-- Name: COLUMN mail_canned_response.is_shared; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.is_shared IS 'Determines if the canned_response is currently shared with other users';


--
-- Name: COLUMN mail_canned_response.last_used; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.last_used IS 'Last Used';


--
-- Name: COLUMN mail_canned_response.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.create_date IS 'Created on';


--
-- Name: COLUMN mail_canned_response.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.write_date IS 'Last Updated on';


--
-- Name: mail_canned_response_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_canned_response_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_canned_response_id_seq OWNER TO runbot;

--
-- Name: mail_canned_response_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_canned_response_id_seq OWNED BY public.mail_canned_response.id;


--
-- Name: mail_canned_response_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_canned_response_res_groups_rel (
    mail_canned_response_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.mail_canned_response_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE mail_canned_response_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_canned_response_res_groups_rel IS 'RELATION BETWEEN mail_canned_response AND res_groups';


--
-- Name: mail_compose_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message (
    id integer NOT NULL,
    template_id integer,
    parent_id integer,
    author_id integer,
    res_domain_user_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    email_layout_xmlid character varying,
    email_from character varying,
    composition_mode character varying,
    model character varying,
    record_name character varying,
    message_type character varying NOT NULL,
    reply_to character varying,
    scheduled_date character varying,
    template_name character varying,
    body text,
    res_ids text,
    res_domain text,
    email_add_signature boolean,
    reply_to_force_new boolean,
    auto_delete boolean,
    auto_delete_keep_log boolean,
    force_send boolean,
    use_exclusion_list boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    mass_mailing_id integer,
    campaign_id integer,
    mass_mailing_name character varying
);


ALTER TABLE public.mail_compose_message OWNER TO runbot;

--
-- Name: TABLE mail_compose_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message IS 'Email composition wizard';


--
-- Name: COLUMN mail_compose_message.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_id IS 'Use template';


--
-- Name: COLUMN mail_compose_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_compose_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.author_id IS 'Author';


--
-- Name: COLUMN mail_compose_message.res_domain_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_domain_user_id IS 'Responsible';


--
-- Name: COLUMN mail_compose_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_compose_message.record_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_compose_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_compose_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_compose_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_compose_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_compose_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_compose_message.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.lang IS 'Language';


--
-- Name: COLUMN mail_compose_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subject IS 'Subject';


--
-- Name: COLUMN mail_compose_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_layout_xmlid IS 'Email Notification Layout';


--
-- Name: COLUMN mail_compose_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_from IS 'From';


--
-- Name: COLUMN mail_compose_message.composition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.composition_mode IS 'Composition mode';


--
-- Name: COLUMN mail_compose_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_compose_message.record_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_name IS 'Record Name';


--
-- Name: COLUMN mail_compose_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.message_type IS 'Type';


--
-- Name: COLUMN mail_compose_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_compose_message.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_compose_message.template_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_name IS 'Template Name';


--
-- Name: COLUMN mail_compose_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.body IS 'Contents';


--
-- Name: COLUMN mail_compose_message.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_ids IS 'Related Document IDs';


--
-- Name: COLUMN mail_compose_message.res_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_domain IS 'Active domain';


--
-- Name: COLUMN mail_compose_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_add_signature IS 'Add signature';


--
-- Name: COLUMN mail_compose_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to_force_new IS 'Considers answers as new thread';


--
-- Name: COLUMN mail_compose_message.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete IS 'Delete Emails';


--
-- Name: COLUMN mail_compose_message.auto_delete_keep_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete_keep_log IS 'Keep Message Copy';


--
-- Name: COLUMN mail_compose_message.force_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.force_send IS 'Send mailing or notifications directly';


--
-- Name: COLUMN mail_compose_message.use_exclusion_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.use_exclusion_list IS 'Check Exclusion List';


--
-- Name: COLUMN mail_compose_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_compose_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_compose_message.mass_mailing_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mass_mailing_id IS 'Mass Mailing';


--
-- Name: COLUMN mail_compose_message.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.campaign_id IS 'Mass Mailing Campaign';


--
-- Name: COLUMN mail_compose_message.mass_mailing_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mass_mailing_name IS 'Mass Mailing Name';


--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_compose_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_compose_message_id_seq OWNER TO runbot;

--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_compose_message_id_seq OWNED BY public.mail_compose_message.id;


--
-- Name: mail_compose_message_ir_attachments_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_ir_attachments_rel (
    wizard_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_ir_attachments_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_ir_attachments_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_ir_attachments_rel IS 'RELATION BETWEEN mail_compose_message AND ir_attachment';


--
-- Name: mail_compose_message_mailing_list_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_mailing_list_rel (
    mail_compose_message_id integer NOT NULL,
    mailing_list_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_mailing_list_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_mailing_list_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_mailing_list_rel IS 'RELATION BETWEEN mail_compose_message AND mailing_list';


--
-- Name: mail_compose_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_res_partner_rel (
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_res_partner_rel IS 'RELATION BETWEEN mail_compose_message AND res_partner';


--
-- Name: mail_followers; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers (
    id integer NOT NULL,
    res_id integer,
    partner_id integer NOT NULL,
    res_model character varying NOT NULL
);


ALTER TABLE public.mail_followers OWNER TO runbot;

--
-- Name: TABLE mail_followers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers IS 'Document Followers';


--
-- Name: COLUMN mail_followers.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_followers.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.partner_id IS 'Related Partner';


--
-- Name: COLUMN mail_followers.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_model IS 'Related Document Model Name';


--
-- Name: mail_followers_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_followers_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_followers_id_seq OWNER TO runbot;

--
-- Name: mail_followers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_followers_id_seq OWNED BY public.mail_followers.id;


--
-- Name: mail_followers_mail_message_subtype_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_mail_message_subtype_rel (
    mail_followers_id integer NOT NULL,
    mail_message_subtype_id integer NOT NULL
);


ALTER TABLE public.mail_followers_mail_message_subtype_rel OWNER TO runbot;

--
-- Name: TABLE mail_followers_mail_message_subtype_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_mail_message_subtype_rel IS 'RELATION BETWEEN mail_followers AND mail_message_subtype';


--
-- Name: mail_gateway_allowed; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_gateway_allowed (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    email_normalized character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_gateway_allowed OWNER TO runbot;

--
-- Name: TABLE mail_gateway_allowed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_gateway_allowed IS 'Mail Gateway Allowed';


--
-- Name: COLUMN mail_gateway_allowed.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_uid IS 'Created by';


--
-- Name: COLUMN mail_gateway_allowed.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_gateway_allowed.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email IS 'Email Address';


--
-- Name: COLUMN mail_gateway_allowed.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN mail_gateway_allowed.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_date IS 'Created on';


--
-- Name: COLUMN mail_gateway_allowed.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_date IS 'Last Updated on';


--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_gateway_allowed_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNER TO runbot;

--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNED BY public.mail_gateway_allowed.id;


--
-- Name: mail_guest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_guest (
    id integer NOT NULL,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    access_token character varying NOT NULL,
    lang character varying,
    timezone character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_guest OWNER TO runbot;

--
-- Name: TABLE mail_guest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_guest IS 'Guest';


--
-- Name: COLUMN mail_guest.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.country_id IS 'Country';


--
-- Name: COLUMN mail_guest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_uid IS 'Created by';


--
-- Name: COLUMN mail_guest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_guest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.name IS 'Name';


--
-- Name: COLUMN mail_guest.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.access_token IS 'Access Token';


--
-- Name: COLUMN mail_guest.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.lang IS 'Language';


--
-- Name: COLUMN mail_guest.timezone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.timezone IS 'Timezone';


--
-- Name: COLUMN mail_guest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_date IS 'Created on';


--
-- Name: COLUMN mail_guest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_date IS 'Last Updated on';


--
-- Name: mail_guest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_guest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_guest_id_seq OWNER TO runbot;

--
-- Name: mail_guest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_guest_id_seq OWNED BY public.mail_guest.id;


--
-- Name: mail_ice_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_ice_server (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    server_type character varying NOT NULL,
    uri character varying NOT NULL,
    username character varying,
    credential character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_ice_server OWNER TO runbot;

--
-- Name: TABLE mail_ice_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_ice_server IS 'ICE server';


--
-- Name: COLUMN mail_ice_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_uid IS 'Created by';


--
-- Name: COLUMN mail_ice_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_ice_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.server_type IS 'Type';


--
-- Name: COLUMN mail_ice_server.uri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.uri IS 'URI';


--
-- Name: COLUMN mail_ice_server.username; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.username IS 'Username';


--
-- Name: COLUMN mail_ice_server.credential; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.credential IS 'Credential';


--
-- Name: COLUMN mail_ice_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_date IS 'Created on';


--
-- Name: COLUMN mail_ice_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_date IS 'Last Updated on';


--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_ice_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_ice_server_id_seq OWNER TO runbot;

--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_ice_server_id_seq OWNED BY public.mail_ice_server.id;


--
-- Name: mail_link_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_link_preview (
    id integer NOT NULL,
    message_id integer,
    create_uid integer,
    write_uid integer,
    source_url character varying NOT NULL,
    og_type character varying,
    og_title character varying,
    og_site_name character varying,
    og_image character varying,
    og_mimetype character varying,
    image_mimetype character varying,
    og_description text,
    is_hidden boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_link_preview OWNER TO runbot;

--
-- Name: TABLE mail_link_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_link_preview IS 'Store link preview data';


--
-- Name: COLUMN mail_link_preview.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.message_id IS 'Message';


--
-- Name: COLUMN mail_link_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_link_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_link_preview.source_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.source_url IS 'URL';


--
-- Name: COLUMN mail_link_preview.og_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_type IS 'Type';


--
-- Name: COLUMN mail_link_preview.og_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_title IS 'Title';


--
-- Name: COLUMN mail_link_preview.og_site_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_site_name IS 'Site name';


--
-- Name: COLUMN mail_link_preview.og_image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_image IS 'Image';


--
-- Name: COLUMN mail_link_preview.og_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_mimetype IS 'MIME type';


--
-- Name: COLUMN mail_link_preview.image_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.image_mimetype IS 'Image MIME type';


--
-- Name: COLUMN mail_link_preview.og_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_description IS 'Description';


--
-- Name: COLUMN mail_link_preview.is_hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.is_hidden IS 'Is Hidden';


--
-- Name: COLUMN mail_link_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_date IS 'Create Date';


--
-- Name: COLUMN mail_link_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_date IS 'Last Updated on';


--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_link_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_link_preview_id_seq OWNER TO runbot;

--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_link_preview_id_seq OWNED BY public.mail_link_preview.id;


--
-- Name: mail_mail; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    fetchmail_server_id integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    state character varying,
    failure_type character varying,
    body_html text,
    "references" text,
    headers text,
    email_to text,
    failure_reason text,
    is_notification boolean,
    auto_delete boolean,
    scheduled_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    mailing_id integer
);


ALTER TABLE public.mail_mail OWNER TO runbot;

--
-- Name: TABLE mail_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail IS 'Outgoing Mails';


--
-- Name: COLUMN mail_mail.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_mail.fetchmail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.fetchmail_server_id IS 'Inbound Mail Server';


--
-- Name: COLUMN mail_mail.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_uid IS 'Created by';


--
-- Name: COLUMN mail_mail.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_mail.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_cc IS 'Cc';


--
-- Name: COLUMN mail_mail.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.state IS 'Status';


--
-- Name: COLUMN mail_mail.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_mail.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.body_html IS 'Text Contents';


--
-- Name: COLUMN mail_mail."references"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail."references" IS 'References';


--
-- Name: COLUMN mail_mail.headers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.headers IS 'Headers';


--
-- Name: COLUMN mail_mail.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_to IS 'To';


--
-- Name: COLUMN mail_mail.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_reason IS 'Failure Reason';


--
-- Name: COLUMN mail_mail.is_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.is_notification IS 'Notification Email';


--
-- Name: COLUMN mail_mail.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_mail.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.scheduled_date IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_mail.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_date IS 'Created on';


--
-- Name: COLUMN mail_mail.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_mail.mailing_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.mailing_id IS 'Mass Mailing';


--
-- Name: mail_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_mail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_mail_id_seq OWNER TO runbot;

--
-- Name: mail_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_mail_id_seq OWNED BY public.mail_mail.id;


--
-- Name: mail_mail_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail_res_partner_rel (
    mail_mail_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_mail_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_mail_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail_res_partner_rel IS 'RELATION BETWEEN mail_mail AND res_partner';


--
-- Name: mail_mass_mailing_list_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mass_mailing_list_rel (
    mailing_list_id integer NOT NULL,
    mailing_mailing_id integer NOT NULL
);


ALTER TABLE public.mail_mass_mailing_list_rel OWNER TO runbot;

--
-- Name: TABLE mail_mass_mailing_list_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mass_mailing_list_rel IS 'RELATION BETWEEN mailing_list AND mailing_mailing';


--
-- Name: mail_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_id_seq OWNER TO runbot;

--
-- Name: mail_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_id_seq OWNED BY public.mail_message.id;


--
-- Name: mail_message_reaction; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_reaction (
    id integer NOT NULL,
    message_id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    content character varying NOT NULL,
    CONSTRAINT mail_message_reaction_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.mail_message_reaction OWNER TO runbot;

--
-- Name: TABLE mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_reaction IS 'Message Reaction';


--
-- Name: COLUMN mail_message_reaction.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.message_id IS 'Message';


--
-- Name: COLUMN mail_message_reaction.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.partner_id IS 'Reacting Partner';


--
-- Name: COLUMN mail_message_reaction.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.guest_id IS 'Reacting Guest';


--
-- Name: COLUMN mail_message_reaction.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.content IS 'Content';


--
-- Name: CONSTRAINT mail_message_reaction_partner_or_guest_exists ON mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_message_reaction_partner_or_guest_exists ON public.mail_message_reaction IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_reaction_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_reaction_id_seq OWNER TO runbot;

--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_reaction_id_seq OWNED BY public.mail_message_reaction.id;


--
-- Name: mail_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_res_partner_starred_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_starred_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_starred_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_starred_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_starred_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_schedule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_schedule (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    notification_parameters text,
    scheduled_datetime timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_schedule OWNER TO runbot;

--
-- Name: TABLE mail_message_schedule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_schedule IS 'Scheduled Messages';


--
-- Name: COLUMN mail_message_schedule.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_message_schedule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_schedule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_schedule.notification_parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.notification_parameters IS 'Notification Parameter';


--
-- Name: COLUMN mail_message_schedule.scheduled_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.scheduled_datetime IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_message_schedule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_schedule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_date IS 'Last Updated on';


--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_schedule_id_seq OWNER TO runbot;

--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_schedule_id_seq OWNED BY public.mail_message_schedule.id;


--
-- Name: mail_message_subtype; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_subtype (
    id integer NOT NULL,
    parent_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    relation_field character varying,
    res_model character varying,
    name jsonb NOT NULL,
    description jsonb,
    internal boolean,
    "default" boolean,
    hidden boolean,
    track_recipients boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_subtype OWNER TO runbot;

--
-- Name: TABLE mail_message_subtype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_subtype IS 'Message subtypes';


--
-- Name: COLUMN mail_message_subtype.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.parent_id IS 'Parent';


--
-- Name: COLUMN mail_message_subtype.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.sequence IS 'Sequence';


--
-- Name: COLUMN mail_message_subtype.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_subtype.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_subtype.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.relation_field IS 'Relation field';


--
-- Name: COLUMN mail_message_subtype.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.res_model IS 'Model';


--
-- Name: COLUMN mail_message_subtype.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.name IS 'Message Type';


--
-- Name: COLUMN mail_message_subtype.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.description IS 'Description';


--
-- Name: COLUMN mail_message_subtype.internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.internal IS 'Internal Only';


--
-- Name: COLUMN mail_message_subtype."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype."default" IS 'Default';


--
-- Name: COLUMN mail_message_subtype.hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.hidden IS 'Hidden';


--
-- Name: COLUMN mail_message_subtype.track_recipients; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.track_recipients IS 'Track Recipients';


--
-- Name: COLUMN mail_message_subtype.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_subtype.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_date IS 'Last Updated on';


--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_subtype_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_subtype_id_seq OWNER TO runbot;

--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_subtype_id_seq OWNED BY public.mail_message_subtype.id;


--
-- Name: mail_message_translation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_translation (
    id integer NOT NULL,
    message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source_lang character varying NOT NULL,
    target_lang character varying NOT NULL,
    body text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_translation OWNER TO runbot;

--
-- Name: TABLE mail_message_translation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_translation IS 'Message Translation';


--
-- Name: COLUMN mail_message_translation.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.message_id IS 'Message';


--
-- Name: COLUMN mail_message_translation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_translation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_translation.source_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.source_lang IS 'Source Language';


--
-- Name: COLUMN mail_message_translation.target_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.target_lang IS 'Target Language';


--
-- Name: COLUMN mail_message_translation.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.body IS 'Translation Body';


--
-- Name: COLUMN mail_message_translation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.create_date IS 'Create Date';


--
-- Name: COLUMN mail_message_translation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.write_date IS 'Last Updated on';


--
-- Name: mail_message_translation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_translation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_translation_id_seq OWNER TO runbot;

--
-- Name: mail_message_translation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_translation_id_seq OWNED BY public.mail_message_translation.id;


--
-- Name: mail_notification; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_notification (
    id integer NOT NULL,
    author_id integer,
    mail_message_id integer NOT NULL,
    mail_mail_id integer,
    res_partner_id integer,
    notification_type character varying NOT NULL,
    notification_status character varying,
    failure_type character varying,
    failure_reason text,
    is_read boolean,
    read_date timestamp without time zone,
    sms_id_int integer,
    sms_number character varying,
    letter_id integer,
    CONSTRAINT mail_notification_notification_partner_required CHECK ((((notification_type)::text <> ALL ((ARRAY['email'::character varying, 'inbox'::character varying])::text[])) OR (res_partner_id IS NOT NULL)))
);


ALTER TABLE public.mail_notification OWNER TO runbot;

--
-- Name: TABLE mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_notification IS 'Message Notifications';


--
-- Name: COLUMN mail_notification.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.author_id IS 'Author';


--
-- Name: COLUMN mail_notification.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_notification.mail_mail_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_mail_id IS 'Mail';


--
-- Name: COLUMN mail_notification.res_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.res_partner_id IS 'Recipient';


--
-- Name: COLUMN mail_notification.notification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_type IS 'Notification Type';


--
-- Name: COLUMN mail_notification.notification_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_status IS 'Status';


--
-- Name: COLUMN mail_notification.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_notification.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_reason IS 'Failure reason';


--
-- Name: COLUMN mail_notification.is_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.is_read IS 'Is Read';


--
-- Name: COLUMN mail_notification.read_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.read_date IS 'Read Date';


--
-- Name: COLUMN mail_notification.sms_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_id_int IS 'SMS ID';


--
-- Name: COLUMN mail_notification.sms_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_number IS 'SMS Number';


--
-- Name: COLUMN mail_notification.letter_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.letter_id IS 'Snailmail Letter';


--
-- Name: CONSTRAINT mail_notification_notification_partner_required ON mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_notification_notification_partner_required ON public.mail_notification IS 'CHECK(notification_type NOT IN (''email'', ''inbox'') OR res_partner_id IS NOT NULL)';


--
-- Name: mail_notification_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_notification_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_notification_id_seq OWNER TO runbot;

--
-- Name: mail_notification_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_notification_id_seq OWNED BY public.mail_notification.id;


--
-- Name: mail_notification_mail_resend_message_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_notification_mail_resend_message_rel (
    mail_resend_message_id integer NOT NULL,
    mail_notification_id integer NOT NULL
);


ALTER TABLE public.mail_notification_mail_resend_message_rel OWNER TO runbot;

--
-- Name: TABLE mail_notification_mail_resend_message_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_notification_mail_resend_message_rel IS 'RELATION BETWEEN mail_resend_message AND mail_notification';


--
-- Name: mail_push; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_push (
    id integer NOT NULL,
    mail_push_device_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payload text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_push OWNER TO runbot;

--
-- Name: TABLE mail_push; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_push IS 'Push Notifications';


--
-- Name: COLUMN mail_push.mail_push_device_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.mail_push_device_id IS 'devices';


--
-- Name: COLUMN mail_push.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.create_uid IS 'Created by';


--
-- Name: COLUMN mail_push.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_push.payload; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.payload IS 'Payload';


--
-- Name: COLUMN mail_push.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.create_date IS 'Created on';


--
-- Name: COLUMN mail_push.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.write_date IS 'Last Updated on';


--
-- Name: mail_push_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_push_device (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    endpoint character varying NOT NULL,
    keys character varying NOT NULL,
    expiration_time timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_push_device OWNER TO runbot;

--
-- Name: TABLE mail_push_device; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_push_device IS 'Push Notification Device';


--
-- Name: COLUMN mail_push_device.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.partner_id IS 'Partner';


--
-- Name: COLUMN mail_push_device.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.create_uid IS 'Created by';


--
-- Name: COLUMN mail_push_device.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_push_device.endpoint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.endpoint IS 'Browser endpoint';


--
-- Name: COLUMN mail_push_device.keys; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.keys IS 'Browser keys';


--
-- Name: COLUMN mail_push_device.expiration_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.expiration_time IS 'Expiration Token Date';


--
-- Name: COLUMN mail_push_device.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.create_date IS 'Created on';


--
-- Name: COLUMN mail_push_device.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.write_date IS 'Last Updated on';


--
-- Name: mail_push_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_push_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_push_device_id_seq OWNER TO runbot;

--
-- Name: mail_push_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_push_device_id_seq OWNED BY public.mail_push_device.id;


--
-- Name: mail_push_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_push_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_push_id_seq OWNER TO runbot;

--
-- Name: mail_push_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_push_id_seq OWNED BY public.mail_push.id;


--
-- Name: mail_resend_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_resend_message (
    id integer NOT NULL,
    mail_message_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_resend_message OWNER TO runbot;

--
-- Name: TABLE mail_resend_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_resend_message IS 'Email resend wizard';


--
-- Name: COLUMN mail_resend_message.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_resend_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_resend_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_resend_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_resend_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.write_date IS 'Last Updated on';


--
-- Name: mail_resend_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_resend_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_resend_message_id_seq OWNER TO runbot;

--
-- Name: mail_resend_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_resend_message_id_seq OWNED BY public.mail_resend_message.id;


--
-- Name: mail_resend_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_resend_partner (
    id integer NOT NULL,
    notification_id integer NOT NULL,
    resend_wizard_id integer,
    create_uid integer,
    write_uid integer,
    message character varying,
    resend boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_resend_partner OWNER TO runbot;

--
-- Name: TABLE mail_resend_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_resend_partner IS 'Partner with additional information for mail resend';


--
-- Name: COLUMN mail_resend_partner.notification_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.notification_id IS 'Notification';


--
-- Name: COLUMN mail_resend_partner.resend_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.resend_wizard_id IS 'Resend wizard';


--
-- Name: COLUMN mail_resend_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.create_uid IS 'Created by';


--
-- Name: COLUMN mail_resend_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_resend_partner.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.message IS 'Error message';


--
-- Name: COLUMN mail_resend_partner.resend; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.resend IS 'Try Again';


--
-- Name: COLUMN mail_resend_partner.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.create_date IS 'Created on';


--
-- Name: COLUMN mail_resend_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.write_date IS 'Last Updated on';


--
-- Name: mail_resend_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_resend_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_resend_partner_id_seq OWNER TO runbot;

--
-- Name: mail_resend_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_resend_partner_id_seq OWNED BY public.mail_resend_partner.id;


--
-- Name: mail_scheduled_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_scheduled_message (
    id integer NOT NULL,
    res_id integer NOT NULL,
    author_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    subject character varying,
    model character varying NOT NULL,
    body text,
    notification_parameters text,
    is_note boolean,
    scheduled_date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_scheduled_message OWNER TO runbot;

--
-- Name: TABLE mail_scheduled_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_scheduled_message IS 'Scheduled Message';


--
-- Name: COLUMN mail_scheduled_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.res_id IS 'Related Document Id';


--
-- Name: COLUMN mail_scheduled_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.author_id IS 'Author';


--
-- Name: COLUMN mail_scheduled_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_scheduled_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_scheduled_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.subject IS 'Subject';


--
-- Name: COLUMN mail_scheduled_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_scheduled_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.body IS 'Contents';


--
-- Name: COLUMN mail_scheduled_message.notification_parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.notification_parameters IS 'Notification parameters';


--
-- Name: COLUMN mail_scheduled_message.is_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.is_note IS 'Is a note';


--
-- Name: COLUMN mail_scheduled_message.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_scheduled_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_scheduled_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.write_date IS 'Last Updated on';


--
-- Name: mail_scheduled_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_scheduled_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_scheduled_message_id_seq OWNER TO runbot;

--
-- Name: mail_scheduled_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_scheduled_message_id_seq OWNED BY public.mail_scheduled_message.id;


--
-- Name: mail_scheduled_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_scheduled_message_res_partner_rel (
    mail_scheduled_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_scheduled_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_scheduled_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_scheduled_message_res_partner_rel IS 'RELATION BETWEEN mail_scheduled_message AND res_partner';


--
-- Name: mail_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template (
    id integer NOT NULL,
    model_id integer,
    user_id integer,
    mail_server_id integer,
    ref_ir_act_window integer,
    create_uid integer,
    write_uid integer,
    template_fs character varying,
    lang character varying,
    model character varying,
    email_from character varying,
    email_to character varying,
    partner_to character varying,
    email_cc character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    scheduled_date character varying,
    name jsonb,
    description jsonb,
    subject jsonb,
    body_html jsonb,
    active boolean,
    use_default_to boolean,
    auto_delete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template OWNER TO runbot;

--
-- Name: TABLE mail_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template IS 'Email Templates';


--
-- Name: COLUMN mail_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model_id IS 'Applies to';


--
-- Name: COLUMN mail_template.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.user_id IS 'User';


--
-- Name: COLUMN mail_template.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.mail_server_id IS 'Outgoing Mail Server';


--
-- Name: COLUMN mail_template.ref_ir_act_window; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.ref_ir_act_window IS 'Sidebar action';


--
-- Name: COLUMN mail_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template.template_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.template_fs IS 'Template Filename';


--
-- Name: COLUMN mail_template.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.lang IS 'Language';


--
-- Name: COLUMN mail_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model IS 'Related Document Model';


--
-- Name: COLUMN mail_template.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_from IS 'From';


--
-- Name: COLUMN mail_template.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_to IS 'To (Emails)';


--
-- Name: COLUMN mail_template.partner_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.partner_to IS 'To (Partners)';


--
-- Name: COLUMN mail_template.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_cc IS 'Cc';


--
-- Name: COLUMN mail_template.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_template.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_layout_xmlid IS 'Email Notification Layout';


--
-- Name: COLUMN mail_template.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.name IS 'Name';


--
-- Name: COLUMN mail_template.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.description IS 'Template Description';


--
-- Name: COLUMN mail_template.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.subject IS 'Subject';


--
-- Name: COLUMN mail_template.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.body_html IS 'Body';


--
-- Name: COLUMN mail_template.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.active IS 'Active';


--
-- Name: COLUMN mail_template.use_default_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.use_default_to IS 'Default recipients';


--
-- Name: COLUMN mail_template.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_date IS 'Last Updated on';


--
-- Name: mail_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_id_seq OWNER TO runbot;

--
-- Name: mail_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_id_seq OWNED BY public.mail_template.id;


--
-- Name: mail_template_ir_actions_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_ir_actions_report_rel (
    mail_template_id integer NOT NULL,
    ir_actions_report_id integer NOT NULL
);


ALTER TABLE public.mail_template_ir_actions_report_rel OWNER TO runbot;

--
-- Name: TABLE mail_template_ir_actions_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_ir_actions_report_rel IS 'RELATION BETWEEN mail_template AND ir_act_report_xml';


--
-- Name: mail_template_mail_template_reset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_mail_template_reset_rel (
    mail_template_reset_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_template_mail_template_reset_rel OWNER TO runbot;

--
-- Name: TABLE mail_template_mail_template_reset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_mail_template_reset_rel IS 'RELATION BETWEEN mail_template_reset AND mail_template';


--
-- Name: mail_template_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_preview (
    id integer NOT NULL,
    mail_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    resource_ref character varying,
    lang character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_preview OWNER TO runbot;

--
-- Name: TABLE mail_template_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_preview IS 'Email Template Preview';


--
-- Name: COLUMN mail_template_preview.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.mail_template_id IS 'Related Mail Template';


--
-- Name: COLUMN mail_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_preview.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.resource_ref IS 'Record';


--
-- Name: COLUMN mail_template_preview.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.lang IS 'Template Preview Language';


--
-- Name: COLUMN mail_template_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_date IS 'Last Updated on';


--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_preview_id_seq OWNER TO runbot;

--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_preview_id_seq OWNED BY public.mail_template_preview.id;


--
-- Name: mail_template_reset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_reset (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_reset OWNER TO runbot;

--
-- Name: TABLE mail_template_reset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_reset IS 'Mail Template Reset';


--
-- Name: COLUMN mail_template_reset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_reset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_reset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_reset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_date IS 'Last Updated on';


--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_reset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_reset_id_seq OWNER TO runbot;

--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_reset_id_seq OWNED BY public.mail_template_reset.id;


--
-- Name: mail_tracking_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_tracking_value (
    id integer NOT NULL,
    field_id integer,
    old_value_integer integer,
    new_value_integer integer,
    currency_id integer,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    old_value_char character varying,
    new_value_char character varying,
    field_info jsonb,
    old_value_text text,
    new_value_text text,
    old_value_datetime timestamp without time zone,
    new_value_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    old_value_float double precision,
    new_value_float double precision
);


ALTER TABLE public.mail_tracking_value OWNER TO runbot;

--
-- Name: TABLE mail_tracking_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_tracking_value IS 'Mail Tracking Value';


--
-- Name: COLUMN mail_tracking_value.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_id IS 'Field';


--
-- Name: COLUMN mail_tracking_value.old_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_integer IS 'Old Value Integer';


--
-- Name: COLUMN mail_tracking_value.new_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_integer IS 'New Value Integer';


--
-- Name: COLUMN mail_tracking_value.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.currency_id IS 'Currency';


--
-- Name: COLUMN mail_tracking_value.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.mail_message_id IS 'Message ID';


--
-- Name: COLUMN mail_tracking_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_uid IS 'Created by';


--
-- Name: COLUMN mail_tracking_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_tracking_value.old_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_char IS 'Old Value Char';


--
-- Name: COLUMN mail_tracking_value.new_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_char IS 'New Value Char';


--
-- Name: COLUMN mail_tracking_value.field_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_info IS 'Removed field information';


--
-- Name: COLUMN mail_tracking_value.old_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_text IS 'Old Value Text';


--
-- Name: COLUMN mail_tracking_value.new_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_text IS 'New Value Text';


--
-- Name: COLUMN mail_tracking_value.old_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_datetime IS 'Old Value DateTime';


--
-- Name: COLUMN mail_tracking_value.new_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_datetime IS 'New Value Datetime';


--
-- Name: COLUMN mail_tracking_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_date IS 'Created on';


--
-- Name: COLUMN mail_tracking_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_tracking_value.old_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_float IS 'Old Value Float';


--
-- Name: COLUMN mail_tracking_value.new_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_float IS 'New Value Float';


--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_tracking_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_tracking_value_id_seq OWNER TO runbot;

--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_tracking_value_id_seq OWNED BY public.mail_tracking_value.id;


--
-- Name: mail_wizard_invite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_wizard_invite (
    id integer NOT NULL,
    res_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    message text,
    notify boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_wizard_invite OWNER TO runbot;

--
-- Name: TABLE mail_wizard_invite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_wizard_invite IS 'Invite wizard';


--
-- Name: COLUMN mail_wizard_invite.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_wizard_invite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.create_uid IS 'Created by';


--
-- Name: COLUMN mail_wizard_invite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_wizard_invite.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_wizard_invite.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.message IS 'Message';


--
-- Name: COLUMN mail_wizard_invite.notify; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.notify IS 'Notify Recipients';


--
-- Name: COLUMN mail_wizard_invite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.create_date IS 'Created on';


--
-- Name: COLUMN mail_wizard_invite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.write_date IS 'Last Updated on';


--
-- Name: mail_wizard_invite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_wizard_invite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_wizard_invite_id_seq OWNER TO runbot;

--
-- Name: mail_wizard_invite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_wizard_invite_id_seq OWNED BY public.mail_wizard_invite.id;


--
-- Name: mail_wizard_invite_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_wizard_invite_res_partner_rel (
    mail_wizard_invite_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_wizard_invite_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_wizard_invite_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_wizard_invite_res_partner_rel IS 'RELATION BETWEEN mail_wizard_invite AND res_partner';


--
-- Name: mailing_contact; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_contact (
    id integer NOT NULL,
    message_bounce integer,
    title_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    email_normalized character varying,
    name character varying,
    first_name character varying,
    last_name character varying,
    company_name character varying,
    email character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    phone_sanitized character varying,
    mobile character varying
);


ALTER TABLE public.mailing_contact OWNER TO runbot;

--
-- Name: TABLE mailing_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_contact IS 'Mailing Contact';


--
-- Name: COLUMN mailing_contact.message_bounce; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact.message_bounce IS 'Bounce';


--
-- Name: COLUMN mailing_contact.title_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact.title_id IS 'Title';


--
-- Name: COLUMN mailing_contact.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact.country_id IS 'Country';


--
-- Name: COLUMN mailing_contact.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact.create_uid IS 'Created by';


--
-- Name: COLUMN mailing_contact.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mailing_contact.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN mailing_contact.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact.name IS 'Name';


--
-- Name: COLUMN mailing_contact.first_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact.first_name IS 'First Name';


--
-- Name: COLUMN mailing_contact.last_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact.last_name IS 'Last Name';


--
-- Name: COLUMN mailing_contact.company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact.company_name IS 'Company Name';


--
-- Name: COLUMN mailing_contact.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact.email IS 'Email';


--
-- Name: COLUMN mailing_contact.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact.create_date IS 'Created on';


--
-- Name: COLUMN mailing_contact.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact.write_date IS 'Last Updated on';


--
-- Name: COLUMN mailing_contact.phone_sanitized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact.phone_sanitized IS 'Sanitized Number';


--
-- Name: COLUMN mailing_contact.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact.mobile IS 'Mobile';


--
-- Name: mailing_contact_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mailing_contact_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mailing_contact_id_seq OWNER TO runbot;

--
-- Name: mailing_contact_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mailing_contact_id_seq OWNED BY public.mailing_contact.id;


--
-- Name: mailing_contact_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_contact_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    contact_list text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mailing_contact_import OWNER TO runbot;

--
-- Name: TABLE mailing_contact_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_contact_import IS 'Mailing Contact Import';


--
-- Name: COLUMN mailing_contact_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact_import.create_uid IS 'Created by';


--
-- Name: COLUMN mailing_contact_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mailing_contact_import.contact_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact_import.contact_list IS 'Contact List';


--
-- Name: COLUMN mailing_contact_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact_import.create_date IS 'Created on';


--
-- Name: COLUMN mailing_contact_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact_import.write_date IS 'Last Updated on';


--
-- Name: mailing_contact_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mailing_contact_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mailing_contact_import_id_seq OWNER TO runbot;

--
-- Name: mailing_contact_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mailing_contact_import_id_seq OWNED BY public.mailing_contact_import.id;


--
-- Name: mailing_contact_import_mailing_list_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_contact_import_mailing_list_rel (
    mailing_contact_import_id integer NOT NULL,
    mailing_list_id integer NOT NULL
);


ALTER TABLE public.mailing_contact_import_mailing_list_rel OWNER TO runbot;

--
-- Name: TABLE mailing_contact_import_mailing_list_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_contact_import_mailing_list_rel IS 'RELATION BETWEEN mailing_contact_import AND mailing_list';


--
-- Name: mailing_contact_mailing_contact_to_list_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_contact_mailing_contact_to_list_rel (
    mailing_contact_to_list_id integer NOT NULL,
    mailing_contact_id integer NOT NULL
);


ALTER TABLE public.mailing_contact_mailing_contact_to_list_rel OWNER TO runbot;

--
-- Name: TABLE mailing_contact_mailing_contact_to_list_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_contact_mailing_contact_to_list_rel IS 'RELATION BETWEEN mailing_contact_to_list AND mailing_contact';


--
-- Name: mailing_contact_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_contact_res_partner_category_rel (
    mailing_contact_id integer NOT NULL,
    res_partner_category_id integer NOT NULL
);


ALTER TABLE public.mailing_contact_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE mailing_contact_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_contact_res_partner_category_rel IS 'RELATION BETWEEN mailing_contact AND res_partner_category';


--
-- Name: mailing_contact_to_list; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_contact_to_list (
    id integer NOT NULL,
    mailing_list_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mailing_contact_to_list OWNER TO runbot;

--
-- Name: TABLE mailing_contact_to_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_contact_to_list IS 'Add Contacts to Mailing List';


--
-- Name: COLUMN mailing_contact_to_list.mailing_list_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact_to_list.mailing_list_id IS 'Mailing List';


--
-- Name: COLUMN mailing_contact_to_list.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact_to_list.create_uid IS 'Created by';


--
-- Name: COLUMN mailing_contact_to_list.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact_to_list.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mailing_contact_to_list.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact_to_list.create_date IS 'Created on';


--
-- Name: COLUMN mailing_contact_to_list.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_contact_to_list.write_date IS 'Last Updated on';


--
-- Name: mailing_contact_to_list_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mailing_contact_to_list_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mailing_contact_to_list_id_seq OWNER TO runbot;

--
-- Name: mailing_contact_to_list_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mailing_contact_to_list_id_seq OWNED BY public.mailing_contact_to_list.id;


--
-- Name: mailing_filter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_filter (
    id integer NOT NULL,
    create_uid integer,
    mailing_model_id integer NOT NULL,
    write_uid integer,
    name character varying NOT NULL,
    mailing_domain character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mailing_filter OWNER TO runbot;

--
-- Name: TABLE mailing_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_filter IS 'Mailing Favorite Filters';


--
-- Name: COLUMN mailing_filter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_filter.create_uid IS 'Saved by';


--
-- Name: COLUMN mailing_filter.mailing_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_filter.mailing_model_id IS 'Recipients Model';


--
-- Name: COLUMN mailing_filter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_filter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mailing_filter.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_filter.name IS 'Filter Name';


--
-- Name: COLUMN mailing_filter.mailing_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_filter.mailing_domain IS 'Filter Domain';


--
-- Name: COLUMN mailing_filter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_filter.create_date IS 'Created on';


--
-- Name: COLUMN mailing_filter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_filter.write_date IS 'Last Updated on';


--
-- Name: mailing_filter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mailing_filter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mailing_filter_id_seq OWNER TO runbot;

--
-- Name: mailing_filter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mailing_filter_id_seq OWNED BY public.mailing_filter.id;


--
-- Name: mailing_list; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_list (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    is_public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mailing_list OWNER TO runbot;

--
-- Name: TABLE mailing_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_list IS 'Mailing List';


--
-- Name: COLUMN mailing_list.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_list.create_uid IS 'Created by';


--
-- Name: COLUMN mailing_list.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_list.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mailing_list.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_list.name IS 'Mailing List';


--
-- Name: COLUMN mailing_list.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_list.active IS 'Active';


--
-- Name: COLUMN mailing_list.is_public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_list.is_public IS 'Show In Preferences';


--
-- Name: COLUMN mailing_list.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_list.create_date IS 'Created on';


--
-- Name: COLUMN mailing_list.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_list.write_date IS 'Last Updated on';


--
-- Name: mailing_list_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mailing_list_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mailing_list_id_seq OWNER TO runbot;

--
-- Name: mailing_list_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mailing_list_id_seq OWNED BY public.mailing_list.id;


--
-- Name: mailing_list_mailing_list_merge_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_list_mailing_list_merge_rel (
    mailing_list_merge_id integer NOT NULL,
    mailing_list_id integer NOT NULL
);


ALTER TABLE public.mailing_list_mailing_list_merge_rel OWNER TO runbot;

--
-- Name: TABLE mailing_list_mailing_list_merge_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_list_mailing_list_merge_rel IS 'RELATION BETWEEN mailing_list_merge AND mailing_list';


--
-- Name: mailing_list_merge; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_list_merge (
    id integer NOT NULL,
    dest_list_id integer,
    create_uid integer,
    write_uid integer,
    merge_options character varying NOT NULL,
    new_list_name character varying,
    archive_src_lists boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mailing_list_merge OWNER TO runbot;

--
-- Name: TABLE mailing_list_merge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_list_merge IS 'Merge Mass Mailing List';


--
-- Name: COLUMN mailing_list_merge.dest_list_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_list_merge.dest_list_id IS 'Destination Mailing List';


--
-- Name: COLUMN mailing_list_merge.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_list_merge.create_uid IS 'Created by';


--
-- Name: COLUMN mailing_list_merge.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_list_merge.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mailing_list_merge.merge_options; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_list_merge.merge_options IS 'Merge Option';


--
-- Name: COLUMN mailing_list_merge.new_list_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_list_merge.new_list_name IS 'New Mailing List Name';


--
-- Name: COLUMN mailing_list_merge.archive_src_lists; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_list_merge.archive_src_lists IS 'Archive source mailing lists';


--
-- Name: COLUMN mailing_list_merge.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_list_merge.create_date IS 'Created on';


--
-- Name: COLUMN mailing_list_merge.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_list_merge.write_date IS 'Last Updated on';


--
-- Name: mailing_list_merge_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mailing_list_merge_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mailing_list_merge_id_seq OWNER TO runbot;

--
-- Name: mailing_list_merge_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mailing_list_merge_id_seq OWNED BY public.mailing_list_merge.id;


--
-- Name: mailing_mailing; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_mailing (
    id integer NOT NULL,
    source_id integer NOT NULL,
    campaign_id integer,
    medium_id integer,
    color integer,
    user_id integer,
    mailing_model_id integer NOT NULL,
    mail_server_id integer,
    mailing_filter_id integer,
    ab_testing_pc integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying NOT NULL,
    preview character varying,
    email_from character varying NOT NULL,
    schedule_type character varying NOT NULL,
    state character varying NOT NULL,
    mailing_type character varying NOT NULL,
    reply_to_mode character varying,
    reply_to character varying,
    mailing_domain character varying,
    body_arch text,
    body_html text,
    active boolean,
    favorite boolean,
    keep_archives boolean,
    ab_testing_enabled boolean,
    kpi_mail_required boolean,
    favorite_date timestamp without time zone,
    sent_date timestamp without time zone,
    schedule_date timestamp without time zone,
    calendar_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sms_template_id integer,
    body_plaintext text,
    sms_force_send boolean,
    sms_allow_unsubscribe boolean,
    sending_type character varying,
    CONSTRAINT mailing_mailing_percentage_valid CHECK (((ab_testing_pc >= 0) AND (ab_testing_pc <= 100)))
);


ALTER TABLE public.mailing_mailing OWNER TO runbot;

--
-- Name: TABLE mailing_mailing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_mailing IS 'Mass Mailing';


--
-- Name: COLUMN mailing_mailing.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.source_id IS 'Source';


--
-- Name: COLUMN mailing_mailing.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.campaign_id IS 'UTM Campaign';


--
-- Name: COLUMN mailing_mailing.medium_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.medium_id IS 'Medium';


--
-- Name: COLUMN mailing_mailing.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.color IS 'Color Index';


--
-- Name: COLUMN mailing_mailing.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.user_id IS 'Responsible';


--
-- Name: COLUMN mailing_mailing.mailing_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.mailing_model_id IS 'Recipients Model';


--
-- Name: COLUMN mailing_mailing.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.mail_server_id IS 'Mail Server';


--
-- Name: COLUMN mailing_mailing.mailing_filter_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.mailing_filter_id IS 'Favorite Filter';


--
-- Name: COLUMN mailing_mailing.ab_testing_pc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.ab_testing_pc IS 'A/B Testing percentage';


--
-- Name: COLUMN mailing_mailing.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.create_uid IS 'Created by';


--
-- Name: COLUMN mailing_mailing.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mailing_mailing.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.lang IS 'Language';


--
-- Name: COLUMN mailing_mailing.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.subject IS 'Subject';


--
-- Name: COLUMN mailing_mailing.preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.preview IS 'Preview';


--
-- Name: COLUMN mailing_mailing.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.email_from IS 'Send From';


--
-- Name: COLUMN mailing_mailing.schedule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.schedule_type IS 'Schedule';


--
-- Name: COLUMN mailing_mailing.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.state IS 'Status';


--
-- Name: COLUMN mailing_mailing.mailing_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.mailing_type IS 'Mailing Type';


--
-- Name: COLUMN mailing_mailing.reply_to_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.reply_to_mode IS 'Reply-To Mode';


--
-- Name: COLUMN mailing_mailing.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.reply_to IS 'Reply To';


--
-- Name: COLUMN mailing_mailing.mailing_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.mailing_domain IS 'Domain';


--
-- Name: COLUMN mailing_mailing.body_arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.body_arch IS 'Body';


--
-- Name: COLUMN mailing_mailing.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.body_html IS 'Body converted to be sent by mail';


--
-- Name: COLUMN mailing_mailing.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.active IS 'Active';


--
-- Name: COLUMN mailing_mailing.favorite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.favorite IS 'Favorite';


--
-- Name: COLUMN mailing_mailing.keep_archives; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.keep_archives IS 'Keep Archives';


--
-- Name: COLUMN mailing_mailing.ab_testing_enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.ab_testing_enabled IS 'Allow A/B Testing';


--
-- Name: COLUMN mailing_mailing.kpi_mail_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.kpi_mail_required IS 'KPI mail required';


--
-- Name: COLUMN mailing_mailing.favorite_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.favorite_date IS 'Favorite Date';


--
-- Name: COLUMN mailing_mailing.sent_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.sent_date IS 'Sent Date';


--
-- Name: COLUMN mailing_mailing.schedule_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.schedule_date IS 'Scheduled for';


--
-- Name: COLUMN mailing_mailing.calendar_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.calendar_date IS 'Calendar Date';


--
-- Name: COLUMN mailing_mailing.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.create_date IS 'Created on';


--
-- Name: COLUMN mailing_mailing.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.write_date IS 'Last Updated on';


--
-- Name: COLUMN mailing_mailing.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN mailing_mailing.body_plaintext; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.body_plaintext IS 'SMS Body';


--
-- Name: COLUMN mailing_mailing.sms_force_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.sms_force_send IS 'Send Directly';


--
-- Name: COLUMN mailing_mailing.sms_allow_unsubscribe; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.sms_allow_unsubscribe IS 'Include opt-out link';


--
-- Name: COLUMN mailing_mailing.sending_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing.sending_type IS 'Sending type';


--
-- Name: CONSTRAINT mailing_mailing_percentage_valid ON mailing_mailing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mailing_mailing_percentage_valid ON public.mailing_mailing IS 'CHECK(ab_testing_pc >= 0 AND ab_testing_pc <= 100)';


--
-- Name: mailing_mailing_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mailing_mailing_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mailing_mailing_id_seq OWNER TO runbot;

--
-- Name: mailing_mailing_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mailing_mailing_id_seq OWNED BY public.mailing_mailing.id;


--
-- Name: mailing_mailing_schedule_date; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_mailing_schedule_date (
    id integer NOT NULL,
    mass_mailing_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    schedule_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mailing_mailing_schedule_date OWNER TO runbot;

--
-- Name: TABLE mailing_mailing_schedule_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_mailing_schedule_date IS 'schedule a mailing';


--
-- Name: COLUMN mailing_mailing_schedule_date.mass_mailing_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing_schedule_date.mass_mailing_id IS 'Mass Mailing';


--
-- Name: COLUMN mailing_mailing_schedule_date.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing_schedule_date.create_uid IS 'Created by';


--
-- Name: COLUMN mailing_mailing_schedule_date.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing_schedule_date.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mailing_mailing_schedule_date.schedule_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing_schedule_date.schedule_date IS 'Scheduled for';


--
-- Name: COLUMN mailing_mailing_schedule_date.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing_schedule_date.create_date IS 'Created on';


--
-- Name: COLUMN mailing_mailing_schedule_date.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing_schedule_date.write_date IS 'Last Updated on';


--
-- Name: mailing_mailing_schedule_date_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mailing_mailing_schedule_date_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mailing_mailing_schedule_date_id_seq OWNER TO runbot;

--
-- Name: mailing_mailing_schedule_date_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mailing_mailing_schedule_date_id_seq OWNED BY public.mailing_mailing_schedule_date.id;


--
-- Name: mailing_mailing_test; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_mailing_test (
    id integer NOT NULL,
    mass_mailing_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email_to text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mailing_mailing_test OWNER TO runbot;

--
-- Name: TABLE mailing_mailing_test; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_mailing_test IS 'Sample Mail Wizard';


--
-- Name: COLUMN mailing_mailing_test.mass_mailing_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing_test.mass_mailing_id IS 'Mailing';


--
-- Name: COLUMN mailing_mailing_test.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing_test.create_uid IS 'Created by';


--
-- Name: COLUMN mailing_mailing_test.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mailing_mailing_test.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing_test.email_to IS 'Recipients';


--
-- Name: COLUMN mailing_mailing_test.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing_test.create_date IS 'Created on';


--
-- Name: COLUMN mailing_mailing_test.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_mailing_test.write_date IS 'Last Updated on';


--
-- Name: mailing_mailing_test_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mailing_mailing_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mailing_mailing_test_id_seq OWNER TO runbot;

--
-- Name: mailing_mailing_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mailing_mailing_test_id_seq OWNED BY public.mailing_mailing_test.id;


--
-- Name: mailing_sms_test; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_sms_test (
    id integer NOT NULL,
    mailing_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    numbers text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mailing_sms_test OWNER TO runbot;

--
-- Name: TABLE mailing_sms_test; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_sms_test IS 'Test SMS Mailing';


--
-- Name: COLUMN mailing_sms_test.mailing_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_sms_test.mailing_id IS 'Mailing';


--
-- Name: COLUMN mailing_sms_test.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_sms_test.create_uid IS 'Created by';


--
-- Name: COLUMN mailing_sms_test.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_sms_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mailing_sms_test.numbers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_sms_test.numbers IS 'Number(s)';


--
-- Name: COLUMN mailing_sms_test.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_sms_test.create_date IS 'Created on';


--
-- Name: COLUMN mailing_sms_test.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_sms_test.write_date IS 'Last Updated on';


--
-- Name: mailing_sms_test_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mailing_sms_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mailing_sms_test_id_seq OWNER TO runbot;

--
-- Name: mailing_sms_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mailing_sms_test_id_seq OWNED BY public.mailing_sms_test.id;


--
-- Name: mailing_subscription; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_subscription (
    id integer NOT NULL,
    contact_id integer NOT NULL,
    list_id integer NOT NULL,
    opt_out_reason_id integer,
    create_uid integer,
    write_uid integer,
    opt_out boolean,
    opt_out_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mailing_subscription OWNER TO runbot;

--
-- Name: TABLE mailing_subscription; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_subscription IS 'Mailing List Subscription';


--
-- Name: COLUMN mailing_subscription.contact_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription.contact_id IS 'Contact';


--
-- Name: COLUMN mailing_subscription.list_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription.list_id IS 'Mailing List';


--
-- Name: COLUMN mailing_subscription.opt_out_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription.opt_out_reason_id IS 'Reason';


--
-- Name: COLUMN mailing_subscription.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription.create_uid IS 'Created by';


--
-- Name: COLUMN mailing_subscription.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mailing_subscription.opt_out; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription.opt_out IS 'Opt Out';


--
-- Name: COLUMN mailing_subscription.opt_out_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription.opt_out_datetime IS 'Unsubscription Date';


--
-- Name: COLUMN mailing_subscription.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription.create_date IS 'Created on';


--
-- Name: COLUMN mailing_subscription.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription.write_date IS 'Last Updated on';


--
-- Name: mailing_subscription_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mailing_subscription_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mailing_subscription_id_seq OWNER TO runbot;

--
-- Name: mailing_subscription_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mailing_subscription_id_seq OWNED BY public.mailing_subscription.id;


--
-- Name: mailing_subscription_optout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_subscription_optout (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb,
    is_feedback boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mailing_subscription_optout OWNER TO runbot;

--
-- Name: TABLE mailing_subscription_optout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_subscription_optout IS 'Mailing Subscription Reason';


--
-- Name: COLUMN mailing_subscription_optout.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription_optout.sequence IS 'Sequence';


--
-- Name: COLUMN mailing_subscription_optout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription_optout.create_uid IS 'Created by';


--
-- Name: COLUMN mailing_subscription_optout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription_optout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mailing_subscription_optout.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription_optout.name IS 'Reason';


--
-- Name: COLUMN mailing_subscription_optout.is_feedback; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription_optout.is_feedback IS 'Ask For Feedback';


--
-- Name: COLUMN mailing_subscription_optout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription_optout.create_date IS 'Created on';


--
-- Name: COLUMN mailing_subscription_optout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_subscription_optout.write_date IS 'Last Updated on';


--
-- Name: mailing_subscription_optout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mailing_subscription_optout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mailing_subscription_optout_id_seq OWNER TO runbot;

--
-- Name: mailing_subscription_optout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mailing_subscription_optout_id_seq OWNED BY public.mailing_subscription_optout.id;


--
-- Name: mailing_trace; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mailing_trace (
    id integer NOT NULL,
    mail_mail_id integer,
    mail_mail_id_int integer,
    res_id integer,
    mass_mailing_id integer,
    campaign_id integer,
    create_uid integer,
    write_uid integer,
    trace_type character varying NOT NULL,
    email character varying,
    message_id character varying,
    model character varying NOT NULL,
    trace_status character varying,
    failure_type character varying,
    failure_reason text,
    sent_datetime timestamp without time zone,
    open_datetime timestamp without time zone,
    reply_datetime timestamp without time zone,
    links_click_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sms_id_int integer,
    sms_number character varying,
    sms_code character varying,
    CONSTRAINT mailing_trace_check_res_id_is_set CHECK (((res_id IS NOT NULL) AND (res_id <> 0)))
);


ALTER TABLE public.mailing_trace OWNER TO runbot;

--
-- Name: TABLE mailing_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mailing_trace IS 'Mailing Statistics';


--
-- Name: COLUMN mailing_trace.mail_mail_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.mail_mail_id IS 'Mail';


--
-- Name: COLUMN mailing_trace.mail_mail_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.mail_mail_id_int IS 'Mail ID (tech)';


--
-- Name: COLUMN mailing_trace.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.res_id IS 'Document ID';


--
-- Name: COLUMN mailing_trace.mass_mailing_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.mass_mailing_id IS 'Mailing';


--
-- Name: COLUMN mailing_trace.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.campaign_id IS 'Campaign';


--
-- Name: COLUMN mailing_trace.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.create_uid IS 'Created by';


--
-- Name: COLUMN mailing_trace.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mailing_trace.trace_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.trace_type IS 'Type';


--
-- Name: COLUMN mailing_trace.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.email IS 'Email';


--
-- Name: COLUMN mailing_trace.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.message_id IS 'Message-ID';


--
-- Name: COLUMN mailing_trace.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.model IS 'Document model';


--
-- Name: COLUMN mailing_trace.trace_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.trace_status IS 'Status';


--
-- Name: COLUMN mailing_trace.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.failure_type IS 'Failure type';


--
-- Name: COLUMN mailing_trace.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.failure_reason IS 'Failure reason';


--
-- Name: COLUMN mailing_trace.sent_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.sent_datetime IS 'Sent On';


--
-- Name: COLUMN mailing_trace.open_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.open_datetime IS 'Opened On';


--
-- Name: COLUMN mailing_trace.reply_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.reply_datetime IS 'Replied On';


--
-- Name: COLUMN mailing_trace.links_click_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.links_click_datetime IS 'Clicked On';


--
-- Name: COLUMN mailing_trace.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.create_date IS 'Created on';


--
-- Name: COLUMN mailing_trace.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.write_date IS 'Last Updated on';


--
-- Name: COLUMN mailing_trace.sms_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.sms_id_int IS 'SMS ID';


--
-- Name: COLUMN mailing_trace.sms_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.sms_number IS 'Number';


--
-- Name: COLUMN mailing_trace.sms_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mailing_trace.sms_code IS 'Code';


--
-- Name: CONSTRAINT mailing_trace_check_res_id_is_set ON mailing_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mailing_trace_check_res_id_is_set ON public.mailing_trace IS 'CHECK(res_id IS NOT NULL AND res_id !=0 )';


--
-- Name: mailing_trace_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mailing_trace_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mailing_trace_id_seq OWNER TO runbot;

--
-- Name: mailing_trace_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mailing_trace_id_seq OWNED BY public.mailing_trace.id;


--
-- Name: utm_campaign; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.utm_campaign (
    id integer NOT NULL,
    user_id integer NOT NULL,
    stage_id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    title jsonb NOT NULL,
    active boolean,
    is_auto_campaign boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    ab_testing_winner_mailing_id integer,
    ab_testing_winner_selection character varying,
    ab_testing_completed boolean,
    ab_testing_schedule_datetime timestamp without time zone,
    ab_testing_sms_winner_selection character varying,
    company_id integer
);


ALTER TABLE public.utm_campaign OWNER TO runbot;

--
-- Name: TABLE utm_campaign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.utm_campaign IS 'UTM Campaign';


--
-- Name: COLUMN utm_campaign.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.user_id IS 'Responsible';


--
-- Name: COLUMN utm_campaign.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.stage_id IS 'Stage';


--
-- Name: COLUMN utm_campaign.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.color IS 'Color Index';


--
-- Name: COLUMN utm_campaign.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.create_uid IS 'Created by';


--
-- Name: COLUMN utm_campaign.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_campaign.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.name IS 'Campaign Identifier';


--
-- Name: COLUMN utm_campaign.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.title IS 'Campaign Name';


--
-- Name: COLUMN utm_campaign.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.active IS 'Active';


--
-- Name: COLUMN utm_campaign.is_auto_campaign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.is_auto_campaign IS 'Automatically Generated Campaign';


--
-- Name: COLUMN utm_campaign.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.create_date IS 'Created on';


--
-- Name: COLUMN utm_campaign.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.write_date IS 'Last Updated on';


--
-- Name: COLUMN utm_campaign.ab_testing_winner_mailing_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.ab_testing_winner_mailing_id IS 'A/B Campaign Winner Mailing';


--
-- Name: COLUMN utm_campaign.ab_testing_winner_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.ab_testing_winner_selection IS 'Winner Selection';


--
-- Name: COLUMN utm_campaign.ab_testing_completed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.ab_testing_completed IS 'A/B Testing Campaign Finished';


--
-- Name: COLUMN utm_campaign.ab_testing_schedule_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.ab_testing_schedule_datetime IS 'Send Final On';


--
-- Name: COLUMN utm_campaign.ab_testing_sms_winner_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.ab_testing_sms_winner_selection IS 'SMS Winner Selection';


--
-- Name: COLUMN utm_campaign.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.company_id IS 'Company';


--
-- Name: utm_source; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.utm_source (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.utm_source OWNER TO runbot;

--
-- Name: TABLE utm_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.utm_source IS 'UTM Source';


--
-- Name: COLUMN utm_source.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_source.create_uid IS 'Created by';


--
-- Name: COLUMN utm_source.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_source.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_source.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_source.name IS 'Source Name';


--
-- Name: COLUMN utm_source.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_source.create_date IS 'Created on';


--
-- Name: COLUMN utm_source.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_source.write_date IS 'Last Updated on';


--
-- Name: mailing_trace_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.mailing_trace_report AS
 SELECT min(trace.id) AS id,
    utm_source.name,
    mailing.mailing_type,
    utm_campaign.name AS campaign,
    trace.create_date AS scheduled_date,
    mailing.state,
    mailing.email_from,
    count(trace.id) AS scheduled,
    count(trace.sent_datetime) AS sent,
    (count(trace.id) - count(trace.trace_status) FILTER (WHERE ((trace.trace_status)::text = ANY ((ARRAY['outgoing'::character varying, 'pending'::character varying, 'process'::character varying, 'error'::character varying, 'bounce'::character varying, 'cancel'::character varying])::text[])))) AS delivered,
    count(trace.trace_status) FILTER (WHERE ((trace.trace_status)::text = 'process'::text)) AS processing,
    count(trace.trace_status) FILTER (WHERE ((trace.trace_status)::text = 'pending'::text)) AS pending,
    count(trace.trace_status) FILTER (WHERE ((trace.trace_status)::text = 'error'::text)) AS error,
    count(trace.trace_status) FILTER (WHERE ((trace.trace_status)::text = 'bounce'::text)) AS bounced,
    count(trace.trace_status) FILTER (WHERE ((trace.trace_status)::text = 'cancel'::text)) AS canceled,
    count(trace.trace_status) FILTER (WHERE ((trace.trace_status)::text = 'open'::text)) AS opened,
    count(trace.trace_status) FILTER (WHERE ((trace.trace_status)::text = 'reply'::text)) AS replied,
    count(trace.links_click_datetime) AS clicked
   FROM (((public.mailing_trace trace
     LEFT JOIN public.mailing_mailing mailing ON ((trace.mass_mailing_id = mailing.id)))
     LEFT JOIN public.utm_campaign utm_campaign ON ((mailing.campaign_id = utm_campaign.id)))
     LEFT JOIN public.utm_source utm_source ON ((mailing.source_id = utm_source.id)))
  GROUP BY trace.create_date, utm_source.name, utm_campaign.name, mailing.mailing_type, mailing.state, mailing.email_from;


ALTER VIEW public.mailing_trace_report OWNER TO runbot;

--
-- Name: mass_mailing_ir_attachments_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mass_mailing_ir_attachments_rel (
    mass_mailing_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.mass_mailing_ir_attachments_rel OWNER TO runbot;

--
-- Name: TABLE mass_mailing_ir_attachments_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mass_mailing_ir_attachments_rel IS 'RELATION BETWEEN mailing_mailing AND ir_attachment';


--
-- Name: meeting_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.meeting_category_rel (
    event_id integer NOT NULL,
    type_id integer NOT NULL
);


ALTER TABLE public.meeting_category_rel OWNER TO runbot;

--
-- Name: TABLE meeting_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.meeting_category_rel IS 'RELATION BETWEEN calendar_event AND calendar_event_type';


--
-- Name: merge_opportunity_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.merge_opportunity_rel (
    merge_id integer NOT NULL,
    opportunity_id integer NOT NULL
);


ALTER TABLE public.merge_opportunity_rel OWNER TO runbot;

--
-- Name: TABLE merge_opportunity_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.merge_opportunity_rel IS 'RELATION BETWEEN crm_merge_opportunity AND crm_lead';


--
-- Name: message_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.message_attachment_rel (
    message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.message_attachment_rel OWNER TO runbot;

--
-- Name: TABLE message_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.message_attachment_rel IS 'RELATION BETWEEN mail_message AND ir_attachment';


--
-- Name: module_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_country (
    module_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.module_country OWNER TO runbot;

--
-- Name: TABLE module_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_country IS 'RELATION BETWEEN ir_module_module AND res_country';


--
-- Name: onboarding_onboarding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.onboarding_onboarding (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    route_name character varying NOT NULL,
    text_completed character varying,
    panel_close_action_name character varying,
    name jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.onboarding_onboarding OWNER TO runbot;

--
-- Name: TABLE onboarding_onboarding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.onboarding_onboarding IS 'Onboarding';


--
-- Name: COLUMN onboarding_onboarding.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.sequence IS 'Sequence';


--
-- Name: COLUMN onboarding_onboarding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.create_uid IS 'Created by';


--
-- Name: COLUMN onboarding_onboarding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN onboarding_onboarding.route_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.route_name IS 'One word name';


--
-- Name: COLUMN onboarding_onboarding.text_completed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.text_completed IS 'Message at completion';


--
-- Name: COLUMN onboarding_onboarding.panel_close_action_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.panel_close_action_name IS 'Closing action';


--
-- Name: COLUMN onboarding_onboarding.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.name IS 'Name of the onboarding';


--
-- Name: COLUMN onboarding_onboarding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.create_date IS 'Created on';


--
-- Name: COLUMN onboarding_onboarding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.write_date IS 'Last Updated on';


--
-- Name: onboarding_onboarding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.onboarding_onboarding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.onboarding_onboarding_id_seq OWNER TO runbot;

--
-- Name: onboarding_onboarding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.onboarding_onboarding_id_seq OWNED BY public.onboarding_onboarding.id;


--
-- Name: onboarding_onboarding_onboarding_onboarding_step_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.onboarding_onboarding_onboarding_onboarding_step_rel (
    onboarding_onboarding_id integer NOT NULL,
    onboarding_onboarding_step_id integer NOT NULL
);


ALTER TABLE public.onboarding_onboarding_onboarding_onboarding_step_rel OWNER TO runbot;

--
-- Name: TABLE onboarding_onboarding_onboarding_onboarding_step_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.onboarding_onboarding_onboarding_onboarding_step_rel IS 'RELATION BETWEEN onboarding_onboarding AND onboarding_onboarding_step';


--
-- Name: onboarding_onboarding_step; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.onboarding_onboarding_step (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    done_icon character varying,
    step_image_filename character varying,
    panel_step_open_action_name character varying,
    title jsonb,
    description jsonb,
    button_text jsonb NOT NULL,
    done_text jsonb,
    step_image_alt jsonb,
    is_per_company boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.onboarding_onboarding_step OWNER TO runbot;

--
-- Name: TABLE onboarding_onboarding_step; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.onboarding_onboarding_step IS 'Onboarding Step';


--
-- Name: COLUMN onboarding_onboarding_step.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.sequence IS 'Sequence';


--
-- Name: COLUMN onboarding_onboarding_step.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.create_uid IS 'Created by';


--
-- Name: COLUMN onboarding_onboarding_step.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN onboarding_onboarding_step.done_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.done_icon IS 'Font Awesome Icon when completed';


--
-- Name: COLUMN onboarding_onboarding_step.step_image_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.step_image_filename IS 'Step Image Filename';


--
-- Name: COLUMN onboarding_onboarding_step.panel_step_open_action_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.panel_step_open_action_name IS 'Opening action';


--
-- Name: COLUMN onboarding_onboarding_step.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.title IS 'Title';


--
-- Name: COLUMN onboarding_onboarding_step.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.description IS 'Description';


--
-- Name: COLUMN onboarding_onboarding_step.button_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.button_text IS 'Button text';


--
-- Name: COLUMN onboarding_onboarding_step.done_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.done_text IS 'Text to show when step is completed';


--
-- Name: COLUMN onboarding_onboarding_step.step_image_alt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.step_image_alt IS 'Alt Text for the Step Image';


--
-- Name: COLUMN onboarding_onboarding_step.is_per_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.is_per_company IS 'Is per company';


--
-- Name: COLUMN onboarding_onboarding_step.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.create_date IS 'Created on';


--
-- Name: COLUMN onboarding_onboarding_step.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.write_date IS 'Last Updated on';


--
-- Name: onboarding_onboarding_step_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.onboarding_onboarding_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.onboarding_onboarding_step_id_seq OWNER TO runbot;

--
-- Name: onboarding_onboarding_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.onboarding_onboarding_step_id_seq OWNED BY public.onboarding_onboarding_step.id;


--
-- Name: onboarding_progress; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.onboarding_progress (
    id integer NOT NULL,
    company_id integer,
    onboarding_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    onboarding_state character varying,
    is_onboarding_closed boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.onboarding_progress OWNER TO runbot;

--
-- Name: TABLE onboarding_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.onboarding_progress IS 'Onboarding Progress Tracker';


--
-- Name: COLUMN onboarding_progress.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.company_id IS 'Company';


--
-- Name: COLUMN onboarding_progress.onboarding_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.onboarding_id IS 'Related onboarding tracked';


--
-- Name: COLUMN onboarding_progress.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.create_uid IS 'Created by';


--
-- Name: COLUMN onboarding_progress.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.write_uid IS 'Last Updated by';


--
-- Name: COLUMN onboarding_progress.onboarding_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.onboarding_state IS 'Onboarding progress';


--
-- Name: COLUMN onboarding_progress.is_onboarding_closed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.is_onboarding_closed IS 'Was panel closed?';


--
-- Name: COLUMN onboarding_progress.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.create_date IS 'Created on';


--
-- Name: COLUMN onboarding_progress.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.write_date IS 'Last Updated on';


--
-- Name: onboarding_progress_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.onboarding_progress_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.onboarding_progress_id_seq OWNER TO runbot;

--
-- Name: onboarding_progress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.onboarding_progress_id_seq OWNED BY public.onboarding_progress.id;


--
-- Name: onboarding_progress_onboarding_progress_step_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.onboarding_progress_onboarding_progress_step_rel (
    onboarding_progress_id integer NOT NULL,
    onboarding_progress_step_id integer NOT NULL
);


ALTER TABLE public.onboarding_progress_onboarding_progress_step_rel OWNER TO runbot;

--
-- Name: TABLE onboarding_progress_onboarding_progress_step_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.onboarding_progress_onboarding_progress_step_rel IS 'RELATION BETWEEN onboarding_progress AND onboarding_progress_step';


--
-- Name: onboarding_progress_step; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.onboarding_progress_step (
    id integer NOT NULL,
    step_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    step_state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.onboarding_progress_step OWNER TO runbot;

--
-- Name: TABLE onboarding_progress_step; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.onboarding_progress_step IS 'Onboarding Progress Step Tracker';


--
-- Name: COLUMN onboarding_progress_step.step_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress_step.step_id IS 'Onboarding Step';


--
-- Name: COLUMN onboarding_progress_step.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress_step.company_id IS 'Company';


--
-- Name: COLUMN onboarding_progress_step.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress_step.create_uid IS 'Created by';


--
-- Name: COLUMN onboarding_progress_step.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN onboarding_progress_step.step_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress_step.step_state IS 'Onboarding Step Progress';


--
-- Name: COLUMN onboarding_progress_step.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress_step.create_date IS 'Created on';


--
-- Name: COLUMN onboarding_progress_step.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress_step.write_date IS 'Last Updated on';


--
-- Name: onboarding_progress_step_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.onboarding_progress_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.onboarding_progress_step_id_seq OWNER TO runbot;

--
-- Name: onboarding_progress_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.onboarding_progress_step_id_seq OWNED BY public.onboarding_progress_step.id;


--
-- Name: payment_capture_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_capture_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    amount_to_capture numeric,
    void_remaining_amount boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_capture_wizard OWNER TO runbot;

--
-- Name: TABLE payment_capture_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_capture_wizard IS 'Payment Capture Wizard';


--
-- Name: COLUMN payment_capture_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_capture_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN payment_capture_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_capture_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_capture_wizard.amount_to_capture; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_capture_wizard.amount_to_capture IS 'Amount To Capture';


--
-- Name: COLUMN payment_capture_wizard.void_remaining_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_capture_wizard.void_remaining_amount IS 'Void Remaining Amount';


--
-- Name: COLUMN payment_capture_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_capture_wizard.create_date IS 'Created on';


--
-- Name: COLUMN payment_capture_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_capture_wizard.write_date IS 'Last Updated on';


--
-- Name: payment_capture_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_capture_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_capture_wizard_id_seq OWNER TO runbot;

--
-- Name: payment_capture_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_capture_wizard_id_seq OWNED BY public.payment_capture_wizard.id;


--
-- Name: payment_capture_wizard_payment_transaction_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_capture_wizard_payment_transaction_rel (
    payment_capture_wizard_id integer NOT NULL,
    payment_transaction_id integer NOT NULL
);


ALTER TABLE public.payment_capture_wizard_payment_transaction_rel OWNER TO runbot;

--
-- Name: TABLE payment_capture_wizard_payment_transaction_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_capture_wizard_payment_transaction_rel IS 'RELATION BETWEEN payment_capture_wizard AND payment_transaction';


--
-- Name: payment_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_country_rel (
    payment_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.payment_country_rel OWNER TO runbot;

--
-- Name: TABLE payment_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_country_rel IS 'RELATION BETWEEN payment_provider AND res_country';


--
-- Name: payment_currency_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_currency_rel (
    payment_provider_id integer NOT NULL,
    currency_id integer NOT NULL
);


ALTER TABLE public.payment_currency_rel OWNER TO runbot;

--
-- Name: TABLE payment_currency_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_currency_rel IS 'RELATION BETWEEN payment_provider AND res_currency';


--
-- Name: payment_link_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_link_wizard (
    id integer NOT NULL,
    res_id integer NOT NULL,
    currency_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    amount numeric NOT NULL,
    amount_max numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    discount_date date,
    open_installments jsonb,
    has_eligible_epd boolean,
    amount_paid numeric
);


ALTER TABLE public.payment_link_wizard OWNER TO runbot;

--
-- Name: TABLE payment_link_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_link_wizard IS 'Generate Payment Link';


--
-- Name: COLUMN payment_link_wizard.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.res_id IS 'Related Document ID';


--
-- Name: COLUMN payment_link_wizard.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.currency_id IS 'Currency';


--
-- Name: COLUMN payment_link_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN payment_link_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN payment_link_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_link_wizard.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.res_model IS 'Related Document Model';


--
-- Name: COLUMN payment_link_wizard.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.amount IS 'Amount';


--
-- Name: COLUMN payment_link_wizard.amount_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.amount_max IS 'Amount Max';


--
-- Name: COLUMN payment_link_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.create_date IS 'Created on';


--
-- Name: COLUMN payment_link_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN payment_link_wizard.discount_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.discount_date IS 'Discount Date';


--
-- Name: COLUMN payment_link_wizard.open_installments; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.open_installments IS 'Open Installments';


--
-- Name: COLUMN payment_link_wizard.has_eligible_epd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.has_eligible_epd IS 'Has Eligible Epd';


--
-- Name: COLUMN payment_link_wizard.amount_paid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.amount_paid IS 'Already Paid';


--
-- Name: payment_link_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_link_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_link_wizard_id_seq OWNER TO runbot;

--
-- Name: payment_link_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_link_wizard_id_seq OWNED BY public.payment_link_wizard.id;


--
-- Name: payment_method; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_method (
    id integer NOT NULL,
    sequence integer,
    primary_payment_method_id integer,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    support_refund character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    support_tokenization boolean,
    support_express_checkout boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_method OWNER TO runbot;

--
-- Name: TABLE payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_method IS 'Payment Method';


--
-- Name: COLUMN payment_method.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.sequence IS 'Sequence';


--
-- Name: COLUMN payment_method.primary_payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.primary_payment_method_id IS 'Primary Payment Method';


--
-- Name: COLUMN payment_method.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.create_uid IS 'Created by';


--
-- Name: COLUMN payment_method.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_method.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.code IS 'Code';


--
-- Name: COLUMN payment_method.support_refund; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.support_refund IS 'Refund';


--
-- Name: COLUMN payment_method.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.name IS 'Name';


--
-- Name: COLUMN payment_method.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.active IS 'Active';


--
-- Name: COLUMN payment_method.support_tokenization; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.support_tokenization IS 'Tokenization';


--
-- Name: COLUMN payment_method.support_express_checkout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.support_express_checkout IS 'Express Checkout';


--
-- Name: COLUMN payment_method.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.create_date IS 'Created on';


--
-- Name: COLUMN payment_method.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.write_date IS 'Last Updated on';


--
-- Name: payment_method_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_method_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_method_id_seq OWNER TO runbot;

--
-- Name: payment_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_method_id_seq OWNED BY public.payment_method.id;


--
-- Name: payment_method_payment_provider_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_method_payment_provider_rel (
    payment_method_id integer NOT NULL,
    payment_provider_id integer NOT NULL
);


ALTER TABLE public.payment_method_payment_provider_rel OWNER TO runbot;

--
-- Name: TABLE payment_method_payment_provider_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_method_payment_provider_rel IS 'RELATION BETWEEN payment_method AND payment_provider';


--
-- Name: payment_method_res_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_method_res_country_rel (
    payment_method_id integer NOT NULL,
    res_country_id integer NOT NULL
);


ALTER TABLE public.payment_method_res_country_rel OWNER TO runbot;

--
-- Name: TABLE payment_method_res_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_method_res_country_rel IS 'RELATION BETWEEN payment_method AND res_country';


--
-- Name: payment_method_res_currency_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_method_res_currency_rel (
    payment_method_id integer NOT NULL,
    res_currency_id integer NOT NULL
);


ALTER TABLE public.payment_method_res_currency_rel OWNER TO runbot;

--
-- Name: TABLE payment_method_res_currency_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_method_res_currency_rel IS 'RELATION BETWEEN payment_method AND res_currency';


--
-- Name: payment_provider; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_provider (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    redirect_form_view_id integer,
    inline_form_view_id integer,
    token_inline_form_view_id integer,
    express_checkout_form_view_id integer,
    color integer,
    module_id integer,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    state character varying NOT NULL,
    name jsonb NOT NULL,
    pre_msg jsonb,
    pending_msg jsonb,
    auth_msg jsonb,
    done_msg jsonb,
    cancel_msg jsonb,
    maximum_amount numeric,
    is_published boolean,
    allow_tokenization boolean,
    capture_manually boolean,
    allow_express_checkout boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    so_reference_type character varying,
    website_id integer
);


ALTER TABLE public.payment_provider OWNER TO runbot;

--
-- Name: TABLE payment_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_provider IS 'Payment Provider';


--
-- Name: COLUMN payment_provider.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.sequence IS 'Sequence';


--
-- Name: COLUMN payment_provider.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.company_id IS 'Company';


--
-- Name: COLUMN payment_provider.redirect_form_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.redirect_form_view_id IS 'Redirect Form Template';


--
-- Name: COLUMN payment_provider.inline_form_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.inline_form_view_id IS 'Inline Form Template';


--
-- Name: COLUMN payment_provider.token_inline_form_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.token_inline_form_view_id IS 'Token Inline Form Template';


--
-- Name: COLUMN payment_provider.express_checkout_form_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.express_checkout_form_view_id IS 'Express Checkout Form Template';


--
-- Name: COLUMN payment_provider.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.color IS 'Color';


--
-- Name: COLUMN payment_provider.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.module_id IS 'Corresponding Module';


--
-- Name: COLUMN payment_provider.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.create_uid IS 'Created by';


--
-- Name: COLUMN payment_provider.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_provider.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.code IS 'Code';


--
-- Name: COLUMN payment_provider.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.state IS 'State';


--
-- Name: COLUMN payment_provider.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.name IS 'Name';


--
-- Name: COLUMN payment_provider.pre_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.pre_msg IS 'Help Message';


--
-- Name: COLUMN payment_provider.pending_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.pending_msg IS 'Pending Message';


--
-- Name: COLUMN payment_provider.auth_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.auth_msg IS 'Authorize Message';


--
-- Name: COLUMN payment_provider.done_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.done_msg IS 'Done Message';


--
-- Name: COLUMN payment_provider.cancel_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.cancel_msg IS 'Cancelled Message';


--
-- Name: COLUMN payment_provider.maximum_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.maximum_amount IS 'Maximum Amount';


--
-- Name: COLUMN payment_provider.is_published; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.is_published IS 'Published';


--
-- Name: COLUMN payment_provider.allow_tokenization; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.allow_tokenization IS 'Allow Saving Payment Methods';


--
-- Name: COLUMN payment_provider.capture_manually; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.capture_manually IS 'Capture Amount Manually';


--
-- Name: COLUMN payment_provider.allow_express_checkout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.allow_express_checkout IS 'Allow Express Checkout';


--
-- Name: COLUMN payment_provider.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.create_date IS 'Created on';


--
-- Name: COLUMN payment_provider.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.write_date IS 'Last Updated on';


--
-- Name: COLUMN payment_provider.so_reference_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.so_reference_type IS 'Communication';


--
-- Name: COLUMN payment_provider.website_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.website_id IS 'Website';


--
-- Name: payment_provider_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_provider_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_provider_id_seq OWNER TO runbot;

--
-- Name: payment_provider_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_provider_id_seq OWNED BY public.payment_provider.id;


--
-- Name: payment_provider_onboarding_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_provider_onboarding_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payment_method character varying,
    paypal_email_account character varying,
    manual_name character varying,
    journal_name character varying,
    acc_number character varying,
    manual_post_msg text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_provider_onboarding_wizard OWNER TO runbot;

--
-- Name: TABLE payment_provider_onboarding_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_provider_onboarding_wizard IS 'Payment provider onboarding wizard';


--
-- Name: COLUMN payment_provider_onboarding_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN payment_provider_onboarding_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_provider_onboarding_wizard.payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.payment_method IS 'Payment Method';


--
-- Name: COLUMN payment_provider_onboarding_wizard.paypal_email_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.paypal_email_account IS 'Email';


--
-- Name: COLUMN payment_provider_onboarding_wizard.manual_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.manual_name IS 'Method';


--
-- Name: COLUMN payment_provider_onboarding_wizard.journal_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.journal_name IS 'Bank Name';


--
-- Name: COLUMN payment_provider_onboarding_wizard.acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.acc_number IS 'Account Number';


--
-- Name: COLUMN payment_provider_onboarding_wizard.manual_post_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.manual_post_msg IS 'Payment Instructions';


--
-- Name: COLUMN payment_provider_onboarding_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.create_date IS 'Created on';


--
-- Name: COLUMN payment_provider_onboarding_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.write_date IS 'Last Updated on';


--
-- Name: payment_provider_onboarding_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_provider_onboarding_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_provider_onboarding_wizard_id_seq OWNER TO runbot;

--
-- Name: payment_provider_onboarding_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_provider_onboarding_wizard_id_seq OWNED BY public.payment_provider_onboarding_wizard.id;


--
-- Name: payment_refund_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_refund_wizard (
    id integer NOT NULL,
    payment_id integer,
    create_uid integer,
    write_uid integer,
    amount_to_refund numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_refund_wizard OWNER TO runbot;

--
-- Name: TABLE payment_refund_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_refund_wizard IS 'Payment Refund Wizard';


--
-- Name: COLUMN payment_refund_wizard.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.payment_id IS 'Payment';


--
-- Name: COLUMN payment_refund_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN payment_refund_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_refund_wizard.amount_to_refund; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.amount_to_refund IS 'Refund Amount';


--
-- Name: COLUMN payment_refund_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.create_date IS 'Created on';


--
-- Name: COLUMN payment_refund_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.write_date IS 'Last Updated on';


--
-- Name: payment_refund_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_refund_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_refund_wizard_id_seq OWNER TO runbot;

--
-- Name: payment_refund_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_refund_wizard_id_seq OWNED BY public.payment_refund_wizard.id;


--
-- Name: payment_token; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_token (
    id integer NOT NULL,
    provider_id integer NOT NULL,
    company_id integer,
    payment_method_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payment_details character varying,
    provider_ref character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_token OWNER TO runbot;

--
-- Name: TABLE payment_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_token IS 'Payment Token';


--
-- Name: COLUMN payment_token.provider_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.provider_id IS 'Provider';


--
-- Name: COLUMN payment_token.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.company_id IS 'Company';


--
-- Name: COLUMN payment_token.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN payment_token.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.partner_id IS 'Partner';


--
-- Name: COLUMN payment_token.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.create_uid IS 'Created by';


--
-- Name: COLUMN payment_token.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_token.payment_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.payment_details IS 'Payment Details';


--
-- Name: COLUMN payment_token.provider_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.provider_ref IS 'Provider Reference';


--
-- Name: COLUMN payment_token.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.active IS 'Active';


--
-- Name: COLUMN payment_token.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.create_date IS 'Created on';


--
-- Name: COLUMN payment_token.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.write_date IS 'Last Updated on';


--
-- Name: payment_token_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_token_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_token_id_seq OWNER TO runbot;

--
-- Name: payment_token_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_token_id_seq OWNED BY public.payment_token.id;


--
-- Name: payment_transaction; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_transaction (
    id integer NOT NULL,
    provider_id integer NOT NULL,
    company_id integer,
    payment_method_id integer NOT NULL,
    currency_id integer NOT NULL,
    token_id integer,
    source_transaction_id integer,
    partner_id integer NOT NULL,
    partner_state_id integer,
    partner_country_id integer,
    create_uid integer,
    write_uid integer,
    reference character varying NOT NULL,
    provider_reference character varying,
    state character varying NOT NULL,
    operation character varying,
    landing_route character varying,
    partner_name character varying,
    partner_lang character varying,
    partner_email character varying,
    partner_address character varying,
    partner_zip character varying,
    partner_city character varying,
    partner_phone character varying,
    state_message text,
    amount numeric NOT NULL,
    is_post_processed boolean,
    tokenize boolean,
    last_state_change timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_id integer,
    is_donation boolean
);


ALTER TABLE public.payment_transaction OWNER TO runbot;

--
-- Name: TABLE payment_transaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_transaction IS 'Payment Transaction';


--
-- Name: COLUMN payment_transaction.provider_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.provider_id IS 'Provider';


--
-- Name: COLUMN payment_transaction.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.company_id IS 'Company';


--
-- Name: COLUMN payment_transaction.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN payment_transaction.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.currency_id IS 'Currency';


--
-- Name: COLUMN payment_transaction.token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.token_id IS 'Payment Token';


--
-- Name: COLUMN payment_transaction.source_transaction_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.source_transaction_id IS 'Source Transaction';


--
-- Name: COLUMN payment_transaction.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_id IS 'Customer';


--
-- Name: COLUMN payment_transaction.partner_state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_state_id IS 'State';


--
-- Name: COLUMN payment_transaction.partner_country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_country_id IS 'Country';


--
-- Name: COLUMN payment_transaction.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.create_uid IS 'Created by';


--
-- Name: COLUMN payment_transaction.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_transaction.reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.reference IS 'Reference';


--
-- Name: COLUMN payment_transaction.provider_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.provider_reference IS 'Provider Reference';


--
-- Name: COLUMN payment_transaction.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.state IS 'Status';


--
-- Name: COLUMN payment_transaction.operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.operation IS 'Operation';


--
-- Name: COLUMN payment_transaction.landing_route; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.landing_route IS 'Landing Route';


--
-- Name: COLUMN payment_transaction.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_name IS 'Partner Name';


--
-- Name: COLUMN payment_transaction.partner_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_lang IS 'Language';


--
-- Name: COLUMN payment_transaction.partner_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_email IS 'Email';


--
-- Name: COLUMN payment_transaction.partner_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_address IS 'Address';


--
-- Name: COLUMN payment_transaction.partner_zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_zip IS 'Zip';


--
-- Name: COLUMN payment_transaction.partner_city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_city IS 'City';


--
-- Name: COLUMN payment_transaction.partner_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_phone IS 'Phone';


--
-- Name: COLUMN payment_transaction.state_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.state_message IS 'Message';


--
-- Name: COLUMN payment_transaction.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.amount IS 'Amount';


--
-- Name: COLUMN payment_transaction.is_post_processed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.is_post_processed IS 'Is Post-processed';


--
-- Name: COLUMN payment_transaction.tokenize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.tokenize IS 'Create Token';


--
-- Name: COLUMN payment_transaction.last_state_change; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.last_state_change IS 'Last State Change Date';


--
-- Name: COLUMN payment_transaction.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.create_date IS 'Created on';


--
-- Name: COLUMN payment_transaction.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.write_date IS 'Last Updated on';


--
-- Name: COLUMN payment_transaction.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.payment_id IS 'Payment';


--
-- Name: COLUMN payment_transaction.is_donation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.is_donation IS 'Is donation';


--
-- Name: payment_transaction_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_transaction_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_transaction_id_seq OWNER TO runbot;

--
-- Name: payment_transaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_transaction_id_seq OWNED BY public.payment_transaction.id;


--
-- Name: phone_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    number character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist OWNER TO runbot;

--
-- Name: TABLE phone_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist IS 'Phone Blacklist';


--
-- Name: COLUMN phone_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.number IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.active IS 'Active';


--
-- Name: COLUMN phone_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_id_seq OWNED BY public.phone_blacklist.id;


--
-- Name: phone_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    phone character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE phone_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist_remove IS 'Remove phone from blacklist';


--
-- Name: COLUMN phone_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist_remove.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.phone IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN phone_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNED BY public.phone_blacklist_remove.id;


--
-- Name: portal_share; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_share (
    id integer NOT NULL,
    res_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_share OWNER TO runbot;

--
-- Name: TABLE portal_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_share IS 'Portal Sharing';


--
-- Name: COLUMN portal_share.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.res_id IS 'Related Document ID';


--
-- Name: COLUMN portal_share.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.create_uid IS 'Created by';


--
-- Name: COLUMN portal_share.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_share.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.res_model IS 'Related Document Model';


--
-- Name: COLUMN portal_share.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.note IS 'Note';


--
-- Name: COLUMN portal_share.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.create_date IS 'Created on';


--
-- Name: COLUMN portal_share.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.write_date IS 'Last Updated on';


--
-- Name: portal_share_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_share_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_share_id_seq OWNER TO runbot;

--
-- Name: portal_share_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_share_id_seq OWNED BY public.portal_share.id;


--
-- Name: portal_share_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_share_res_partner_rel (
    portal_share_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.portal_share_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE portal_share_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_share_res_partner_rel IS 'RELATION BETWEEN portal_share AND res_partner';


--
-- Name: portal_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    welcome_message text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_wizard OWNER TO runbot;

--
-- Name: TABLE portal_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard IS 'Grant Portal Access';


--
-- Name: COLUMN portal_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard.welcome_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.welcome_message IS 'Invitation Message';


--
-- Name: COLUMN portal_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.write_date IS 'Last Updated on';


--
-- Name: portal_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_wizard_id_seq OWNER TO runbot;

--
-- Name: portal_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_wizard_id_seq OWNED BY public.portal_wizard.id;


--
-- Name: portal_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard_res_partner_rel (
    portal_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.portal_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE portal_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard_res_partner_rel IS 'RELATION BETWEEN portal_wizard AND res_partner';


--
-- Name: portal_wizard_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_wizard_user OWNER TO runbot;

--
-- Name: TABLE portal_wizard_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard_user IS 'Portal User Config';


--
-- Name: COLUMN portal_wizard_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN portal_wizard_user.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.partner_id IS 'Contact';


--
-- Name: COLUMN portal_wizard_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard_user.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.email IS 'Email';


--
-- Name: COLUMN portal_wizard_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.write_date IS 'Last Updated on';


--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_wizard_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_wizard_user_id_seq OWNER TO runbot;

--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_wizard_user_id_seq OWNED BY public.portal_wizard_user.id;


--
-- Name: privacy_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_log (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    anonymized_name character varying NOT NULL,
    anonymized_email character varying NOT NULL,
    execution_details text,
    records_description text,
    additional_note text,
    date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_log OWNER TO runbot;

--
-- Name: TABLE privacy_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_log IS 'Privacy Log';


--
-- Name: COLUMN privacy_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.user_id IS 'Handled By';


--
-- Name: COLUMN privacy_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_log.anonymized_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_name IS 'Anonymized Name';


--
-- Name: COLUMN privacy_log.anonymized_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_email IS 'Anonymized Email';


--
-- Name: COLUMN privacy_log.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_log.records_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.records_description IS 'Found Records';


--
-- Name: COLUMN privacy_log.additional_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.additional_note IS 'Additional Note';


--
-- Name: COLUMN privacy_log.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.date IS 'Date';


--
-- Name: COLUMN privacy_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_date IS 'Created on';


--
-- Name: COLUMN privacy_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_date IS 'Last Updated on';


--
-- Name: privacy_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_log_id_seq OWNER TO runbot;

--
-- Name: privacy_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_log_id_seq OWNED BY public.privacy_log.id;


--
-- Name: privacy_lookup_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard (
    id integer NOT NULL,
    log_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    email character varying NOT NULL,
    execution_details text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard IS 'Privacy Lookup Wizard';


--
-- Name: COLUMN privacy_lookup_wizard.log_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.log_id IS 'Log';


--
-- Name: COLUMN privacy_lookup_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.name IS 'Name';


--
-- Name: COLUMN privacy_lookup_wizard.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.email IS 'Email';


--
-- Name: COLUMN privacy_lookup_wizard.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNED BY public.privacy_lookup_wizard.id;


--
-- Name: privacy_lookup_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard_line (
    id integer NOT NULL,
    wizard_id integer,
    res_id integer NOT NULL,
    res_model_id integer,
    create_uid integer,
    write_uid integer,
    res_name character varying,
    res_model character varying,
    execution_details character varying,
    has_active boolean,
    is_active boolean,
    is_unlinked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard_line OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard_line IS 'Privacy Lookup Wizard Line';


--
-- Name: COLUMN privacy_lookup_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_id IS 'Resource ID';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model_id IS 'Related Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_name IS 'Resource name';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model IS 'Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard_line.has_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.has_active IS 'Has Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_active IS 'Is Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_unlinked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_unlinked IS 'Is Unlinked';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNED BY public.privacy_lookup_wizard_line.id;


--
-- Name: product_accessory_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_accessory_rel (
    src_id integer NOT NULL,
    dest_id integer NOT NULL
);


ALTER TABLE public.product_accessory_rel OWNER TO runbot;

--
-- Name: TABLE product_accessory_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_accessory_rel IS 'RELATION BETWEEN product_template AND product_product';


--
-- Name: product_alternative_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_alternative_rel (
    src_id integer NOT NULL,
    dest_id integer NOT NULL
);


ALTER TABLE public.product_alternative_rel OWNER TO runbot;

--
-- Name: TABLE product_alternative_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_alternative_rel IS 'RELATION BETWEEN product_template AND product_template';


--
-- Name: product_attr_exclusion_value_ids_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attr_exclusion_value_ids_rel (
    product_template_attribute_exclusion_id integer NOT NULL,
    product_template_attribute_value_id integer NOT NULL
);


ALTER TABLE public.product_attr_exclusion_value_ids_rel OWNER TO runbot;

--
-- Name: TABLE product_attr_exclusion_value_ids_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attr_exclusion_value_ids_rel IS 'RELATION BETWEEN product_template_attribute_exclusion AND product_template_attribute_value';


--
-- Name: product_attribute; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    create_variant character varying NOT NULL,
    display_type character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    visibility character varying,
    CONSTRAINT product_attribute_check_multi_checkbox_no_variant CHECK ((((display_type)::text <> 'multi'::text) OR ((create_variant)::text = 'no_variant'::text)))
);


ALTER TABLE public.product_attribute OWNER TO runbot;

--
-- Name: TABLE product_attribute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute IS 'Product Attribute';


--
-- Name: COLUMN product_attribute.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.sequence IS 'Sequence';


--
-- Name: COLUMN product_attribute.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute.create_variant; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.create_variant IS 'Variant Creation';


--
-- Name: COLUMN product_attribute.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.display_type IS 'Display Type';


--
-- Name: COLUMN product_attribute.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.name IS 'Attribute';


--
-- Name: COLUMN product_attribute.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.active IS 'Active';


--
-- Name: COLUMN product_attribute.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_attribute.visibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.visibility IS 'Visibility';


--
-- Name: CONSTRAINT product_attribute_check_multi_checkbox_no_variant ON product_attribute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT product_attribute_check_multi_checkbox_no_variant ON public.product_attribute IS 'CHECK(display_type != ''multi'' OR create_variant = ''no_variant'')';


--
-- Name: product_attribute_custom_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_custom_value (
    id integer NOT NULL,
    custom_product_template_attribute_value_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    custom_value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sale_order_line_id integer
);


ALTER TABLE public.product_attribute_custom_value OWNER TO runbot;

--
-- Name: TABLE product_attribute_custom_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_custom_value IS 'Product Attribute Custom Value';


--
-- Name: COLUMN product_attribute_custom_value.custom_product_template_attribute_value_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.custom_product_template_attribute_value_id IS 'Attribute Value';


--
-- Name: COLUMN product_attribute_custom_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute_custom_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute_custom_value.custom_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.custom_value IS 'Custom Value';


--
-- Name: COLUMN product_attribute_custom_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute_custom_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_attribute_custom_value.sale_order_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.sale_order_line_id IS 'Sales Order Line';


--
-- Name: product_attribute_custom_value_id_seq; T